/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.format;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.table.format.TypeConverters;
import org.apache.hudi.util.RowDataCastProjection;
import org.apache.hudi.util.RowDataProjection;

public final class CastMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<Integer, Cast> castMap = new HashMap<Integer, Cast>();
    private DataType[] fileFieldTypes;

    public Option<RowDataProjection> toRowDataProjection(int[] selectedFields) {
        if (this.castMap.isEmpty()) {
            return Option.empty();
        }
        LogicalType[] requiredType = new LogicalType[selectedFields.length];
        for (int i = 0; i < selectedFields.length; ++i) {
            requiredType[i] = this.fileFieldTypes[selectedFields[i]].getLogicalType();
        }
        return Option.of((Object)new RowDataCastProjection(requiredType, this));
    }

    public Object castIfNeeded(int pos, Object val) {
        Cast cast = this.castMap.get(pos);
        if (cast == null) {
            return val;
        }
        return cast.convert(val);
    }

    public DataType[] getFileFieldTypes() {
        return this.fileFieldTypes;
    }

    public void setFileFieldTypes(DataType[] fileFieldTypes) {
        this.fileFieldTypes = fileFieldTypes;
    }

    @VisibleForTesting
    void add(int pos, LogicalType fromType, LogicalType toType) {
        TypeConverters.TypeConverter converter = TypeConverters.getInstance(fromType, toType);
        if (converter == null) {
            throw new IllegalArgumentException(String.format("Cannot create cast %s => %s at pos %s", fromType, toType, pos));
        }
        this.add(pos, new Cast(fromType, toType, converter));
    }

    private void add(int pos, Cast cast) {
        this.castMap.put(pos, cast);
    }

    public String toString() {
        return this.castMap.entrySet().stream().map(e -> e.getKey() + ": " + e.getValue()).collect(Collectors.joining(", ", "{", "}"));
    }

    private static final class Cast
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final LogicalType from;
        private final LogicalType to;
        private final TypeConverters.TypeConverter castMapConverter;

        Cast(LogicalType from, LogicalType to, TypeConverters.TypeConverter conversion) {
            this.from = from;
            this.to = to;
            this.castMapConverter = conversion;
        }

        Object convert(Object val) {
            return this.castMapConverter.convert(val);
        }

        public String toString() {
            return this.from + " => " + this.to;
        }
    }
}

