/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.catalog;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.table.catalog.TypeInfoLogicalTypeVisitor;

public class HiveSchemaUtils {
    public static List<String> getFieldNames(List<FieldSchema> fieldSchemas) {
        return fieldSchemas.stream().map(FieldSchema::getName).collect(Collectors.toList());
    }

    public static Schema convertTableSchema(Table hiveTable) {
        List allCols = hiveTable.getSd().getCols().stream().filter(s -> !HoodieAvroUtils.isMetadataField((String)s.getName())).collect(Collectors.toList());
        allCols.addAll(hiveTable.getPartitionKeys());
        String pkConstraintName = (String)hiveTable.getParameters().get("pk.constraint.name");
        String pkColumnStr = (String)hiveTable.getParameters().get(FlinkOptions.RECORD_KEY_FIELD.key());
        List pkColumns = pkColumnStr == null ? new ArrayList() : StringUtils.split((String)pkColumnStr, (String)",");
        String[] colNames = new String[allCols.size()];
        DataType[] colTypes = new DataType[allCols.size()];
        for (int i = 0; i < allCols.size(); ++i) {
            FieldSchema fs = (FieldSchema)allCols.get(i);
            colNames[i] = fs.getName();
            colTypes[i] = HiveSchemaUtils.toFlinkType(TypeInfoUtils.getTypeInfoFromTypeString((String)fs.getType()));
            if (!pkColumns.contains(colNames[i])) continue;
            colTypes[i] = (DataType)colTypes[i].notNull();
        }
        Schema.Builder builder = Schema.newBuilder().fromFields(colNames, (AbstractDataType[])colTypes);
        if (!StringUtils.isNullOrEmpty((String)pkConstraintName)) {
            builder.primaryKeyNamed(pkConstraintName, pkColumns);
        } else if (!pkColumns.isEmpty()) {
            builder.primaryKey(pkColumns);
        }
        return builder.build();
    }

    public static DataType toFlinkType(TypeInfo hiveType) {
        Preconditions.checkNotNull((Object)hiveType, (String)"hiveType cannot be null");
        switch (hiveType.getCategory()) {
            case PRIMITIVE: {
                return HiveSchemaUtils.toFlinkPrimitiveType((PrimitiveTypeInfo)hiveType);
            }
            case LIST: {
                ListTypeInfo listTypeInfo = (ListTypeInfo)hiveType;
                return DataTypes.ARRAY((DataType)HiveSchemaUtils.toFlinkType(listTypeInfo.getListElementTypeInfo()));
            }
            case MAP: {
                MapTypeInfo mapTypeInfo = (MapTypeInfo)hiveType;
                return DataTypes.MAP((DataType)HiveSchemaUtils.toFlinkType(mapTypeInfo.getMapKeyTypeInfo()), (DataType)HiveSchemaUtils.toFlinkType(mapTypeInfo.getMapValueTypeInfo()));
            }
            case STRUCT: {
                StructTypeInfo structTypeInfo = (StructTypeInfo)hiveType;
                ArrayList names = structTypeInfo.getAllStructFieldNames();
                ArrayList typeInfos = structTypeInfo.getAllStructFieldTypeInfos();
                DataTypes.Field[] fields = new DataTypes.Field[names.size()];
                for (int i = 0; i < fields.length; ++i) {
                    fields[i] = DataTypes.FIELD((String)((String)names.get(i)), (DataType)HiveSchemaUtils.toFlinkType((TypeInfo)typeInfos.get(i)));
                }
                return DataTypes.ROW((DataTypes.Field[])fields);
            }
        }
        throw new UnsupportedOperationException(String.format("Flink doesn't support Hive data type %s yet.", hiveType));
    }

    private static DataType toFlinkPrimitiveType(PrimitiveTypeInfo hiveType) {
        Preconditions.checkNotNull((Object)hiveType, (String)"hiveType cannot be null");
        switch (hiveType.getPrimitiveCategory()) {
            case CHAR: {
                return DataTypes.CHAR((int)((CharTypeInfo)hiveType).getLength());
            }
            case VARCHAR: {
                return DataTypes.VARCHAR((int)((VarcharTypeInfo)hiveType).getLength());
            }
            case STRING: {
                return DataTypes.STRING();
            }
            case BOOLEAN: {
                return DataTypes.BOOLEAN();
            }
            case BYTE: {
                return DataTypes.TINYINT();
            }
            case SHORT: {
                return DataTypes.SMALLINT();
            }
            case INT: {
                return DataTypes.INT();
            }
            case LONG: {
                return DataTypes.BIGINT();
            }
            case FLOAT: {
                return DataTypes.FLOAT();
            }
            case DOUBLE: {
                return DataTypes.DOUBLE();
            }
            case DATE: {
                return DataTypes.DATE();
            }
            case TIMESTAMP: {
                return DataTypes.TIMESTAMP((int)6);
            }
            case BINARY: {
                return DataTypes.BYTES();
            }
            case DECIMAL: {
                DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)hiveType;
                return DataTypes.DECIMAL((int)decimalTypeInfo.getPrecision(), (int)decimalTypeInfo.getScale());
            }
        }
        throw new UnsupportedOperationException(String.format("Flink doesn't support Hive primitive type %s yet", hiveType));
    }

    public static List<FieldSchema> toHiveFieldSchema(TableSchema schema, boolean withOperationField) {
        ArrayList<FieldSchema> columns = new ArrayList<FieldSchema>();
        ArrayList<String> metaFields = new ArrayList<String>(HoodieRecord.HOODIE_META_COLUMNS);
        if (withOperationField) {
            metaFields.add(HoodieRecord.OPERATION_METADATA_FIELD);
        }
        for (String metaField : metaFields) {
            columns.add(new FieldSchema(metaField, "string", null));
        }
        columns.addAll(HiveSchemaUtils.createHiveColumns(schema));
        return columns;
    }

    private static List<FieldSchema> createHiveColumns(TableSchema schema) {
        DataType dataType = schema.toPersistedRowDataType();
        RowType rowType = (RowType)dataType.getLogicalType();
        String[] fieldNames = rowType.getFieldNames().toArray(new String[0]);
        DataType[] fieldTypes = dataType.getChildren().toArray(new DataType[0]);
        ArrayList<FieldSchema> columns = new ArrayList<FieldSchema>(fieldNames.length);
        for (int i = 0; i < fieldNames.length; ++i) {
            columns.add(new FieldSchema(fieldNames[i], HiveSchemaUtils.toHiveTypeInfo(fieldTypes[i]).getTypeName(), null));
        }
        return columns;
    }

    public static TypeInfo toHiveTypeInfo(DataType dataType) {
        Preconditions.checkNotNull((Object)dataType, (String)"type cannot be null");
        LogicalType logicalType = dataType.getLogicalType();
        return (TypeInfo)logicalType.accept((LogicalTypeVisitor)new TypeInfoLogicalTypeVisitor(dataType));
    }

    public static Pair<List<FieldSchema>, List<FieldSchema>> splitSchemaByPartitionKeys(List<FieldSchema> fieldSchemas, List<String> partitionKeys) {
        ArrayList<FieldSchema> regularColumns = new ArrayList<FieldSchema>();
        ArrayList<FieldSchema> partitionColumns = new ArrayList<FieldSchema>();
        for (FieldSchema fieldSchema : fieldSchemas) {
            if (partitionKeys.contains(fieldSchema.getName())) {
                partitionColumns.add(fieldSchema);
                continue;
            }
            regularColumns.add(fieldSchema);
        }
        return Pair.of(regularColumns, partitionColumns);
    }
}

