/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.source.stats;

import java.util.stream.Stream;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hudi.avro.model.HoodieMetadataRecord;
import org.apache.hudi.util.AvroSchemaConverter;

public class ColumnStatsSchemas {
    public static final DataType METADATA_DATA_TYPE = ColumnStatsSchemas.getMetadataDataType();
    public static final DataType COL_STATS_DATA_TYPE = ColumnStatsSchemas.getColStatsDataType();
    public static final int[] COL_STATS_TARGET_POS = ColumnStatsSchemas.getColStatsTargetPos();
    public static final int ORD_FILE_NAME = 0;
    public static final int ORD_MIN_VAL = 1;
    public static final int ORD_MAX_VAL = 2;
    public static final int ORD_NULL_CNT = 3;
    public static final int ORD_VAL_CNT = 4;
    public static final int ORD_COL_NAME = 5;

    private static DataType getMetadataDataType() {
        return AvroSchemaConverter.convertToDataType(HoodieMetadataRecord.SCHEMA$);
    }

    private static DataType getColStatsDataType() {
        int pos = HoodieMetadataRecord.SCHEMA$.getField("ColumnStatsMetadata").pos();
        return (DataType)METADATA_DATA_TYPE.getChildren().get(pos);
    }

    private static int[] getColStatsTargetPos() {
        RowType colStatsRowType = (RowType)COL_STATS_DATA_TYPE.getLogicalType();
        return Stream.of("fileName", "minValue", "maxValue", "nullCount", "valueCount", "columnName").mapToInt(arg_0 -> ((RowType)colStatsRowType).getFieldIndex(arg_0)).toArray();
    }
}

