/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.source.prune;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.source.ExpressionEvaluators;
import org.apache.hudi.source.prune.ColumnStatsProbe;
import org.apache.hudi.source.stats.ColumnStats;
import org.apache.hudi.source.stats.PartitionStatsIndex;
import org.apache.hudi.table.format.FilePathUtils;
import org.apache.hudi.util.DataTypeUtils;
import org.apache.hudi.util.StreamerUtil;

public class PartitionPruners {
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private RowType rowType;
        private String basePath;
        private Configuration conf;
        private ColumnStatsProbe probe;
        private List<ExpressionEvaluators.Evaluator> partitionEvaluators;
        private List<String> partitionKeys;
        private List<DataType> partitionTypes;
        private String defaultParName;
        private boolean hivePartition;
        private Collection<String> candidatePartitions;

        private Builder() {
        }

        public Builder rowType(RowType rowType) {
            this.rowType = rowType;
            return this;
        }

        public Builder basePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        public Builder conf(Configuration conf) {
            this.conf = conf;
            return this;
        }

        public Builder columnStatsProbe(ColumnStatsProbe probe) {
            this.probe = probe;
            return this;
        }

        public Builder partitionEvaluators(List<ExpressionEvaluators.Evaluator> partitionEvaluators) {
            this.partitionEvaluators = partitionEvaluators;
            return this;
        }

        public Builder partitionKeys(List<String> partitionKeys) {
            this.partitionKeys = partitionKeys;
            return this;
        }

        public Builder partitionTypes(List<DataType> partitionTypes) {
            this.partitionTypes = partitionTypes;
            return this;
        }

        public Builder defaultParName(String defaultParName) {
            this.defaultParName = defaultParName;
            return this;
        }

        public Builder hivePartition(boolean hivePartition) {
            this.hivePartition = hivePartition;
            return this;
        }

        public Builder candidatePartitions(Collection<String> candidatePartitions) {
            this.candidatePartitions = candidatePartitions;
            return this;
        }

        public PartitionPruner build() {
            List<PartitionPruner> partitionPruners;
            StaticPartitionPruner staticPruner = null;
            if (this.candidatePartitions != null && !this.candidatePartitions.isEmpty()) {
                staticPruner = new StaticPartitionPruner(this.candidatePartitions);
            }
            DynamicPartitionPruner dynamicPruner = null;
            if (this.partitionEvaluators != null && !this.partitionEvaluators.isEmpty()) {
                dynamicPruner = new DynamicPartitionPruner(this.partitionEvaluators, Objects.requireNonNull(this.partitionKeys), Objects.requireNonNull(this.partitionTypes), Objects.requireNonNull(this.defaultParName), this.hivePartition);
            }
            ColumnStatsPartitionPruner columnStatsPruner = null;
            if (this.probe != null && ((Boolean)this.conf.get(FlinkOptions.READ_DATA_SKIPPING_ENABLED)).booleanValue() && ((Boolean)this.conf.get(FlinkOptions.METADATA_ENABLED)).booleanValue()) {
                columnStatsPruner = new ColumnStatsPartitionPruner(Objects.requireNonNull(this.rowType), Objects.requireNonNull(this.basePath), StreamerUtil.metadataConfig(Objects.requireNonNull(this.conf)), this.probe);
            }
            if ((partitionPruners = Stream.of(staticPruner, dynamicPruner, columnStatsPruner).filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) {
                return null;
            }
            if (partitionPruners.size() < 2) {
                return (PartitionPruner)partitionPruners.get(0);
            }
            return new ChainedPartitionPruner(partitionPruners);
        }
    }

    public static class ChainedPartitionPruner
    implements PartitionPruner {
        private static final long serialVersionUID = 1L;
        private final List<PartitionPruner> pruners;

        public ChainedPartitionPruner(List<PartitionPruner> pruners) {
            this.pruners = pruners;
        }

        @Override
        public Set<String> filter(Collection<String> partitions) {
            for (PartitionPruner pruner : this.pruners) {
                partitions = pruner.filter(partitions);
            }
            return new HashSet<String>(partitions);
        }
    }

    public static class ColumnStatsPartitionPruner
    implements PartitionPruner {
        private static final long serialVersionUID = 1L;
        private final ColumnStatsProbe probe;
        private final PartitionStatsIndex partitionStatsIndex;

        public ColumnStatsPartitionPruner(RowType rowType, String basePath, HoodieMetadataConfig metadataConfig, ColumnStatsProbe probe) {
            this.probe = probe;
            this.partitionStatsIndex = new PartitionStatsIndex(basePath, rowType, metadataConfig);
        }

        @Override
        public Set<String> filter(Collection<String> partitions) {
            Set<String> candidatePartitions = this.partitionStatsIndex.computeCandidatePartitions(this.probe, new ArrayList<String>(partitions));
            if (candidatePartitions == null) {
                return new HashSet<String>(partitions);
            }
            return partitions.stream().filter(candidatePartitions::contains).collect(Collectors.toSet());
        }
    }

    public static class StaticPartitionPruner
    implements PartitionPruner {
        private static final long serialVersionUID = 1L;
        private final Set<String> partitions;

        private StaticPartitionPruner(Collection<String> partitions) {
            this.partitions = new HashSet<String>(partitions);
        }

        @Override
        public Set<String> filter(Collection<String> partitions) {
            return partitions.stream().filter(this.partitions::contains).collect(Collectors.toSet());
        }
    }

    public static class DynamicPartitionPruner
    implements PartitionPruner {
        private static final long serialVersionUID = 1L;
        private final List<ExpressionEvaluators.Evaluator> partitionEvaluator;
        private final String[] partitionKeys;
        private final List<DataType> partitionTypes;
        private final String defaultParName;
        private final boolean hivePartition;

        private DynamicPartitionPruner(List<ExpressionEvaluators.Evaluator> partitionEvaluators, List<String> partitionKeys, List<DataType> partitionTypes, String defaultParName, boolean hivePartition) {
            this.partitionEvaluator = partitionEvaluators;
            this.partitionKeys = partitionKeys.toArray(new String[0]);
            this.partitionTypes = partitionTypes;
            this.defaultParName = defaultParName;
            this.hivePartition = hivePartition;
        }

        @Override
        public Set<String> filter(Collection<String> partitions) {
            return partitions.stream().filter(this::evaluate).collect(Collectors.toSet());
        }

        private boolean evaluate(String partition) {
            String[] partStrArray = FilePathUtils.extractPartitionKeyValues(new Path(partition), this.hivePartition, this.partitionKeys).values().toArray(new String[0]);
            LinkedHashMap<String, ColumnStats> partStats = new LinkedHashMap<String, ColumnStats>();
            for (int idx = 0; idx < this.partitionKeys.length; ++idx) {
                String partKey = this.partitionKeys[idx];
                Object partVal = partStrArray[idx].equals(this.defaultParName) ? null : DataTypeUtils.resolvePartition(partStrArray[idx], this.partitionTypes.get(idx));
                ColumnStats columnStats = new ColumnStats(partVal, partVal, partVal == null ? 1L : 0L);
                partStats.put(partKey, columnStats);
            }
            return this.partitionEvaluator.stream().allMatch(evaluator -> evaluator.eval(partStats));
        }
    }

    public static interface PartitionPruner
    extends Serializable {
        public Set<String> filter(Collection<String> var1);
    }
}

