/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.source;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hudi.client.common.HoodieFlinkEngineContext;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.configuration.HadoopConfigurations;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.index.bucket.BucketIdentifier;
import org.apache.hudi.source.prune.ColumnStatsProbe;
import org.apache.hudi.source.prune.PartitionPruners;
import org.apache.hudi.source.stats.FileStatsIndex;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.apache.hudi.storage.hadoop.HoodieHadoopStorage;
import org.apache.hudi.util.StreamerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileIndex
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(FileIndex.class);
    private final StoragePath path;
    private final boolean tableExists;
    private final HoodieMetadataConfig metadataConfig;
    private final org.apache.hadoop.conf.Configuration hadoopConf;
    private final PartitionPruners.PartitionPruner partitionPruner;
    private final ColumnStatsProbe colStatsProbe;
    private final int dataBucket;
    private List<String> partitionPaths;
    private final FileStatsIndex fileStatsIndex;

    private FileIndex(StoragePath path, Configuration conf, RowType rowType, ColumnStatsProbe colStatsProbe, PartitionPruners.PartitionPruner partitionPruner, int dataBucket) {
        this.path = path;
        this.hadoopConf = HadoopConfigurations.getHadoopConf(conf);
        this.tableExists = StreamerUtil.tableExists(path.toString(), this.hadoopConf);
        this.metadataConfig = StreamerUtil.metadataConfig(conf);
        this.colStatsProbe = this.isDataSkippingFeasible((Boolean)conf.get(FlinkOptions.READ_DATA_SKIPPING_ENABLED)) ? colStatsProbe : null;
        this.partitionPruner = partitionPruner;
        this.dataBucket = dataBucket;
        this.fileStatsIndex = new FileStatsIndex(path.toString(), rowType, this.metadataConfig);
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<Map<String, String>> getPartitions(List<String> partitionKeys, String defaultParName, boolean hivePartition) {
        if (partitionKeys.isEmpty()) {
            return Collections.emptyList();
        }
        List<String> partitionPaths = this.getOrBuildPartitionPaths();
        if (partitionPaths.size() == 1 && partitionPaths.get(0).isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, String>> partitions = new ArrayList<Map<String, String>>();
        for (String partitionPath : partitionPaths) {
            String[] paths = partitionPath.split("/");
            LinkedHashMap<String, String> partitionMapping = new LinkedHashMap<String, String>();
            if (hivePartition) {
                Arrays.stream(paths).forEach(p -> {
                    String[] kv = p.split("=");
                    if (kv.length == 2) {
                        partitionMapping.put(kv[0], defaultParName.equals(kv[1]) ? null : kv[1]);
                    }
                });
            } else {
                for (int i = 0; i < partitionKeys.size(); ++i) {
                    partitionMapping.put(partitionKeys.get(i), defaultParName.equals(paths[i]) ? null : paths[i]);
                }
            }
            partitions.add(partitionMapping);
        }
        return partitions;
    }

    public List<StoragePathInfo> getFilesInPartitions() {
        Set<String> candidateFiles;
        if (!this.tableExists) {
            return Collections.emptyList();
        }
        String[] partitions = (String[])this.getOrBuildPartitionPaths().stream().map(p -> FileIndex.fullPartitionPath(this.path, p)).toArray(String[]::new);
        if (partitions.length < 1) {
            return Collections.emptyList();
        }
        List<Object> allFiles = FSUtils.getFilesInPartitions((HoodieEngineContext)new HoodieFlinkEngineContext(this.hadoopConf), (HoodieStorage)new HoodieHadoopStorage(this.path, HadoopFSUtils.getStorageConf((org.apache.hadoop.conf.Configuration)this.hadoopConf)), (HoodieMetadataConfig)this.metadataConfig, (String)this.path.toString(), (String[])partitions).values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        if (allFiles.isEmpty()) {
            return allFiles;
        }
        if (this.dataBucket >= 0) {
            String bucketIdStr = BucketIdentifier.bucketIdStr((int)this.dataBucket);
            List filesAfterBucketPruning = allFiles.stream().filter(fileInfo -> fileInfo.getPath().getName().contains(bucketIdStr)).collect(Collectors.toList());
            this.logPruningMsg(allFiles.size(), filesAfterBucketPruning.size(), "bucket pruning");
            allFiles = filesAfterBucketPruning;
        }
        if ((candidateFiles = this.fileStatsIndex.computeCandidateFiles(this.colStatsProbe, allFiles.stream().map(f -> f.getPath().getName()).collect(Collectors.toList()))) == null) {
            return allFiles;
        }
        List<StoragePathInfo> results = ((Stream)allFiles.stream().parallel()).filter(fileStatus -> candidateFiles.contains(fileStatus.getPath().getName())).collect(Collectors.toList());
        this.logPruningMsg(allFiles.size(), results.size(), "data skipping");
        return results;
    }

    private static String fullPartitionPath(StoragePath basePath, String partitionPath) {
        if (partitionPath.isEmpty()) {
            return basePath.toString();
        }
        return new StoragePath(basePath, partitionPath).toString();
    }

    @VisibleForTesting
    public void reset() {
        this.partitionPaths = null;
    }

    public List<String> getOrBuildPartitionPaths() {
        List allPartitionPaths;
        if (this.partitionPaths != null) {
            return this.partitionPaths;
        }
        List list = allPartitionPaths = this.tableExists ? FSUtils.getAllPartitionPaths((HoodieEngineContext)new HoodieFlinkEngineContext(this.hadoopConf), (HoodieStorage)new HoodieHadoopStorage(this.path, HadoopFSUtils.getStorageConf((org.apache.hadoop.conf.Configuration)this.hadoopConf)), (HoodieMetadataConfig)this.metadataConfig, (String)this.path.toString()) : Collections.emptyList();
        if (this.partitionPruner == null) {
            this.partitionPaths = allPartitionPaths;
        } else {
            Set<String> prunedPartitionPaths = this.partitionPruner.filter(allPartitionPaths);
            this.partitionPaths = new ArrayList<String>(prunedPartitionPaths);
        }
        return this.partitionPaths;
    }

    private boolean isDataSkippingFeasible(boolean dataSkippingEnabled) {
        if (dataSkippingEnabled) {
            if (this.metadataConfig.isEnabled()) {
                return true;
            }
            LOG.warn("Data skipping requires Metadata Table to be enabled! Disable the data skipping");
        }
        return false;
    }

    private void logPruningMsg(int numTotalFiles, int numLeftFiles, String action) {
        LOG.info("\n------------------------------------------------------------\n---------- action:        {}\n---------- total files:   {}\n---------- left files:    {}\n---------- skipping rate: {}\n------------------------------------------------------------", new Object[]{action, numTotalFiles, numLeftFiles, FileIndex.percentage(numTotalFiles, numLeftFiles)});
    }

    private static double percentage(double total, double left) {
        return (total - left) / total;
    }

    public static class Builder {
        private StoragePath path;
        private Configuration conf;
        private RowType rowType;
        private ColumnStatsProbe columnStatsProbe;
        private PartitionPruners.PartitionPruner partitionPruner;
        private int dataBucket = -1;

        private Builder() {
        }

        public Builder path(StoragePath path) {
            this.path = path;
            return this;
        }

        public Builder conf(Configuration conf) {
            this.conf = conf;
            return this;
        }

        public Builder rowType(RowType rowType) {
            this.rowType = rowType;
            return this;
        }

        public Builder columnStatsProbe(ColumnStatsProbe columnStatsProbe) {
            this.columnStatsProbe = columnStatsProbe;
            return this;
        }

        public Builder partitionPruner(PartitionPruners.PartitionPruner partitionPruner) {
            this.partitionPruner = partitionPruner;
            return this;
        }

        public Builder dataBucket(int dataBucket) {
            this.dataBucket = dataBucket;
            return this;
        }

        public FileIndex build() {
            return new FileIndex(Objects.requireNonNull(this.path), Objects.requireNonNull(this.conf), Objects.requireNonNull(this.rowType), this.columnStatsProbe, this.partitionPruner, this.dataBucket);
        }
    }
}

