/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.transform;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.data.RowData;
import org.apache.hudi.sink.transform.Transformer;

public class ChainedTransformer
implements Transformer {
    private final List<Transformer> transformers;

    public ChainedTransformer(List<Transformer> transformers) {
        this.transformers = transformers;
    }

    public List<String> getTransformersNames() {
        return this.transformers.stream().map(t -> t.getClass().getName()).collect(Collectors.toList());
    }

    @Override
    public DataStream<RowData> apply(DataStream<RowData> source) {
        DataStream<RowData> dataStream = source;
        for (Transformer t : this.transformers) {
            dataStream = t.apply(dataStream);
        }
        return dataStream;
    }
}

