/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.bucket;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.state.FunctionInitializationContext;
import org.apache.flink.runtime.state.FunctionSnapshotContext;
import org.apache.flink.streaming.api.checkpoint.CheckpointedFunction;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.apache.hudi.client.HoodieFlinkWriteClient;
import org.apache.hudi.client.model.HoodieFlinkInternalRow;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.ConsistentHashingNode;
import org.apache.hudi.common.model.HoodieConsistentHashingMetadata;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.configuration.OptionsResolver;
import org.apache.hudi.exception.HoodieLockException;
import org.apache.hudi.index.bucket.ConsistentBucketIdentifier;
import org.apache.hudi.index.bucket.ConsistentBucketIndexUtils;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.util.FlinkWriteClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistentBucketAssignFunction
extends ProcessFunction<HoodieFlinkInternalRow, HoodieFlinkInternalRow>
implements CheckpointedFunction {
    private static final Logger LOG = LoggerFactory.getLogger(ConsistentBucketAssignFunction.class);
    private final Configuration config;
    private final List<String> indexKeyFields;
    private final int bucketNum;
    private transient HoodieFlinkWriteClient writeClient;
    private transient Map<String, ConsistentBucketIdentifier> partitionToIdentifier;
    private transient String lastRefreshInstant;
    private final int maxRetries = 10;
    private final long maxWaitTimeInMs = 1000L;

    public ConsistentBucketAssignFunction(Configuration conf) {
        this.config = conf;
        this.indexKeyFields = Arrays.asList(OptionsResolver.getIndexKeyField(conf).split(","));
        this.bucketNum = conf.getInteger(FlinkOptions.BUCKET_INDEX_NUM_BUCKETS);
    }

    public void open(Configuration parameters) throws Exception {
        try {
            this.writeClient = FlinkWriteClients.createWriteClient(this.config, this.getRuntimeContext());
            this.partitionToIdentifier = new HashMap<String, ConsistentBucketIdentifier>();
            this.lastRefreshInstant = "00000000000000";
        }
        catch (Throwable e) {
            LOG.error("Fail to initialize consistent bucket assigner", e);
            throw new RuntimeException(e);
        }
    }

    public void processElement(HoodieFlinkInternalRow income, ProcessFunction.Context context, Collector<HoodieFlinkInternalRow> collector) throws Exception {
        String recordKey = income.getRecordKey();
        String partition = income.getPartitionPath();
        ConsistentHashingNode node = this.getBucketIdentifier(partition).getBucket(recordKey, this.indexKeyFields);
        Preconditions.checkArgument((boolean)StringUtils.nonEmpty((String)node.getFileIdPrefix()), (Object)("Consistent hashing node has no file group, partition: " + partition + ", meta: " + this.partitionToIdentifier.get(partition).getMetadata().getFilename() + ", record_key: " + recordKey));
        income.setInstantTime("U");
        income.setFileId(FSUtils.createNewFileId((String)node.getFileIdPrefix(), (int)0));
        collector.collect((Object)income);
    }

    private ConsistentBucketIdentifier getBucketIdentifier(String partition) {
        return this.partitionToIdentifier.computeIfAbsent(partition, p -> {
            int retryCount = 0;
            HoodieConsistentHashingMetadata metadata = null;
            while (retryCount <= 10) {
                try {
                    metadata = ConsistentBucketIndexUtils.loadOrCreateMetadata((HoodieTable)this.writeClient.getHoodieTable(), (String)p, (int)this.bucketNum);
                    break;
                }
                catch (Exception e) {
                    if (retryCount >= 10) {
                        throw new HoodieLockException("Fail to load or create metadata for partition " + partition, (Throwable)e);
                    }
                    try {
                        TimeUnit.MILLISECONDS.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    LOG.info("Retrying to load or create metadata for partition {} for {} times", (Object)partition, (Object)(retryCount + 1));
                }
                finally {
                    ++retryCount;
                }
            }
            ValidationUtils.checkState((metadata != null ? 1 : 0) != 0);
            return new ConsistentBucketIdentifier(metadata);
        });
    }

    public void snapshotState(FunctionSnapshotContext functionSnapshotContext) throws Exception {
        HoodieTimeline timeline = this.writeClient.getHoodieTable().getActiveTimeline().getCompletedReplaceTimeline().findInstantsAfter(this.lastRefreshInstant);
        if (!timeline.empty()) {
            for (HoodieInstant instant : timeline.getInstants()) {
                HoodieReplaceCommitMetadata commitMetadata = timeline.readReplaceCommitMetadata(instant);
                Set affectedPartitions = commitMetadata.getPartitionToReplaceFileIds().keySet();
                LOG.info("Clear up cached hashing metadata because find a new replace commit.\n Instant: {}.\n Effected Partitions: {}.", (Object)this.lastRefreshInstant, affectedPartitions);
                affectedPartitions.forEach(this.partitionToIdentifier::remove);
            }
            this.lastRefreshInstant = ((HoodieInstant)timeline.lastInstant().get()).requestedTime();
        }
    }

    public void initializeState(FunctionInitializationContext functionInitializationContext) throws Exception {
    }
}

