/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.append;

import java.util.concurrent.TimeUnit;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Collector;
import org.apache.hudi.common.util.RateLimiter;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.sink.append.AppendWriteFunction;

public class AppendWriteFunctionWithRateLimit<I>
extends AppendWriteFunction<I> {
    private final double totalLimit;
    private transient RateLimiter rateLimiter;

    public AppendWriteFunctionWithRateLimit(RowType rowType, Configuration config) {
        super(config, rowType);
        this.totalLimit = config.getLong(FlinkOptions.WRITE_RATE_LIMIT);
    }

    @Override
    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        this.rateLimiter = RateLimiter.create((int)((int)this.totalLimit / this.getRuntimeContext().getNumberOfParallelSubtasks()), (TimeUnit)TimeUnit.SECONDS);
    }

    @Override
    public void processElement(I value, ProcessFunction.Context ctx, Collector<Object> out) throws Exception {
        this.rateLimiter.acquire(1);
        super.processElement(value, ctx, out);
    }
}

