/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utils;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.timeline.CommitMetadataSerDe;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantFileNameGenerator;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.configuration.HadoopConfigurations;
import org.apache.hudi.sink.utils.MockStreamingRuntimeContext;
import org.apache.hudi.source.StreamReadMonitoringFunction;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.hadoop.HadoopStorageConfiguration;
import org.apache.hudi.table.format.mor.MergeOnReadInputSplit;
import org.apache.hudi.util.StreamerUtil;
import org.apache.hudi.utils.TestConfigurations;
import org.junit.jupiter.api.Assertions;

public class TestUtils {
    public static String getLastPendingInstant(String basePath) {
        HoodieTableMetaClient metaClient = HoodieTestUtils.createMetaClient((StorageConfiguration)new HadoopStorageConfiguration(HadoopConfigurations.getHadoopConf((Configuration)new Configuration())), (String)basePath);
        return StreamerUtil.getLastPendingInstant((HoodieTableMetaClient)metaClient);
    }

    public static String getLastCompleteInstant(String basePath) {
        HoodieTableMetaClient metaClient = HoodieTestUtils.createMetaClient((StorageConfiguration)new HadoopStorageConfiguration(HadoopConfigurations.getHadoopConf((Configuration)new Configuration())), (String)basePath);
        return StreamerUtil.getLastCompletedInstant((HoodieTableMetaClient)metaClient);
    }

    public static String getLastCompleteInstant(String basePath, String commitAction) {
        HoodieTableMetaClient metaClient = HoodieTestUtils.createMetaClient((StorageConfiguration)new HadoopStorageConfiguration(HadoopConfigurations.getHadoopConf((Configuration)new Configuration())), (String)basePath);
        return (String)metaClient.getCommitsTimeline().filterCompletedInstants().filter(instant -> commitAction.equals(instant.getAction())).lastInstant().map(HoodieInstant::requestedTime).orElse(null);
    }

    public static String getLastDeltaCompleteInstant(String basePath) {
        HoodieTableMetaClient metaClient = HoodieTestUtils.createMetaClient((StorageConfiguration)new HadoopStorageConfiguration(HadoopConfigurations.getHadoopConf((Configuration)new Configuration())), (String)basePath);
        return (String)metaClient.getCommitsTimeline().filterCompletedInstants().filter(hoodieInstant -> hoodieInstant.getAction().equals("deltacommit")).lastInstant().map(HoodieInstant::requestedTime).orElse(null);
    }

    public static String getFirstCompleteInstant(String basePath) {
        HoodieTableMetaClient metaClient = HoodieTestUtils.createMetaClient((StorageConfiguration)new HadoopStorageConfiguration(HadoopConfigurations.getHadoopConf((Configuration)new Configuration())), (String)basePath);
        return (String)metaClient.getCommitsAndCompactionTimeline().filterCompletedInstants().firstInstant().map(HoodieInstant::requestedTime).orElse(null);
    }

    @Nullable
    public static String getNthCompleteInstant(StoragePath basePath, int n, String action) {
        HoodieTableMetaClient metaClient = HoodieTestUtils.createMetaClient((StorageConfiguration)new HadoopStorageConfiguration(HadoopConfigurations.getHadoopConf((Configuration)new Configuration())), (StoragePath)basePath, (HoodieTableVersion)HoodieTableVersion.EIGHT);
        return (String)metaClient.getActiveTimeline().filterCompletedInstants().filter(instant -> action.equals(instant.getAction())).nthInstant(n).map(HoodieInstant::requestedTime).orElse(null);
    }

    @Nullable
    public static String getNthArchivedInstant(String basePath, int n) {
        HoodieTableMetaClient metaClient = HoodieTestUtils.createMetaClient((StorageConfiguration)new HadoopStorageConfiguration(HadoopConfigurations.getHadoopConf((Configuration)new Configuration())), (String)basePath);
        return (String)metaClient.getArchivedTimeline().getCommitsTimeline().filterCompletedInstants().nthInstant(n).map(HoodieInstant::requestedTime).orElse(null);
    }

    public static String getSplitPartitionPath(MergeOnReadInputSplit split) {
        Assertions.assertTrue((boolean)split.getLogPaths().isPresent());
        String logPath = (String)((List)split.getLogPaths().get()).get(0);
        String[] paths = logPath.split("/");
        return paths[paths.length - 2];
    }

    public static StreamReadMonitoringFunction getMonitorFunc(Configuration conf) {
        String basePath = conf.getString(FlinkOptions.PATH);
        return new StreamReadMonitoringFunction(conf, new Path(basePath), TestConfigurations.ROW_TYPE, 0x100000L, null);
    }

    public static MockStreamingRuntimeContext getMockRuntimeContext() {
        return new MockStreamingRuntimeContext(false, 4, 0);
    }

    public static int getCompletedInstantCount(String basePath, String action) {
        HoodieTableMetaClient metaClient = HoodieTestUtils.createMetaClient((StorageConfiguration)new HadoopStorageConfiguration(HadoopConfigurations.getHadoopConf((Configuration)new Configuration())), (String)basePath);
        return metaClient.getActiveTimeline().filterCompletedInstants().filter(instant -> action.equals(instant.getAction())).countInstants();
    }

    public static HoodieCommitMetadata deleteInstantFile(HoodieTableMetaClient metaClient, HoodieInstant instant) throws Exception {
        ValidationUtils.checkArgument((boolean)instant.isCompleted());
        HoodieCommitMetadata metadata = TimelineUtils.getCommitMetadata((HoodieInstant)instant, (HoodieTimeline)metaClient.getActiveTimeline());
        TimelineUtils.deleteInstantFile((HoodieStorage)metaClient.getStorage(), (StoragePath)metaClient.getTimelinePath(), (HoodieInstant)instant, (InstantFileNameGenerator)metaClient.getInstantFileNameGenerator());
        return metadata;
    }

    public static void saveInstantAsComplete(HoodieTableMetaClient metaClient, HoodieInstant instant, HoodieCommitMetadata metadata) throws Exception {
        metaClient.getActiveTimeline().saveAsComplete(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, instant.getAction(), instant.requestedTime()), TimelineMetadataUtils.serializeCommitMetadata((CommitMetadataSerDe)metaClient.getCommitMetadataSerDe(), (HoodieCommitMetadata)metadata));
    }

    public static String amendCompletionTimeToLatest(HoodieTableMetaClient metaClient, java.nio.file.Path sourcePath, String instantTime) throws IOException {
        String fileExt = sourcePath.getFileName().toString().split("\\.")[1];
        String newCompletionTime = metaClient.createNewInstantTime();
        String newFileName = instantTime + "_" + newCompletionTime + "." + fileExt;
        java.nio.file.Path newFilePath = sourcePath.getParent().resolve(newFileName);
        Files.move(sourcePath, newFilePath, new CopyOption[0]);
        return newCompletionTime;
    }
}

