/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utils;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.apache.avro.generic.GenericRecord;
import org.apache.flink.formats.common.TimestampFormat;
import org.apache.flink.formats.json.JsonToRowDataConverters;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hudi.util.AvroSchemaConverter;
import org.apache.hudi.util.RowDataToAvroConverters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestRowDataToAvroConverters {
    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    TestRowDataToAvroConverters() {
    }

    @Test
    void testRowDataToAvroStringToRowDataWithLocalTimezone() throws JsonProcessingException {
        String timestampFromLocal = "2021-03-30 07:44:29";
        DataType rowDataType = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"timestamp_from_local", (DataType)DataTypes.TIMESTAMP())});
        JsonToRowDataConverters.JsonToRowDataConverter jsonToRowDataConverter = new JsonToRowDataConverters(true, true, TimestampFormat.SQL).createConverter(rowDataType.getLogicalType());
        Object rowData = jsonToRowDataConverter.convert(new ObjectMapper().readTree("{\"timestamp_from_local\":\"" + timestampFromLocal + "\"}"));
        RowType rowType = (RowType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f_timestamp", (DataType)DataTypes.TIMESTAMP((int)3))}).getLogicalType();
        RowDataToAvroConverters.RowDataToAvroConverter converter = RowDataToAvroConverters.createConverter((LogicalType)rowType, (boolean)false);
        GenericRecord avroRecord = (GenericRecord)converter.convert(AvroSchemaConverter.convertToSchema((LogicalType)rowType), rowData);
        Assertions.assertEquals((Object)timestampFromLocal, (Object)this.formatter.format(LocalDateTime.ofInstant(Instant.ofEpochMilli((Long)avroRecord.get(0)), ZoneId.systemDefault())));
    }

    @Test
    void testRowDataToAvroStringToRowDataWithUtcTimezone() throws JsonProcessingException {
        String timestampFromUtc0 = "2021-03-30 07:44:29";
        DataType rowDataType = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"timestamp_from_utc_0", (DataType)DataTypes.TIMESTAMP())});
        JsonToRowDataConverters.JsonToRowDataConverter jsonToRowDataConverter = new JsonToRowDataConverters(true, true, TimestampFormat.SQL).createConverter(rowDataType.getLogicalType());
        Object rowData = jsonToRowDataConverter.convert(new ObjectMapper().readTree("{\"timestamp_from_utc_0\":\"" + timestampFromUtc0 + "\"}"));
        RowType rowType = (RowType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f_timestamp", (DataType)DataTypes.TIMESTAMP((int)3))}).getLogicalType();
        RowDataToAvroConverters.RowDataToAvroConverter converter = RowDataToAvroConverters.createConverter((LogicalType)rowType);
        GenericRecord avroRecord = (GenericRecord)converter.convert(AvroSchemaConverter.convertToSchema((LogicalType)rowType), rowData);
        Assertions.assertEquals((Object)timestampFromUtc0, (Object)this.formatter.format(LocalDateTime.ofInstant(Instant.ofEpochMilli((Long)avroRecord.get(0)), ZoneId.of("UTC"))));
        Assertions.assertEquals((Object)"2021-03-30 08:44:29", (Object)this.formatter.format(LocalDateTime.ofInstant(Instant.ofEpochMilli((Long)avroRecord.get(0)), ZoneId.of("UTC+1"))));
        Assertions.assertEquals((Object)"2021-03-30 15:44:29", (Object)this.formatter.format(LocalDateTime.ofInstant(Instant.ofEpochMilli((Long)avroRecord.get(0)), ZoneId.of("Asia/Shanghai"))));
    }
}

