/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utils;

import java.io.File;
import org.apache.flink.configuration.Configuration;
import org.apache.hudi.client.transaction.lock.FileSystemBasedLockProvider;
import org.apache.hudi.common.model.WriteConcurrencyMode;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.util.FlinkWriteClients;
import org.apache.hudi.util.StreamerUtil;
import org.apache.hudi.utils.TestConfigurations;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestFlinkWriteClients {
    @TempDir
    File tempFile;
    private Configuration conf;

    @BeforeEach
    public void before() throws Exception {
        this.conf = TestConfigurations.getDefaultConf(this.tempFile.getAbsolutePath());
    }

    @Test
    void testAutoSetupLockProvider() throws Exception {
        this.conf.setBoolean(FlinkOptions.METADATA_ENABLED, true);
        StreamerUtil.initTableIfNotExists((Configuration)this.conf);
        HoodieWriteConfig writeConfig = FlinkWriteClients.getHoodieClientConfig((Configuration)this.conf, (boolean)false, (boolean)false);
        MatcherAssert.assertThat((Object)writeConfig.getLockProviderClass(), (Matcher)CoreMatchers.is((Object)FileSystemBasedLockProvider.class.getName()));
        MatcherAssert.assertThat((Object)writeConfig.getWriteConcurrencyMode(), (Matcher)CoreMatchers.is((Object)WriteConcurrencyMode.SINGLE_WRITER));
    }
}

