/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utils;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.configuration.Configuration;
import org.apache.hudi.avro.model.HoodieClusteringGroup;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.avro.model.HoodieClusteringStrategy;
import org.apache.hudi.avro.model.HoodieRequestedReplaceMetadata;
import org.apache.hudi.client.HoodieFlinkWriteClient;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.table.HoodieFlinkTable;
import org.apache.hudi.util.ClusteringUtil;
import org.apache.hudi.util.FlinkTables;
import org.apache.hudi.util.FlinkWriteClients;
import org.apache.hudi.util.StreamerUtil;
import org.apache.hudi.utils.TestConfigurations;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestClusteringUtil {
    private HoodieFlinkTable<?> table;
    private HoodieTableMetaClient metaClient;
    private HoodieFlinkWriteClient<?> writeClient;
    private Configuration conf;
    @TempDir
    File tempFile;

    void beforeEach() throws IOException {
        this.beforeEach(Collections.emptyMap());
    }

    @AfterEach
    void afterEach() {
        if (this.writeClient != null) {
            this.writeClient.close();
        }
    }

    void beforeEach(Map<String, String> options) throws IOException {
        this.conf = TestConfigurations.getDefaultConf(this.tempFile.getAbsolutePath());
        this.conf.setString(FlinkOptions.OPERATION, WriteOperationType.INSERT.value());
        options.forEach((k, v) -> this.conf.setString(k, v));
        StreamerUtil.initTableIfNotExists((Configuration)this.conf);
        this.table = FlinkTables.createTable((Configuration)this.conf);
        this.metaClient = this.table.getMetaClient();
        this.writeClient = FlinkWriteClients.createWriteClient((Configuration)this.conf);
        if (this.writeClient.getConfig().isMetadataTableEnabled()) {
            this.writeClient.initMetadataTable();
        }
    }

    @Test
    void rollbackClustering() throws Exception {
        this.beforeEach();
        List oriInstants = IntStream.range(0, 3).mapToObj(i -> this.generateClusteringPlan()).collect(Collectors.toList());
        List instants = ClusteringUtils.getPendingClusteringInstantTimes((HoodieTableMetaClient)this.table.getMetaClient()).stream().filter(instant -> instant.getState() == HoodieInstant.State.INFLIGHT).collect(Collectors.toList());
        MatcherAssert.assertThat((String)"all the instants should be in pending state", (Object)instants.size(), (Matcher)CoreMatchers.is((Object)3));
        ClusteringUtil.rollbackClustering(this.table, this.writeClient);
        boolean allRolledBack = ClusteringUtils.getPendingClusteringInstantTimes((HoodieTableMetaClient)this.table.getMetaClient()).stream().allMatch(instant -> instant.getState() == HoodieInstant.State.REQUESTED);
        Assertions.assertTrue((boolean)allRolledBack, (String)"all the instants should be rolled back");
        List actualInstants = ClusteringUtils.getPendingClusteringInstantTimes((HoodieTableMetaClient)this.table.getMetaClient()).stream().map(HoodieInstant::requestedTime).collect(Collectors.toList());
        MatcherAssert.assertThat(actualInstants, (Matcher)CoreMatchers.is(oriInstants));
    }

    @Test
    void validateClusteringScheduling() throws Exception {
        this.beforeEach();
        ClusteringUtil.validateClusteringScheduling((Configuration)this.conf);
        this.conf.setString(FlinkOptions.INDEX_TYPE, HoodieIndex.IndexType.BUCKET.name());
        ClusteringUtil.validateClusteringScheduling((Configuration)this.conf);
    }

    private String generateClusteringPlan() {
        HoodieClusteringGroup group = new HoodieClusteringGroup();
        HoodieClusteringPlan plan = new HoodieClusteringPlan(Collections.singletonList(group), HoodieClusteringStrategy.newBuilder().build(), Collections.emptyMap(), Integer.valueOf(1), Boolean.valueOf(false), null);
        HoodieRequestedReplaceMetadata metadata = new HoodieRequestedReplaceMetadata(WriteOperationType.CLUSTER.name(), plan, Collections.emptyMap(), Integer.valueOf(1));
        String instantTime = this.table.getMetaClient().createNewInstantTime();
        HoodieInstant clusteringInstant = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "clustering", instantTime);
        try {
            this.metaClient.getActiveTimeline().saveToPendingClusterCommit(clusteringInstant, TimelineMetadataUtils.serializeRequestedReplaceMetadata((HoodieRequestedReplaceMetadata)metadata));
            this.table.getActiveTimeline().transitionClusterRequestedToInflight(clusteringInstant, Option.empty());
        }
        catch (IOException ioe) {
            throw new HoodieIOException("Exception scheduling clustering", ioe);
        }
        this.metaClient.reloadActiveTimeline();
        return instantTime;
    }
}

