/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.catalog.WatermarkSpec;
import org.apache.flink.table.types.DataType;

public class SchemaBuilder {
    private List<Column> columns = new ArrayList<Column>();
    private List<WatermarkSpec> watermarkSpecs = new ArrayList<WatermarkSpec>();
    private UniqueConstraint constraint;

    public static SchemaBuilder instance() {
        return new SchemaBuilder();
    }

    private SchemaBuilder() {
    }

    public SchemaBuilder field(String name, DataType type) {
        this.columns.add((Column)Column.physical((String)name, (DataType)type));
        return this;
    }

    public SchemaBuilder fields(List<String> names, List<DataType> types) {
        List columns = IntStream.range(0, names.size()).mapToObj(idx -> Column.physical((String)((String)names.get(idx)), (DataType)((DataType)types.get(idx)))).collect(Collectors.toList());
        this.columns.addAll(columns);
        return this;
    }

    public SchemaBuilder primaryKey(String ... columns) {
        this.constraint = UniqueConstraint.primaryKey((String)"pk", Arrays.asList(columns));
        return this;
    }

    public ResolvedSchema build() {
        return new ResolvedSchema(this.columns, this.watermarkSpecs, this.constraint);
    }
}

