/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.format;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.hudi.table.format.CastMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestCastMap {
    @Test
    public void testCastInt() {
        CastMap castMap = new CastMap();
        castMap.add(0, (LogicalType)new IntType(), (LogicalType)new BigIntType());
        castMap.add(1, (LogicalType)new IntType(), (LogicalType)new FloatType());
        castMap.add(2, (LogicalType)new IntType(), (LogicalType)new DoubleType());
        castMap.add(3, (LogicalType)new IntType(), (LogicalType)new DecimalType());
        castMap.add(4, (LogicalType)new IntType(), (LogicalType)new VarCharType());
        int val = 1;
        Assertions.assertEquals((Object)1L, (Object)castMap.castIfNeeded(0, (Object)val));
        Assertions.assertEquals((Object)Float.valueOf(1.0f), (Object)castMap.castIfNeeded(1, (Object)val));
        Assertions.assertEquals((Object)1.0, (Object)castMap.castIfNeeded(2, (Object)val));
        Assertions.assertEquals((Object)DecimalData.fromBigDecimal((BigDecimal)BigDecimal.ONE, (int)1, (int)0), (Object)castMap.castIfNeeded(3, (Object)val));
        Assertions.assertEquals((Object)BinaryStringData.fromString((String)"1"), (Object)castMap.castIfNeeded(4, (Object)val));
    }

    @Test
    public void testCastLong() {
        CastMap castMap = new CastMap();
        castMap.add(0, (LogicalType)new BigIntType(), (LogicalType)new FloatType());
        castMap.add(1, (LogicalType)new BigIntType(), (LogicalType)new DoubleType());
        castMap.add(2, (LogicalType)new BigIntType(), (LogicalType)new DecimalType());
        castMap.add(3, (LogicalType)new BigIntType(), (LogicalType)new VarCharType());
        long val = 1L;
        Assertions.assertEquals((Object)Float.valueOf(1.0f), (Object)castMap.castIfNeeded(0, (Object)val));
        Assertions.assertEquals((Object)1.0, (Object)castMap.castIfNeeded(1, (Object)val));
        Assertions.assertEquals((Object)DecimalData.fromBigDecimal((BigDecimal)BigDecimal.ONE, (int)1, (int)0), (Object)castMap.castIfNeeded(2, (Object)val));
        Assertions.assertEquals((Object)BinaryStringData.fromString((String)"1"), (Object)castMap.castIfNeeded(3, (Object)val));
    }

    @Test
    public void testCastFloat() {
        CastMap castMap = new CastMap();
        castMap.add(0, (LogicalType)new FloatType(), (LogicalType)new DoubleType());
        castMap.add(1, (LogicalType)new FloatType(), (LogicalType)new DecimalType());
        castMap.add(2, (LogicalType)new FloatType(), (LogicalType)new VarCharType());
        float val = 1.0f;
        Assertions.assertEquals((Object)1.0, (Object)castMap.castIfNeeded(0, (Object)Float.valueOf(val)));
        Assertions.assertEquals((Object)DecimalData.fromBigDecimal((BigDecimal)BigDecimal.ONE, (int)1, (int)0), (Object)castMap.castIfNeeded(1, (Object)Float.valueOf(val)));
        Assertions.assertEquals((Object)BinaryStringData.fromString((String)"1.0"), (Object)castMap.castIfNeeded(2, (Object)Float.valueOf(val)));
    }

    @Test
    public void testCastDouble() {
        CastMap castMap = new CastMap();
        castMap.add(0, (LogicalType)new DoubleType(), (LogicalType)new DecimalType());
        castMap.add(1, (LogicalType)new DoubleType(), (LogicalType)new VarCharType());
        double val = 1.0;
        Assertions.assertEquals((Object)DecimalData.fromBigDecimal((BigDecimal)BigDecimal.ONE, (int)1, (int)0), (Object)castMap.castIfNeeded(0, (Object)val));
        Assertions.assertEquals((Object)BinaryStringData.fromString((String)"1.0"), (Object)castMap.castIfNeeded(1, (Object)val));
    }

    @Test
    public void testCastDecimal() {
        CastMap castMap = new CastMap();
        castMap.add(0, (LogicalType)new DecimalType(2, 1), (LogicalType)new DecimalType(3, 2));
        castMap.add(1, (LogicalType)new DecimalType(), (LogicalType)new VarCharType());
        DecimalData val = DecimalData.fromBigDecimal((BigDecimal)BigDecimal.ONE, (int)2, (int)1);
        Assertions.assertEquals((Object)DecimalData.fromBigDecimal((BigDecimal)BigDecimal.ONE, (int)3, (int)2), (Object)castMap.castIfNeeded(0, (Object)val));
        Assertions.assertEquals((Object)BinaryStringData.fromString((String)"1.0"), (Object)castMap.castIfNeeded(1, (Object)val));
    }

    @Test
    public void testCastString() {
        CastMap castMap = new CastMap();
        castMap.add(0, (LogicalType)new VarCharType(), (LogicalType)new DecimalType());
        castMap.add(1, (LogicalType)new VarCharType(), (LogicalType)new DateType());
        Assertions.assertEquals((Object)DecimalData.fromBigDecimal((BigDecimal)BigDecimal.ONE, (int)1, (int)0), (Object)castMap.castIfNeeded(0, (Object)BinaryStringData.fromString((String)"1.0")));
        Assertions.assertEquals((Object)((int)LocalDate.parse("2022-05-12").toEpochDay()), (Object)castMap.castIfNeeded(1, (Object)BinaryStringData.fromString((String)"2022-05-12")));
    }

    @Test
    public void testCastDate() {
        CastMap castMap = new CastMap();
        castMap.add(0, (LogicalType)new DateType(), (LogicalType)new VarCharType());
        Assertions.assertEquals((Object)BinaryStringData.fromString((String)"2022-05-12"), (Object)castMap.castIfNeeded(0, (Object)((int)LocalDate.parse("2022-05-12").toEpochDay())));
    }

    @Test
    public void testCastArrayType() {
        ArrayType fromArrayType = new ArrayType(true, (LogicalType)new IntType());
        ArrayType toArrayType = new ArrayType(true, (LogicalType)new DoubleType());
        CastMap castMap = new CastMap();
        castMap.add(0, (LogicalType)fromArrayType, (LogicalType)toArrayType);
        GenericArrayData inputArrayData = new GenericArrayData((Object[])new Integer[]{1, null, 3});
        GenericArrayData expectedArrayData = new GenericArrayData((Object[])new Double[]{1.0, null, 3.0});
        Assertions.assertEquals((Object)expectedArrayData, (Object)castMap.castIfNeeded(0, (Object)inputArrayData));
    }

    @Test
    public void testCastMapType() {
        MapType fromMapType = new MapType(true, (LogicalType)new VarCharType(), (LogicalType)new IntType());
        MapType toMapType = new MapType(true, (LogicalType)new VarCharType(), (LogicalType)new DoubleType());
        CastMap castMap = new CastMap();
        castMap.add(0, (LogicalType)fromMapType, (LogicalType)toMapType);
        HashMap<BinaryStringData, Integer> inputMap = new HashMap<BinaryStringData, Integer>();
        inputMap.put(BinaryStringData.fromString((String)"alex"), 11);
        inputMap.put(BinaryStringData.fromString((String)"ben"), null);
        inputMap.put(BinaryStringData.fromString((String)"jack"), 12);
        HashMap<BinaryStringData, Double> expectedMap = new HashMap<BinaryStringData, Double>();
        expectedMap.put(BinaryStringData.fromString((String)"alex"), 11.0);
        expectedMap.put(BinaryStringData.fromString((String)"ben"), null);
        expectedMap.put(BinaryStringData.fromString((String)"jack"), 12.0);
        GenericMapData inputMapData = new GenericMapData(inputMap);
        GenericMapData expectedMapData = new GenericMapData(expectedMap);
        Assertions.assertEquals((Object)expectedMapData, (Object)castMap.castIfNeeded(0, (Object)inputMapData));
    }

    @Test
    public void testCastNestedRow() {
        RowType innerRowType = new RowType(true, Arrays.asList(new RowType.RowField("f0_int", (LogicalType)new IntType()), new RowType.RowField("f1_int", (LogicalType)new IntType()), new RowType.RowField("f2_int", (LogicalType)new IntType()), new RowType.RowField("f3_int", (LogicalType)new IntType())));
        RowType innerEvolvedRowType = new RowType(true, Arrays.asList(new RowType.RowField("f0_double", (LogicalType)new DoubleType()), new RowType.RowField("f1_int", (LogicalType)new IntType(false)), new RowType.RowField("f2_double", (LogicalType)new DoubleType()), new RowType.RowField("f3_bigint", (LogicalType)new BigIntType())));
        RowType fromRowType = new RowType(true, Arrays.asList(new RowType.RowField("f0_row", (LogicalType)innerRowType), new RowType.RowField("f1_int", (LogicalType)new IntType())));
        RowType toRowType = new RowType(true, Arrays.asList(new RowType.RowField("f0_row", (LogicalType)innerEvolvedRowType), new RowType.RowField("f1_double", (LogicalType)new DoubleType())));
        CastMap castMap = new CastMap();
        castMap.add(0, (LogicalType)fromRowType, (LogicalType)toRowType);
        GenericRowData innerRowData = new GenericRowData(4);
        innerRowData.setField(0, (Object)333);
        innerRowData.setField(1, (Object)444);
        innerRowData.setField(2, null);
        innerRowData.setField(3, (Object)555);
        GenericRowData inputRowData = new GenericRowData(2);
        inputRowData.setField(0, (Object)innerRowData);
        inputRowData.setField(1, (Object)2);
        GenericRowData evolvedInnerRowData = new GenericRowData(4);
        evolvedInnerRowData.setField(0, (Object)333.0);
        evolvedInnerRowData.setField(1, (Object)444);
        evolvedInnerRowData.setField(2, null);
        evolvedInnerRowData.setField(3, (Object)555L);
        GenericRowData expectedRowData = new GenericRowData(2);
        expectedRowData.setField(0, (Object)evolvedInnerRowData);
        expectedRowData.setField(1, (Object)2.0);
        Assertions.assertEquals((Object)expectedRowData, (Object)castMap.castIfNeeded(0, (Object)inputRowData));
    }
}

