/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.source.stats;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.source.stats.FileStatsIndex;
import org.apache.hudi.source.stats.PartitionStatsIndex;
import org.apache.hudi.utils.TestConfigurations;
import org.apache.hudi.utils.TestData;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestColumnStatsIndex {
    @TempDir
    File tempFile;

    @Test
    void testReadPartitionStatsIndex() throws Exception {
        String path = this.tempFile.getAbsolutePath();
        Configuration conf = TestConfigurations.getDefaultConf(path);
        conf.set(FlinkOptions.METADATA_ENABLED, (Object)true);
        conf.setString("hoodie.metadata.index.partition.stats.enable", "true");
        conf.setString("hoodie.metadata.index.column.stats.enable", "true");
        HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().enable(true).withMetadataIndexColumnStats(true).build();
        TestData.writeData(TestData.DATA_SET_INSERT, conf);
        String[] queryColumns = new String[]{"uuid", "age"};
        PartitionStatsIndex indexSupport = new PartitionStatsIndex(path, TestConfigurations.ROW_TYPE, metadataConfig);
        List indexRows = indexSupport.readColumnStatsIndexByColumns(queryColumns);
        List results = indexRows.stream().map(Object::toString).sorted(String::compareTo).collect(Collectors.toList());
        List<String> expected = Arrays.asList("+I(par1,+I(23),+I(33),0,2,age)", "+I(par1,+I(id1),+I(id2),0,2,uuid)", "+I(par2,+I(31),+I(53),0,2,age)", "+I(par2,+I(id3),+I(id4),0,2,uuid)", "+I(par3,+I(18),+I(20),0,2,age)", "+I(par3,+I(id5),+I(id6),0,2,uuid)", "+I(par4,+I(44),+I(56),0,2,age)", "+I(par4,+I(id7),+I(id8),0,2,uuid)");
        Assertions.assertEquals(expected, results);
        Pair transposedIndexTable = indexSupport.transposeColumnStatsIndex(indexRows, queryColumns);
        List transposed = ((List)transposedIndexTable.getLeft()).stream().map(Object::toString).sorted(String::compareTo).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)transposed.size(), (Matcher)CoreMatchers.is((Object)4));
        Assertions.assertArrayEquals((Object[])new String[]{"age", "uuid"}, (Object[])((Object[])transposedIndexTable.getRight()));
        List<String> expected1 = Arrays.asList("+I(par1,2,23,33,0,id1,id2,0)", "+I(par2,2,31,53,0,id3,id4,0)", "+I(par3,2,18,20,0,id5,id6,0)", "+I(par4,2,44,56,0,id7,id8,0)");
        Assertions.assertEquals(expected1, transposed);
    }

    @Test
    void testTransposeColumnStatsIndex() throws Exception {
        String path = this.tempFile.getAbsolutePath();
        Configuration conf = TestConfigurations.getDefaultConf(path);
        conf.setBoolean(FlinkOptions.METADATA_ENABLED, true);
        conf.setBoolean(FlinkOptions.READ_DATA_SKIPPING_ENABLED, true);
        conf.setString("hoodie.metadata.index.column.stats.enable", "true");
        HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().enable(true).withMetadataIndexColumnStats(true).build();
        TestData.writeData(TestData.DATA_SET_INSERT, conf);
        String[] queryColumns1 = new String[]{"uuid", "age"};
        FileStatsIndex indexSupport = new FileStatsIndex(path, TestConfigurations.ROW_TYPE, metadataConfig);
        List indexRows1 = indexSupport.readColumnStatsIndexByColumns(queryColumns1);
        Pair transposedIndexTable1 = indexSupport.transposeColumnStatsIndex(indexRows1, queryColumns1);
        MatcherAssert.assertThat((String)"The schema columns should sort by natural order", (Object)Arrays.toString((Object[])transposedIndexTable1.getRight()), (Matcher)CoreMatchers.is((Object)"[age, uuid]"));
        List<RowData> transposed1 = TestColumnStatsIndex.filterOutFileNames((List)transposedIndexTable1.getLeft());
        MatcherAssert.assertThat((Object)transposed1.size(), (Matcher)CoreMatchers.is((Object)4));
        String expected = "[+I(2,18,20,0,id5,id6,0), +I(2,23,33,0,id1,id2,0), +I(2,31,53,0,id3,id4,0), +I(2,44,56,0,id7,id8,0)]";
        MatcherAssert.assertThat((Object)transposed1.toString(), (Matcher)CoreMatchers.is((Object)"[+I(2,18,20,0,id5,id6,0), +I(2,23,33,0,id1,id2,0), +I(2,31,53,0,id3,id4,0), +I(2,44,56,0,id7,id8,0)]"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> indexSupport.readColumnStatsIndexByColumns(new String[0]));
    }

    private static List<RowData> filterOutFileNames(List<RowData> indexRows) {
        return indexRows.stream().map(row -> {
            GenericRowData gr = (GenericRowData)row;
            GenericRowData converted = new GenericRowData(gr.getArity() - 1);
            for (int i = 1; i < gr.getArity(); ++i) {
                converted.setField(i - 1, gr.getField(i));
            }
            return converted;
        }).sorted(Comparator.comparingInt(r -> r.getInt(1))).collect(Collectors.toList());
    }
}

