/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.source;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.types.DataType;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.keygen.NonpartitionedAvroKeyGenerator;
import org.apache.hudi.source.FileIndex;
import org.apache.hudi.source.prune.ColumnStatsProbe;
import org.apache.hudi.source.prune.PartitionPruners;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.apache.hudi.utils.TestConfigurations;
import org.apache.hudi.utils.TestData;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.ValueSource;

public class TestFileIndex {
    @TempDir
    File tempFile;

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testFileListingUsingMetadata(boolean hiveStylePartitioning) throws Exception {
        Configuration conf = TestConfigurations.getDefaultConf(this.tempFile.getAbsolutePath());
        conf.setBoolean(FlinkOptions.METADATA_ENABLED, true);
        conf.setBoolean(FlinkOptions.HIVE_STYLE_PARTITIONING, hiveStylePartitioning);
        TestData.writeData(TestData.DATA_SET_INSERT, conf);
        FileIndex fileIndex = FileIndex.builder().path(new StoragePath(this.tempFile.getAbsolutePath())).conf(conf).rowType(TestConfigurations.ROW_TYPE).build();
        List<String> partitionKeys = Collections.singletonList("partition");
        List partitions = fileIndex.getPartitions(partitionKeys, (String)FlinkOptions.PARTITION_DEFAULT_NAME.defaultValue(), hiveStylePartitioning);
        Assertions.assertTrue((boolean)partitions.stream().allMatch(m -> m.size() == 1));
        String partitionPaths = partitions.stream().map(Map::values).flatMap(Collection::stream).sorted().collect(Collectors.joining(","));
        MatcherAssert.assertThat((String)"should have 4 partitions", (Object)partitionPaths, (Matcher)CoreMatchers.is((Object)"par1,par2,par3,par4"));
        List pathInfoList = fileIndex.getFilesInPartitions();
        MatcherAssert.assertThat((Object)pathInfoList.size(), (Matcher)CoreMatchers.is((Object)4));
        Assertions.assertTrue((boolean)pathInfoList.stream().allMatch(fileInfo -> fileInfo.getPath().toString().endsWith(HoodieFileFormat.PARQUET.getFileExtension())));
    }

    @Test
    void testFileListingUsingMetadataNonPartitionedTable() throws Exception {
        Configuration conf = TestConfigurations.getDefaultConf(this.tempFile.getAbsolutePath());
        conf.setString(FlinkOptions.PARTITION_PATH_FIELD, "");
        conf.setString(FlinkOptions.KEYGEN_CLASS_NAME, NonpartitionedAvroKeyGenerator.class.getName());
        conf.setBoolean(FlinkOptions.METADATA_ENABLED, true);
        TestData.writeData(TestData.DATA_SET_INSERT, conf);
        FileIndex fileIndex = FileIndex.builder().path(new StoragePath(this.tempFile.getAbsolutePath())).conf(conf).rowType(TestConfigurations.ROW_TYPE).build();
        List<String> partitionKeys = Collections.singletonList("");
        List partitions = fileIndex.getPartitions(partitionKeys, (String)FlinkOptions.PARTITION_DEFAULT_NAME.defaultValue(), false);
        MatcherAssert.assertThat((Object)partitions.size(), (Matcher)CoreMatchers.is((Object)0));
        List pathInfoList = fileIndex.getFilesInPartitions();
        MatcherAssert.assertThat((Object)pathInfoList.size(), (Matcher)CoreMatchers.is((Object)1));
        Assertions.assertTrue((boolean)((StoragePathInfo)pathInfoList.get(0)).getPath().toString().endsWith(HoodieFileFormat.PARQUET.getFileExtension()));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testFileListingEmptyTable(boolean enableMetadata) {
        Configuration conf = TestConfigurations.getDefaultConf(this.tempFile.getAbsolutePath());
        conf.setBoolean(FlinkOptions.METADATA_ENABLED, enableMetadata);
        FileIndex fileIndex = FileIndex.builder().path(new StoragePath(this.tempFile.getAbsolutePath())).conf(conf).rowType(TestConfigurations.ROW_TYPE).build();
        List<String> partitionKeys = Collections.singletonList("partition");
        List partitions = fileIndex.getPartitions(partitionKeys, (String)FlinkOptions.PARTITION_DEFAULT_NAME.defaultValue(), false);
        MatcherAssert.assertThat((Object)partitions.size(), (Matcher)CoreMatchers.is((Object)0));
        List pathInfoList = fileIndex.getFilesInPartitions();
        MatcherAssert.assertThat((Object)pathInfoList.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    void testFileListingWithDataSkipping() throws Exception {
        Configuration conf = TestConfigurations.getDefaultConf(this.tempFile.getAbsolutePath(), TestConfigurations.ROW_DATA_TYPE_BIGINT);
        conf.set(FlinkOptions.TABLE_TYPE, (Object)FlinkOptions.TABLE_TYPE_COPY_ON_WRITE);
        conf.setBoolean(FlinkOptions.METADATA_ENABLED, true);
        conf.setBoolean(FlinkOptions.READ_DATA_SKIPPING_ENABLED, true);
        conf.setBoolean(HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key(), true);
        this.writeBigintDataset(conf);
        FileIndex fileIndex = FileIndex.builder().path(new StoragePath(this.tempFile.getAbsolutePath())).conf(conf).rowType(TestConfigurations.ROW_TYPE_BIGINT).columnStatsProbe(ColumnStatsProbe.newInstance(Collections.singletonList(new CallExpression(FunctionIdentifier.of((String)"greaterThan"), (FunctionDefinition)BuiltInFunctionDefinitions.GREATER_THAN, Arrays.asList(new FieldReferenceExpression("uuid", DataTypes.BIGINT(), 0, 0), new ValueLiteralExpression((Object)5, (DataType)DataTypes.TINYINT().notNull())), DataTypes.BOOLEAN())))).partitionPruner(null).build();
        List files = fileIndex.getFilesInPartitions();
        MatcherAssert.assertThat((Object)files.size(), (Matcher)CoreMatchers.is((Object)2));
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    void testFileListingWithPartitionStatsPruning(HoodieTableType tableType) throws Exception {
        Configuration conf = TestConfigurations.getDefaultConf(this.tempFile.getAbsolutePath());
        conf.set(FlinkOptions.READ_DATA_SKIPPING_ENABLED, (Object)true);
        conf.set(FlinkOptions.METADATA_ENABLED, (Object)true);
        conf.set(FlinkOptions.TABLE_TYPE, (Object)tableType.name());
        conf.setBoolean(HoodieMetadataConfig.ENABLE_METADATA_INDEX_PARTITION_STATS.key(), true);
        conf.setBoolean(HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key(), true);
        if (tableType == HoodieTableType.MERGE_ON_READ) {
            conf.setBoolean(HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key(), true);
        }
        TestData.writeData(TestData.DATA_SET_INSERT, conf);
        ColumnStatsProbe columnStatsProbe = ColumnStatsProbe.newInstance(Arrays.asList(new CallExpression(FunctionIdentifier.of((String)"greaterThan"), (FunctionDefinition)BuiltInFunctionDefinitions.GREATER_THAN, Arrays.asList(new FieldReferenceExpression("uuid", DataTypes.STRING(), 0, 0), new ValueLiteralExpression((Object)"id5", (DataType)DataTypes.STRING().notNull())), DataTypes.BOOLEAN()), new CallExpression(FunctionIdentifier.of((String)"lessThan"), (FunctionDefinition)BuiltInFunctionDefinitions.LESS_THAN, Arrays.asList(new FieldReferenceExpression("age", DataTypes.INT(), 2, 2), new ValueLiteralExpression((Object)30, (DataType)DataTypes.INT().notNull())), DataTypes.BOOLEAN())));
        FileIndex fileIndex = FileIndex.builder().path(new StoragePath(this.tempFile.getAbsolutePath())).conf(conf).rowType(TestConfigurations.ROW_TYPE).partitionPruner(PartitionPruners.builder().rowType(TestConfigurations.ROW_TYPE).basePath(this.tempFile.getAbsolutePath()).conf(conf).columnStatsProbe(columnStatsProbe).build()).build();
        List p = fileIndex.getOrBuildPartitionPaths();
        Assertions.assertEquals(Arrays.asList("par3"), (Object)p);
    }

    private void writeBigintDataset(Configuration conf) throws Exception {
        List<RowData> dataset = Arrays.asList(TestData.insertRow(TestConfigurations.ROW_TYPE_BIGINT, new Object[]{1L, StringData.fromString((String)"Danny"), 23, TimestampData.fromEpochMillis((long)1L), StringData.fromString((String)"par1")}), TestData.insertRow(TestConfigurations.ROW_TYPE_BIGINT, new Object[]{2L, StringData.fromString((String)"Stephen"), 33, TimestampData.fromEpochMillis((long)2L), StringData.fromString((String)"par1")}), TestData.insertRow(TestConfigurations.ROW_TYPE_BIGINT, new Object[]{3L, StringData.fromString((String)"Julian"), 53, TimestampData.fromEpochMillis((long)3L), StringData.fromString((String)"par2")}), TestData.insertRow(TestConfigurations.ROW_TYPE_BIGINT, new Object[]{4L, StringData.fromString((String)"Fabian"), 31, TimestampData.fromEpochMillis((long)4L), StringData.fromString((String)"par2")}), TestData.insertRow(TestConfigurations.ROW_TYPE_BIGINT, new Object[]{5L, StringData.fromString((String)"Sophia"), 18, TimestampData.fromEpochMillis((long)5L), StringData.fromString((String)"par3")}), TestData.insertRow(TestConfigurations.ROW_TYPE_BIGINT, new Object[]{6L, StringData.fromString((String)"Emma"), 20, TimestampData.fromEpochMillis((long)6L), StringData.fromString((String)"par3")}), TestData.insertRow(TestConfigurations.ROW_TYPE_BIGINT, new Object[]{7L, StringData.fromString((String)"Bob"), 44, TimestampData.fromEpochMillis((long)7L), StringData.fromString((String)"par4")}), TestData.insertRow(TestConfigurations.ROW_TYPE_BIGINT, new Object[]{8L, StringData.fromString((String)"Han"), 56, TimestampData.fromEpochMillis((long)8L), StringData.fromString((String)"par4")}));
        TestData.writeData(dataset, conf);
    }
}

