/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.source;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.hudi.source.ExpressionPredicates;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.filter2.predicate.Operators;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestExpressionPredicates {
    private static final String TEST_NAME_WITH_PARAMS = "[{index}] Test with fieldName={0}, dataType={1}, literalValue={2}";

    @Test
    public void testFilterPredicateFromExpression() {
        FieldReferenceExpression fieldReference = new FieldReferenceExpression("f_int", DataTypes.INT(), 0, 0);
        ValueLiteralExpression valueLiteral = new ValueLiteralExpression((Object)10);
        List<ResolvedExpression> expressions = Arrays.asList(fieldReference, valueLiteral);
        Operators.IntColumn intColumn = FilterApi.intColumn((String)"f_int");
        CallExpression equalsExpression = new CallExpression((FunctionDefinition)BuiltInFunctionDefinitions.EQUALS, expressions, DataTypes.BOOLEAN());
        ExpressionPredicates.ColumnPredicate predicate1 = ExpressionPredicates.Equals.getInstance().bindValueLiteral(valueLiteral).bindFieldReference(fieldReference);
        Operators.Eq eq = FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(10));
        ExpressionPredicates.Predicate predicate2 = ExpressionPredicates.fromExpression((CallExpression)equalsExpression);
        Assertions.assertEquals((Object)predicate1.toString(), (Object)predicate2.toString());
        Assertions.assertEquals((Object)eq, (Object)predicate2.filter());
        CallExpression notEqualsExpression = new CallExpression((FunctionDefinition)BuiltInFunctionDefinitions.NOT_EQUALS, expressions, DataTypes.BOOLEAN());
        ExpressionPredicates.ColumnPredicate predicate3 = ExpressionPredicates.NotEquals.getInstance().bindValueLiteral(valueLiteral).bindFieldReference(fieldReference);
        ExpressionPredicates.Predicate predicate4 = ExpressionPredicates.fromExpression((CallExpression)notEqualsExpression);
        Assertions.assertEquals((Object)predicate3.toString(), (Object)predicate4.toString());
        Assertions.assertEquals((Object)FilterApi.notEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(10)), (Object)predicate4.filter());
        CallExpression lessThanExpression = new CallExpression((FunctionDefinition)BuiltInFunctionDefinitions.LESS_THAN, expressions, DataTypes.BOOLEAN());
        ExpressionPredicates.ColumnPredicate predicate5 = ExpressionPredicates.LessThan.getInstance().bindValueLiteral(valueLiteral).bindFieldReference(fieldReference);
        Operators.Lt lt = FilterApi.lt((Operators.Column)intColumn, (Comparable)Integer.valueOf(10));
        ExpressionPredicates.Predicate predicate6 = ExpressionPredicates.fromExpression((CallExpression)lessThanExpression);
        Assertions.assertEquals((Object)predicate5.toString(), (Object)predicate6.toString());
        Assertions.assertEquals((Object)lt, (Object)predicate6.filter());
        CallExpression greaterThanExpression = new CallExpression((FunctionDefinition)BuiltInFunctionDefinitions.GREATER_THAN, expressions, DataTypes.BOOLEAN());
        ExpressionPredicates.ColumnPredicate predicate7 = ExpressionPredicates.GreaterThan.getInstance().bindValueLiteral(valueLiteral).bindFieldReference(fieldReference);
        Operators.Gt gt = FilterApi.gt((Operators.Column)intColumn, (Comparable)Integer.valueOf(10));
        ExpressionPredicates.Predicate predicate8 = ExpressionPredicates.fromExpression((CallExpression)greaterThanExpression);
        Assertions.assertEquals((Object)predicate7.toString(), (Object)predicate8.toString());
        Assertions.assertEquals((Object)gt, (Object)predicate8.filter());
        CallExpression lessThanOrEqualExpression = new CallExpression((FunctionDefinition)BuiltInFunctionDefinitions.LESS_THAN_OR_EQUAL, expressions, DataTypes.BOOLEAN());
        ExpressionPredicates.ColumnPredicate predicate9 = ExpressionPredicates.LessThanOrEqual.getInstance().bindValueLiteral(valueLiteral).bindFieldReference(fieldReference);
        ExpressionPredicates.Predicate predicate10 = ExpressionPredicates.fromExpression((CallExpression)lessThanOrEqualExpression);
        Assertions.assertEquals((Object)predicate9.toString(), (Object)predicate10.toString());
        Assertions.assertEquals((Object)FilterApi.ltEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(10)), (Object)predicate10.filter());
        CallExpression greaterThanOrEqualExpression = new CallExpression((FunctionDefinition)BuiltInFunctionDefinitions.GREATER_THAN_OR_EQUAL, expressions, DataTypes.BOOLEAN());
        ExpressionPredicates.ColumnPredicate predicate11 = ExpressionPredicates.GreaterThanOrEqual.getInstance().bindValueLiteral(valueLiteral).bindFieldReference(fieldReference);
        ExpressionPredicates.Predicate predicate12 = ExpressionPredicates.fromExpression((CallExpression)greaterThanOrEqualExpression);
        Assertions.assertEquals((Object)predicate11.toString(), (Object)predicate12.toString());
        Assertions.assertEquals((Object)FilterApi.gtEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(10)), (Object)predicate12.filter());
        ValueLiteralExpression valueLiteral1 = new ValueLiteralExpression((Object)11);
        ValueLiteralExpression valueLiteral2 = new ValueLiteralExpression((Object)12);
        CallExpression inExpression = new CallExpression((FunctionDefinition)BuiltInFunctionDefinitions.IN, Arrays.asList(fieldReference, valueLiteral1, valueLiteral2), DataTypes.BOOLEAN());
        ExpressionPredicates.ColumnPredicate predicate13 = ExpressionPredicates.In.getInstance().bindValueLiterals(Arrays.asList(valueLiteral1, valueLiteral2)).bindFieldReference(fieldReference);
        ExpressionPredicates.Predicate predicate14 = ExpressionPredicates.fromExpression((CallExpression)inExpression);
        Assertions.assertEquals((Object)predicate13.toString(), (Object)predicate14.toString());
        Assertions.assertEquals((Object)FilterApi.or((FilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(11)), (FilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(12))), (Object)predicate14.filter());
        CallExpression notExpression = new CallExpression((FunctionDefinition)BuiltInFunctionDefinitions.NOT, Collections.singletonList(equalsExpression), DataTypes.BOOLEAN());
        ExpressionPredicates.Predicate predicate15 = ExpressionPredicates.Not.getInstance().bindPredicate(predicate2);
        ExpressionPredicates.Predicate predicate16 = ExpressionPredicates.fromExpression((CallExpression)notExpression);
        Assertions.assertEquals((Object)predicate15.toString(), (Object)predicate16.toString());
        Assertions.assertEquals((Object)FilterApi.not((FilterPredicate)eq), (Object)predicate16.filter());
        CallExpression andExpression = new CallExpression((FunctionDefinition)BuiltInFunctionDefinitions.AND, Arrays.asList(lessThanExpression, greaterThanExpression), DataTypes.BOOLEAN());
        ExpressionPredicates.Predicate predicate17 = ExpressionPredicates.And.getInstance().bindPredicates(new ExpressionPredicates.Predicate[]{predicate6, predicate8});
        ExpressionPredicates.Predicate predicate18 = ExpressionPredicates.fromExpression((CallExpression)andExpression);
        Assertions.assertEquals((Object)predicate17.toString(), (Object)predicate18.toString());
        Assertions.assertEquals((Object)FilterApi.and((FilterPredicate)lt, (FilterPredicate)gt), (Object)predicate18.filter());
        CallExpression orExpression = new CallExpression((FunctionDefinition)BuiltInFunctionDefinitions.OR, Arrays.asList(lessThanExpression, greaterThanExpression), DataTypes.BOOLEAN());
        ExpressionPredicates.Predicate predicate19 = ExpressionPredicates.Or.getInstance().bindPredicates(new ExpressionPredicates.Predicate[]{predicate6, predicate8});
        ExpressionPredicates.Predicate predicate20 = ExpressionPredicates.fromExpression((CallExpression)orExpression);
        Assertions.assertEquals((Object)predicate19.toString(), (Object)predicate20.toString());
        Assertions.assertEquals((Object)FilterApi.or((FilterPredicate)lt, (FilterPredicate)gt), (Object)predicate20.filter());
    }

    @Test
    public void testDisablePredicatesPushDownForUnsupportedType() {
        FieldReferenceExpression fieldReference = new FieldReferenceExpression("f_decimal", DataTypes.DECIMAL((int)7, (int)2), 0, 0);
        ValueLiteralExpression valueLiteral = new ValueLiteralExpression((Object)BigDecimal.valueOf(100.0));
        List<ResolvedExpression> expressions = Arrays.asList(fieldReference, valueLiteral);
        CallExpression greaterThanExpression = new CallExpression((FunctionDefinition)BuiltInFunctionDefinitions.GREATER_THAN, expressions, DataTypes.DECIMAL((int)7, (int)2));
        ExpressionPredicates.Predicate greaterThanPredicate = ExpressionPredicates.fromExpression((CallExpression)greaterThanExpression);
        CallExpression lessThanExpression = new CallExpression((FunctionDefinition)BuiltInFunctionDefinitions.LESS_THAN, expressions, DataTypes.DECIMAL((int)7, (int)2));
        ExpressionPredicates.Predicate lessThanPredicate = ExpressionPredicates.fromExpression((CallExpression)lessThanExpression);
        Assertions.assertNull((Object)ExpressionPredicates.And.getInstance().bindPredicates(new ExpressionPredicates.Predicate[]{greaterThanPredicate, lessThanPredicate}).filter(), (String)"Decimal type push down is unsupported, so we expect null");
        Assertions.assertNull((Object)ExpressionPredicates.Or.getInstance().bindPredicates(new ExpressionPredicates.Predicate[]{greaterThanPredicate, lessThanPredicate}).filter(), (String)"Decimal type push down is unsupported, so we expect null");
        Assertions.assertNull((Object)ExpressionPredicates.Not.getInstance().bindPredicate(greaterThanPredicate).filter(), (String)"Decimal type push down is unsupported, so we expect null");
    }

    public static Stream<Arguments> testColumnPredicateLiteralTypeConversionParams() {
        return Stream.of(Arguments.of((Object[])new Object[]{"f_boolean", DataTypes.BOOLEAN(), Boolean.TRUE}), Arguments.of((Object[])new Object[]{"f_boolean", DataTypes.BOOLEAN(), "true"}), Arguments.of((Object[])new Object[]{"f_tinyint", DataTypes.TINYINT(), 12345}), Arguments.of((Object[])new Object[]{"f_tinyint", DataTypes.TINYINT(), "12345"}), Arguments.of((Object[])new Object[]{"f_smallint", DataTypes.SMALLINT(), 12345}), Arguments.of((Object[])new Object[]{"f_smallint", DataTypes.SMALLINT(), "12345"}), Arguments.of((Object[])new Object[]{"f_integer", DataTypes.INT(), 12345}), Arguments.of((Object[])new Object[]{"f_integer", DataTypes.INT(), "12345"}), Arguments.of((Object[])new Object[]{"f_bigint", DataTypes.BIGINT(), 12345L}), Arguments.of((Object[])new Object[]{"f_bigint", DataTypes.BIGINT(), 12345}), Arguments.of((Object[])new Object[]{"f_bigint", DataTypes.BIGINT(), "12345"}), Arguments.of((Object[])new Object[]{"f_float", DataTypes.FLOAT(), Float.valueOf(123.45f)}), Arguments.of((Object[])new Object[]{"f_float", DataTypes.FLOAT(), "123.45f"}), Arguments.of((Object[])new Object[]{"f_double", DataTypes.DOUBLE(), 123.45}), Arguments.of((Object[])new Object[]{"f_double", DataTypes.DOUBLE(), "123.45"}), Arguments.of((Object[])new Object[]{"f_varbinary", DataTypes.VARBINARY((int)10), "a".getBytes()}), Arguments.of((Object[])new Object[]{"f_varbinary", DataTypes.VARBINARY((int)10), "a"}), Arguments.of((Object[])new Object[]{"f_binary", DataTypes.BINARY((int)10), "a".getBytes()}), Arguments.of((Object[])new Object[]{"f_binary", DataTypes.BINARY((int)10), "a"}), Arguments.of((Object[])new Object[]{"f_date", DataTypes.DATE(), LocalDate.now()}), Arguments.of((Object[])new Object[]{"f_date", DataTypes.DATE(), 19740}), Arguments.of((Object[])new Object[]{"f_date", DataTypes.DATE(), 19740L}), Arguments.of((Object[])new Object[]{"f_date", DataTypes.DATE(), "2024-01-18"}), Arguments.of((Object[])new Object[]{"f_char", DataTypes.CHAR((int)1), "a"}), Arguments.of((Object[])new Object[]{"f_char", DataTypes.CHAR((int)1), 1}), Arguments.of((Object[])new Object[]{"f_varchar", DataTypes.VARCHAR((int)1), "a"}), Arguments.of((Object[])new Object[]{"f_varchar", DataTypes.VARCHAR((int)1), 1}), Arguments.of((Object[])new Object[]{"f_time", DataTypes.TIME(), LocalTime.now()}), Arguments.of((Object[])new Object[]{"f_time", DataTypes.TIME(), 12345}), Arguments.of((Object[])new Object[]{"f_time", DataTypes.TIME(), 60981896000L}), Arguments.of((Object[])new Object[]{"f_time", DataTypes.TIME(), "20:00:00"}), Arguments.of((Object[])new Object[]{"f_timestamp", DataTypes.TIMESTAMP(), LocalDateTime.now()}), Arguments.of((Object[])new Object[]{"f_timestamp", DataTypes.TIMESTAMP(), 12345}), Arguments.of((Object[])new Object[]{"f_timestamp", DataTypes.TIMESTAMP(), 1705568913701L}), Arguments.of((Object[])new Object[]{"f_timestamp", DataTypes.TIMESTAMP(), "2024-01-18T15:00:00"}));
    }

    @ParameterizedTest(name="[{index}] Test with fieldName={0}, dataType={1}, literalValue={2}")
    @MethodSource(value={"testColumnPredicateLiteralTypeConversionParams"})
    public void testColumnPredicateLiteralTypeConversion(String fieldName, DataType dataType, Object literalValue) {
        FieldReferenceExpression fieldReference = new FieldReferenceExpression(fieldName, dataType, 0, 0);
        ValueLiteralExpression valueLiteral = new ValueLiteralExpression(literalValue);
        ExpressionPredicates.ColumnPredicate predicate = ExpressionPredicates.Equals.getInstance().bindFieldReference(fieldReference).bindValueLiteral(valueLiteral);
        Assertions.assertDoesNotThrow(() -> ((ExpressionPredicates.ColumnPredicate)predicate).filter(), () -> String.format("Convert from %s to %s failed", literalValue.getClass().getName(), dataType));
    }
}

