/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.source;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hudi.source.ExpressionEvaluators;
import org.apache.hudi.source.prune.ColumnStatsProbe;
import org.apache.hudi.utils.TestData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class TestExpressionEvaluators {
    private static final DataType ROW_DATA_TYPE = (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f_tinyint", (DataType)DataTypes.TINYINT()), DataTypes.FIELD((String)"f_smallint", (DataType)DataTypes.SMALLINT()), DataTypes.FIELD((String)"f_int", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f_long", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"f_float", (DataType)DataTypes.FLOAT()), DataTypes.FIELD((String)"f_double", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"f_boolean", (DataType)DataTypes.BOOLEAN()), DataTypes.FIELD((String)"f_decimal", (DataType)DataTypes.DECIMAL((int)10, (int)2)), DataTypes.FIELD((String)"f_bytes", (DataType)DataTypes.VARBINARY((int)10)), DataTypes.FIELD((String)"f_string", (DataType)DataTypes.VARCHAR((int)10)), DataTypes.FIELD((String)"f_time", (DataType)DataTypes.TIME((int)3)), DataTypes.FIELD((String)"f_date", (DataType)DataTypes.DATE()), DataTypes.FIELD((String)"f_timestamp", (DataType)DataTypes.TIMESTAMP((int)3))}).notNull();
    private static final DataType INDEX_ROW_DATA_TYPE = (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"file_name", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"value_cnt", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"f_int_min", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f_int_max", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f_int_null_cnt", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"f_string_min", (DataType)DataTypes.VARCHAR((int)10)), DataTypes.FIELD((String)"f_string_max", (DataType)DataTypes.VARCHAR((int)10)), DataTypes.FIELD((String)"f_string_null_cnt", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"f_timestamp_min", (DataType)DataTypes.TIMESTAMP((int)3)), DataTypes.FIELD((String)"f_timestamp_max", (DataType)DataTypes.TIMESTAMP((int)3)), DataTypes.FIELD((String)"f_timestamp_null_cnt", (DataType)DataTypes.BIGINT())}).notNull();
    private static final RowType INDEX_ROW_TYPE = (RowType)INDEX_ROW_DATA_TYPE.getLogicalType();

    @Test
    void testEqualTo() {
        ExpressionEvaluators.EqualTo equalTo = ExpressionEvaluators.EqualTo.getInstance();
        FieldReferenceExpression rExpr = new FieldReferenceExpression("f_int", DataTypes.INT(), 2, 2);
        ValueLiteralExpression vExpr = new ValueLiteralExpression((Object)12);
        equalTo.bindVal(vExpr).bindFieldReference(rExpr);
        RowData indexRow1 = TestExpressionEvaluators.intIndexRow(11, 13);
        Map stats1 = ColumnStatsProbe.convertColumnStats((RowData)indexRow1, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertTrue((boolean)equalTo.eval(stats1), (String)"11 < 12 < 13");
        RowData indexRow2 = TestExpressionEvaluators.intIndexRow(12, 13);
        Map stats2 = ColumnStatsProbe.convertColumnStats((RowData)indexRow2, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertTrue((boolean)equalTo.eval(stats2), (String)"12 <= 12 < 13");
        RowData indexRow3 = TestExpressionEvaluators.intIndexRow(11, 12);
        Map stats3 = ColumnStatsProbe.convertColumnStats((RowData)indexRow3, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertTrue((boolean)equalTo.eval(stats3), (String)"11 < 12 <= 12");
        RowData indexRow4 = TestExpressionEvaluators.intIndexRow(10, 11);
        Map stats4 = ColumnStatsProbe.convertColumnStats((RowData)indexRow4, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertFalse((boolean)equalTo.eval(stats4), (String)"11 < 12");
        RowData indexRow5 = TestExpressionEvaluators.intIndexRow(13, 14);
        Map stats5 = ColumnStatsProbe.convertColumnStats((RowData)indexRow5, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertFalse((boolean)equalTo.eval(stats5), (String)"12 < 13");
        RowData indexRow6 = TestExpressionEvaluators.intIndexRow(null, null);
        Map stats6 = ColumnStatsProbe.convertColumnStats((RowData)indexRow6, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertFalse((boolean)equalTo.eval(stats6), (String)"12 <> null");
        equalTo.bindVal(new ValueLiteralExpression(null, DataTypes.INT()));
        Assertions.assertFalse((boolean)equalTo.eval(stats1), (String)"It is not possible to test for NULL values with '=' operator");
    }

    @Test
    void testNotEqualTo() {
        ExpressionEvaluators.NotEqualTo notEqualTo = ExpressionEvaluators.NotEqualTo.getInstance();
        FieldReferenceExpression rExpr = new FieldReferenceExpression("f_int", DataTypes.INT(), 2, 2);
        ValueLiteralExpression vExpr = new ValueLiteralExpression((Object)12);
        RowData indexRow1 = TestExpressionEvaluators.intIndexRow(11, 13);
        notEqualTo.bindVal(vExpr).bindFieldReference(rExpr);
        Map stats1 = ColumnStatsProbe.convertColumnStats((RowData)indexRow1, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertTrue((boolean)notEqualTo.eval(stats1), (String)"11 <> 12 && 12 <> 13");
        RowData indexRow2 = TestExpressionEvaluators.intIndexRow(12, 13);
        Map stats2 = ColumnStatsProbe.convertColumnStats((RowData)indexRow2, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertTrue((boolean)notEqualTo.eval(stats2), (String)"12 <> 13");
        RowData indexRow3 = TestExpressionEvaluators.intIndexRow(11, 12);
        Map stats3 = ColumnStatsProbe.convertColumnStats((RowData)indexRow3, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertTrue((boolean)notEqualTo.eval(stats3), (String)"11 <> 12");
        RowData indexRow4 = TestExpressionEvaluators.intIndexRow(10, 11);
        Map stats4 = ColumnStatsProbe.convertColumnStats((RowData)indexRow4, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertTrue((boolean)notEqualTo.eval(stats4), (String)"10 <> 12 and 11 < 12");
        RowData indexRow5 = TestExpressionEvaluators.intIndexRow(13, 14);
        Map stats5 = ColumnStatsProbe.convertColumnStats((RowData)indexRow5, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertTrue((boolean)notEqualTo.eval(stats5), (String)"12 <> 13 and 12 <> 14");
        RowData indexRow6 = TestExpressionEvaluators.intIndexRow(null, null);
        Map stats6 = ColumnStatsProbe.convertColumnStats((RowData)indexRow6, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertFalse((boolean)notEqualTo.eval(stats6), (String)"12 <> null");
        RowData indexRow7 = TestExpressionEvaluators.intIndexRow(12, 12);
        Map stats7 = ColumnStatsProbe.convertColumnStats((RowData)indexRow7, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertFalse((boolean)notEqualTo.eval(stats7), (String)"12 == 12 == 12");
        notEqualTo.bindVal(new ValueLiteralExpression(null, DataTypes.INT()));
        Assertions.assertFalse((boolean)notEqualTo.eval(stats1), (String)"It is not possible to test for NULL values with '<>' operator");
    }

    @Test
    void testIsNull() {
        ExpressionEvaluators.IsNull isNull = ExpressionEvaluators.IsNull.getInstance();
        FieldReferenceExpression rExpr = new FieldReferenceExpression("f_int", DataTypes.INT(), 2, 2);
        RowData indexRow1 = TestExpressionEvaluators.intIndexRow(11, 13);
        isNull.bindFieldReference(rExpr);
        Map stats1 = ColumnStatsProbe.convertColumnStats((RowData)indexRow1, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertTrue((boolean)isNull.eval(stats1), (String)"2 nulls");
        RowData indexRow2 = TestExpressionEvaluators.intIndexRow(12, 13, 0L);
        Map stats2 = ColumnStatsProbe.convertColumnStats((RowData)indexRow2, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertFalse((boolean)isNull.eval(stats2), (String)"0 nulls");
    }

    @Test
    void testIsNotNull() {
        ExpressionEvaluators.IsNotNull isNotNull = ExpressionEvaluators.IsNotNull.getInstance();
        FieldReferenceExpression rExpr = new FieldReferenceExpression("f_int", DataTypes.INT(), 2, 2);
        RowData indexRow1 = TestExpressionEvaluators.intIndexRow(11, 13);
        isNotNull.bindFieldReference(rExpr);
        Map stats1 = ColumnStatsProbe.convertColumnStats((RowData)indexRow1, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertTrue((boolean)isNotNull.eval(stats1), (String)"min 11 is not null");
        RowData indexRow2 = TestExpressionEvaluators.intIndexRow(null, null, 0L);
        Map stats2 = ColumnStatsProbe.convertColumnStats((RowData)indexRow2, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertTrue((boolean)isNotNull.eval(stats2), (String)"min is null and 0 nulls");
    }

    @Test
    void testLessThan() {
        ExpressionEvaluators.LessThan lessThan = ExpressionEvaluators.LessThan.getInstance();
        FieldReferenceExpression rExpr = new FieldReferenceExpression("f_int", DataTypes.INT(), 2, 2);
        ValueLiteralExpression vExpr = new ValueLiteralExpression((Object)12);
        RowData indexRow1 = TestExpressionEvaluators.intIndexRow(11, 13);
        lessThan.bindVal(vExpr).bindFieldReference(rExpr);
        Map stats1 = ColumnStatsProbe.convertColumnStats((RowData)indexRow1, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertTrue((boolean)lessThan.eval(stats1), (String)"12 < 13");
        RowData indexRow2 = TestExpressionEvaluators.intIndexRow(12, 13);
        Map stats2 = ColumnStatsProbe.convertColumnStats((RowData)indexRow2, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertFalse((boolean)lessThan.eval(stats2), (String)"min 12 = 12");
        RowData indexRow3 = TestExpressionEvaluators.intIndexRow(11, 12);
        Map stats3 = ColumnStatsProbe.convertColumnStats((RowData)indexRow3, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertTrue((boolean)lessThan.eval(stats3), (String)"11 < 12");
        RowData indexRow4 = TestExpressionEvaluators.intIndexRow(10, 11);
        Map stats4 = ColumnStatsProbe.convertColumnStats((RowData)indexRow4, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertTrue((boolean)lessThan.eval(stats4), (String)"11 < 12");
        RowData indexRow5 = TestExpressionEvaluators.intIndexRow(13, 14);
        Map stats5 = ColumnStatsProbe.convertColumnStats((RowData)indexRow5, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertFalse((boolean)lessThan.eval(stats5), (String)"12 < min 13");
        RowData indexRow6 = TestExpressionEvaluators.intIndexRow(null, null);
        Map stats6 = ColumnStatsProbe.convertColumnStats((RowData)indexRow6, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertFalse((boolean)lessThan.eval(stats6), (String)"12 <> null");
        lessThan.bindVal(new ValueLiteralExpression(null, DataTypes.INT()));
        Assertions.assertFalse((boolean)lessThan.eval(stats1), (String)"It is not possible to test for NULL values with '<' operator");
    }

    @Test
    void testGreaterThan() {
        ExpressionEvaluators.GreaterThan greaterThan = ExpressionEvaluators.GreaterThan.getInstance();
        FieldReferenceExpression rExpr = new FieldReferenceExpression("f_int", DataTypes.INT(), 2, 2);
        ValueLiteralExpression vExpr = new ValueLiteralExpression((Object)12);
        RowData indexRow1 = TestExpressionEvaluators.intIndexRow(11, 13);
        greaterThan.bindVal(vExpr).bindFieldReference(rExpr);
        Map stats1 = ColumnStatsProbe.convertColumnStats((RowData)indexRow1, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertTrue((boolean)greaterThan.eval(stats1), (String)"12 < 13");
        RowData indexRow2 = TestExpressionEvaluators.intIndexRow(12, 13);
        Map stats2 = ColumnStatsProbe.convertColumnStats((RowData)indexRow2, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertTrue((boolean)greaterThan.eval(stats2), (String)"12 < 13");
        RowData indexRow3 = TestExpressionEvaluators.intIndexRow(11, 12);
        Map stats3 = ColumnStatsProbe.convertColumnStats((RowData)indexRow3, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertFalse((boolean)greaterThan.eval(stats3), (String)"max 12 = 12");
        RowData indexRow4 = TestExpressionEvaluators.intIndexRow(10, 11);
        Map stats4 = ColumnStatsProbe.convertColumnStats((RowData)indexRow4, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertFalse((boolean)greaterThan.eval(stats4), (String)"max 11 < 12");
        RowData indexRow5 = TestExpressionEvaluators.intIndexRow(13, 14);
        Map stats5 = ColumnStatsProbe.convertColumnStats((RowData)indexRow5, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertTrue((boolean)greaterThan.eval(stats5), (String)"12 < 13");
        RowData indexRow6 = TestExpressionEvaluators.intIndexRow(null, null);
        Map stats6 = ColumnStatsProbe.convertColumnStats((RowData)indexRow6, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertFalse((boolean)greaterThan.eval(stats6), (String)"12 <> null");
        greaterThan.bindVal(new ValueLiteralExpression(null, DataTypes.INT()));
        Assertions.assertFalse((boolean)greaterThan.eval(stats1), (String)"It is not possible to test for NULL values with '>' operator");
    }

    @Test
    void testLessThanOrEqual() {
        ExpressionEvaluators.LessThanOrEqual lessThanOrEqual = ExpressionEvaluators.LessThanOrEqual.getInstance();
        FieldReferenceExpression rExpr = new FieldReferenceExpression("f_int", DataTypes.INT(), 2, 2);
        ValueLiteralExpression vExpr = new ValueLiteralExpression((Object)12);
        RowData indexRow1 = TestExpressionEvaluators.intIndexRow(11, 13);
        lessThanOrEqual.bindVal(vExpr).bindFieldReference(rExpr);
        Map stats1 = ColumnStatsProbe.convertColumnStats((RowData)indexRow1, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertTrue((boolean)lessThanOrEqual.eval(stats1), (String)"11 < 12");
        RowData indexRow2 = TestExpressionEvaluators.intIndexRow(12, 13);
        Map stats2 = ColumnStatsProbe.convertColumnStats((RowData)indexRow2, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertTrue((boolean)lessThanOrEqual.eval(stats2), (String)"min 12 = 12");
        RowData indexRow3 = TestExpressionEvaluators.intIndexRow(11, 12);
        Map stats3 = ColumnStatsProbe.convertColumnStats((RowData)indexRow3, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertTrue((boolean)lessThanOrEqual.eval(stats3), (String)"max 12 = 12");
        RowData indexRow4 = TestExpressionEvaluators.intIndexRow(10, 11);
        Map stats4 = ColumnStatsProbe.convertColumnStats((RowData)indexRow4, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertTrue((boolean)lessThanOrEqual.eval(stats4), (String)"max 11 < 12");
        RowData indexRow5 = TestExpressionEvaluators.intIndexRow(13, 14);
        Map stats5 = ColumnStatsProbe.convertColumnStats((RowData)indexRow5, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertFalse((boolean)lessThanOrEqual.eval(stats5), (String)"12 < 13");
        RowData indexRow6 = TestExpressionEvaluators.intIndexRow(null, null);
        Map stats6 = ColumnStatsProbe.convertColumnStats((RowData)indexRow6, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertFalse((boolean)lessThanOrEqual.eval(stats6), (String)"12 <> null");
        lessThanOrEqual.bindVal(new ValueLiteralExpression(null, DataTypes.INT()));
        Assertions.assertFalse((boolean)lessThanOrEqual.eval(stats1), (String)"It is not possible to test for NULL values with '<=' operator");
    }

    @Test
    void testGreaterThanOrEqual() {
        ExpressionEvaluators.GreaterThanOrEqual greaterThanOrEqual = ExpressionEvaluators.GreaterThanOrEqual.getInstance();
        FieldReferenceExpression rExpr = new FieldReferenceExpression("f_int", DataTypes.INT(), 2, 2);
        ValueLiteralExpression vExpr = new ValueLiteralExpression((Object)12);
        RowData indexRow1 = TestExpressionEvaluators.intIndexRow(11, 13);
        greaterThanOrEqual.bindVal(vExpr).bindFieldReference(rExpr);
        Map stats1 = ColumnStatsProbe.convertColumnStats((RowData)indexRow1, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertTrue((boolean)greaterThanOrEqual.eval(stats1), (String)"12 < 13");
        RowData indexRow2 = TestExpressionEvaluators.intIndexRow(12, 13);
        Map stats2 = ColumnStatsProbe.convertColumnStats((RowData)indexRow2, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertTrue((boolean)greaterThanOrEqual.eval(stats2), (String)"min 12 = 12");
        RowData indexRow3 = TestExpressionEvaluators.intIndexRow(11, 12);
        Map stats3 = ColumnStatsProbe.convertColumnStats((RowData)indexRow3, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertTrue((boolean)greaterThanOrEqual.eval(stats3), (String)"max 12 = 12");
        RowData indexRow4 = TestExpressionEvaluators.intIndexRow(10, 11);
        Map stats4 = ColumnStatsProbe.convertColumnStats((RowData)indexRow4, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertFalse((boolean)greaterThanOrEqual.eval(stats4), (String)"max 11 < 12");
        RowData indexRow5 = TestExpressionEvaluators.intIndexRow(13, 14);
        Map stats5 = ColumnStatsProbe.convertColumnStats((RowData)indexRow5, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertTrue((boolean)greaterThanOrEqual.eval(stats5), (String)"12 < 13");
        RowData indexRow6 = TestExpressionEvaluators.intIndexRow(null, null);
        Map stats6 = ColumnStatsProbe.convertColumnStats((RowData)indexRow6, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertFalse((boolean)greaterThanOrEqual.eval(stats6), (String)"12 <> null");
        greaterThanOrEqual.bindVal(new ValueLiteralExpression(null, DataTypes.INT()));
        Assertions.assertFalse((boolean)greaterThanOrEqual.eval(stats1), (String)"It is not possible to test for NULL values with '>=' operator");
    }

    @Test
    void testIn() {
        ExpressionEvaluators.In in = ExpressionEvaluators.In.getInstance();
        FieldReferenceExpression rExpr = new FieldReferenceExpression("f_int", DataTypes.INT(), 2, 2);
        RowData indexRow1 = TestExpressionEvaluators.intIndexRow(11, 13);
        in.bindFieldReference(rExpr);
        in.bindVals(new Object[]{11, 12});
        Map stats1 = ColumnStatsProbe.convertColumnStats((RowData)indexRow1, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertTrue((boolean)in.eval(stats1), (String)"11 < 12 < 13");
        RowData indexRow2 = TestExpressionEvaluators.intIndexRow(12, 13);
        Map stats2 = ColumnStatsProbe.convertColumnStats((RowData)indexRow2, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertTrue((boolean)in.eval(stats2), (String)"min 12 = 12");
        RowData indexRow3 = TestExpressionEvaluators.intIndexRow(11, 12);
        Map stats3 = ColumnStatsProbe.convertColumnStats((RowData)indexRow3, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertTrue((boolean)in.eval(stats3), (String)"max 12 = 12");
        RowData indexRow4 = TestExpressionEvaluators.intIndexRow(10, 11);
        Map stats4 = ColumnStatsProbe.convertColumnStats((RowData)indexRow4, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertTrue((boolean)in.eval(stats4), (String)"max 11 = 11");
        RowData indexRow5 = TestExpressionEvaluators.intIndexRow(13, 14);
        Map stats5 = ColumnStatsProbe.convertColumnStats((RowData)indexRow5, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertFalse((boolean)in.eval(stats5), (String)"12 < 13");
        RowData indexRow6 = TestExpressionEvaluators.intIndexRow(null, null);
        Map stats6 = ColumnStatsProbe.convertColumnStats((RowData)indexRow6, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertFalse((boolean)in.eval(stats6), (String)"12 <> null");
        in.bindVals(new Object[]{null});
        Assertions.assertFalse((boolean)in.eval(stats1), (String)"It is not possible to test for NULL values with 'in' operator");
    }

    @Test
    void testAlwaysFalse() {
        FunctionDefinition[] funDefs;
        FieldReferenceExpression ref = new FieldReferenceExpression("f_int", DataTypes.INT(), 2, 2);
        ValueLiteralExpression nullLiteral = new ValueLiteralExpression(null, DataTypes.INT());
        RowData indexRow = TestExpressionEvaluators.intIndexRow(11, 13);
        Map stats = ColumnStatsProbe.convertColumnStats((RowData)indexRow, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        for (FunctionDefinition funDef : funDefs = new FunctionDefinition[]{BuiltInFunctionDefinitions.EQUALS, BuiltInFunctionDefinitions.NOT_EQUALS, BuiltInFunctionDefinitions.LESS_THAN, BuiltInFunctionDefinitions.GREATER_THAN, BuiltInFunctionDefinitions.LESS_THAN_OR_EQUAL, BuiltInFunctionDefinitions.GREATER_THAN_OR_EQUAL, BuiltInFunctionDefinitions.IN}) {
            CallExpression expr = new CallExpression(funDef, Arrays.asList(ref, nullLiteral), DataTypes.BOOLEAN());
            Assertions.assertFalse((boolean)ExpressionEvaluators.fromExpression((CallExpression)expr).eval(stats));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"twelveObjects"})
    void testAllNumericDataTypes(Object twelve) {
        ExpressionEvaluators.GreaterThan greaterThan = ExpressionEvaluators.GreaterThan.getInstance();
        FieldReferenceExpression rExpr = new FieldReferenceExpression("f_int", DataTypes.INT(), 2, 2);
        ValueLiteralExpression vExpr = new ValueLiteralExpression(twelve);
        RowData indexRow = TestExpressionEvaluators.intIndexRow(11, 13);
        greaterThan.bindVal(vExpr).bindFieldReference(rExpr);
        Map stats = ColumnStatsProbe.convertColumnStats((RowData)indexRow, (RowType.RowField[])TestExpressionEvaluators.queryFields(2));
        Assertions.assertTrue((boolean)greaterThan.eval(stats), (String)"12 < 13");
    }

    public static Stream<Object> twelveObjects() {
        return Stream.of((byte)12, (short)12, 12, 12L, new BigDecimal(12), Float.valueOf(12.0f), 12.0);
    }

    private static RowData intIndexRow(Integer minVal, Integer maxVal) {
        return TestExpressionEvaluators.intIndexRow(minVal, maxVal, 2L);
    }

    private static RowData intIndexRow(Integer minVal, Integer maxVal, Long nullCnt) {
        return TestExpressionEvaluators.indexRow(StringData.fromString((String)"f1"), 100L, minVal, maxVal, nullCnt, StringData.fromString((String)"1"), StringData.fromString((String)"100"), 5L, TimestampData.fromEpochMillis((long)1L), TimestampData.fromEpochMillis((long)100L), 3L);
    }

    private static RowData indexRow(Object ... fields) {
        return TestData.insertRow(INDEX_ROW_TYPE, fields);
    }

    private static RowType.RowField[] queryFields(int ... pos) {
        List fields = ((RowType)ROW_DATA_TYPE.getLogicalType()).getFields();
        return (RowType.RowField[])Arrays.stream(pos).mapToObj(fields::get).toArray(RowType.RowField[]::new);
    }
}

