/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.utils.keyedstate;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.api.common.state.MapState;
import org.apache.hudi.sink.utils.MockMapState;
import org.apache.hudi.sink.utils.keyedstate.MockKeyContext;

public class MockKeyedMapState<K, V>
implements MapState<K, V>,
Cloneable {
    private MockKeyContext keyContext;
    private Map<Object, MockMapState<K, V>> mockMapStateMap;

    public MockKeyedMapState(MockKeyContext keyContext) {
        Objects.requireNonNull(keyContext, "keyContext is null");
        this.keyContext = keyContext;
    }

    public V get(K key) throws Exception {
        Objects.requireNonNull(this.keyContext.getCurrentKey(), "currentKey is null");
        MockMapState mapState = this.mockMapStateMap.computeIfAbsent(this.keyContext.getCurrentKey(), k -> new MockMapState());
        return mapState.get(key);
    }

    public void put(K key, V value) throws Exception {
        Objects.requireNonNull(this.keyContext.getCurrentKey(), "currentKey is null");
        MockMapState mapState = this.mockMapStateMap.computeIfAbsent(this.keyContext.getCurrentKey(), k -> new MockMapState());
        mapState.put(key, value);
    }

    public void putAll(Map<K, V> map) throws Exception {
        Objects.requireNonNull(this.keyContext.getCurrentKey(), "currentKey is null");
        MockMapState mapState = this.mockMapStateMap.computeIfAbsent(this.keyContext.getCurrentKey(), k -> new MockMapState());
        mapState.putAll(map);
    }

    public void remove(K key) throws Exception {
        Objects.requireNonNull(this.keyContext.getCurrentKey(), "currentKey is null");
        MockMapState mapState = this.mockMapStateMap.computeIfAbsent(this.keyContext.getCurrentKey(), k -> new MockMapState());
        mapState.remove(key);
    }

    public boolean contains(K key) throws Exception {
        Objects.requireNonNull(this.keyContext.getCurrentKey(), "currentKey is null");
        MockMapState mapState = this.mockMapStateMap.computeIfAbsent(this.keyContext.getCurrentKey(), k -> new MockMapState());
        return mapState.contains(key);
    }

    public Iterable<Map.Entry<K, V>> entries() throws Exception {
        Objects.requireNonNull(this.keyContext.getCurrentKey(), "currentKey is null");
        MockMapState mapState = this.mockMapStateMap.computeIfAbsent(this.keyContext.getCurrentKey(), k -> new MockMapState());
        return mapState.entries();
    }

    public Iterable<K> keys() throws Exception {
        Objects.requireNonNull(this.keyContext.getCurrentKey(), "currentKey is null");
        MockMapState mapState = this.mockMapStateMap.computeIfAbsent(this.keyContext.getCurrentKey(), k -> new MockMapState());
        return mapState.keys();
    }

    public Iterable<V> values() throws Exception {
        Objects.requireNonNull(this.keyContext.getCurrentKey(), "currentKey is null");
        MockMapState mapState = this.mockMapStateMap.computeIfAbsent(this.keyContext.getCurrentKey(), k -> new MockMapState());
        return mapState.values();
    }

    public Iterator<Map.Entry<K, V>> iterator() throws Exception {
        Objects.requireNonNull(this.keyContext.getCurrentKey(), "currentKey is null");
        MockMapState mapState = this.mockMapStateMap.computeIfAbsent(this.keyContext.getCurrentKey(), k -> new MockMapState());
        return mapState.iterator();
    }

    public boolean isEmpty() throws Exception {
        Objects.requireNonNull(this.keyContext.getCurrentKey(), "currentKey is null");
        MockMapState mapState = this.mockMapStateMap.computeIfAbsent(this.keyContext.getCurrentKey(), k -> new MockMapState());
        return mapState.isEmpty();
    }

    public void clear() {
        Objects.requireNonNull(this.keyContext.getCurrentKey(), "currentKey is null");
        MockMapState mapState = this.mockMapStateMap.computeIfAbsent(this.keyContext.getCurrentKey(), k -> new MockMapState());
        mapState.clear();
    }

    public Object clone() {
        try {
            MockKeyedMapState copy = (MockKeyedMapState)super.clone();
            MockKeyContext newKeyContext = new MockKeyContext();
            newKeyContext.setCurrentKey(this.keyContext.getCurrentKey());
            copy.keyContext = newKeyContext;
            copy.mockMapStateMap = this.mockMapStateMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
                MockMapState oldMapState = (MockMapState)entry.getValue();
                MockMapState newMapState = new MockMapState();
                oldMapState.entries().forEach(v -> newMapState.put(v.getKey(), v.getValue()));
                return newMapState;
            }));
            return copy;
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }
}

