/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.utils;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.state.KeyedStateStore;
import org.apache.flink.metrics.groups.OperatorMetricGroup;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.testutils.MockEnvironment;
import org.apache.flink.runtime.operators.testutils.MockEnvironmentBuilder;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.StreamingRuntimeContext;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.streaming.runtime.tasks.TestProcessingTimeService;
import org.apache.hudi.sink.utils.MockKeyedStateStore;

public class MockStreamingRuntimeContext
extends StreamingRuntimeContext {
    private final boolean isCheckpointingEnabled;
    private final int numParallelSubtasks;
    private final int subtaskIndex;
    private int attemptNumber;

    public MockStreamingRuntimeContext(boolean isCheckpointingEnabled, int numParallelSubtasks, int subtaskIndex) {
        this(isCheckpointingEnabled, numParallelSubtasks, subtaskIndex, new MockEnvironmentBuilder().setTaskName("mockTask").setManagedMemorySize(131072L).build());
    }

    public MockStreamingRuntimeContext(boolean isCheckpointingEnabled, int numParallelSubtasks, int subtaskIndex, MockEnvironment environment) {
        super((AbstractStreamOperator)new MockStreamOperator(), (Environment)environment, new HashMap());
        this.isCheckpointingEnabled = isCheckpointingEnabled;
        this.numParallelSubtasks = numParallelSubtasks;
        this.subtaskIndex = subtaskIndex;
        this.attemptNumber = 0;
    }

    public boolean isCheckpointingEnabled() {
        return this.isCheckpointingEnabled;
    }

    public int getIndexOfThisSubtask() {
        return this.subtaskIndex;
    }

    public int getNumberOfParallelSubtasks() {
        return this.numParallelSubtasks;
    }

    public int getAttemptNumber() {
        return this.attemptNumber;
    }

    public void setAttemptNumber(int attemptNumber) {
        this.attemptNumber = attemptNumber;
    }

    public OperatorMetricGroup getMetricGroup() {
        return UnregisteredMetricsGroup.createOperatorMetricGroup();
    }

    private static class MockStreamOperator
    extends AbstractStreamOperator<Integer> {
        private static final long serialVersionUID = -1153976702711944427L;
        private transient TestProcessingTimeService testProcessingTimeService;
        private transient Object currentKey;
        private final transient Map<Object, MockKeyedStateStore> mockKeyedStateStoreMap = new HashMap<Object, MockKeyedStateStore>();

        private MockStreamOperator() {
        }

        public ExecutionConfig getExecutionConfig() {
            return new ExecutionConfig();
        }

        public OperatorID getOperatorID() {
            return new OperatorID();
        }

        public ProcessingTimeService getProcessingTimeService() {
            if (this.testProcessingTimeService == null) {
                this.testProcessingTimeService = new TestProcessingTimeService();
            }
            return this.testProcessingTimeService;
        }

        public void setCurrentKey(Object key) {
            this.currentKey = key;
        }

        public KeyedStateStore getKeyedStateStore() {
            return this.currentKey != null ? (KeyedStateStore)this.mockKeyedStateStoreMap.computeIfAbsent(this.currentKey, k -> new MockKeyedStateStore()) : null;
        }
    }
}

