/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.utils;

import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.state.FunctionSnapshotContext;
import org.apache.flink.streaming.api.operators.collect.utils.MockFunctionSnapshotContext;
import org.apache.flink.table.data.RowData;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.sink.StreamWriteFunction;
import org.apache.hudi.sink.bucket.ConsistentBucketAssignFunction;
import org.apache.hudi.sink.bucket.ConsistentBucketStreamWriteFunction;
import org.apache.hudi.sink.utils.BucketStreamWriteFunctionWrapper;
import org.apache.hudi.sink.utils.ScalaCollector;
import org.apache.hudi.utils.TestConfigurations;

public class ConsistentBucketStreamWriteFunctionWrapper<I>
extends BucketStreamWriteFunctionWrapper<I> {
    private ConsistentBucketAssignFunction assignFunction;

    public ConsistentBucketStreamWriteFunctionWrapper(String tablePath) throws Exception {
        this(tablePath, TestConfigurations.getDefaultConf(tablePath));
    }

    public ConsistentBucketStreamWriteFunctionWrapper(String tablePath, Configuration conf) throws Exception {
        super(tablePath, conf);
    }

    @Override
    public void openFunction() throws Exception {
        super.openFunction();
        this.assignFunction = new ConsistentBucketAssignFunction(this.conf);
        this.assignFunction.setRuntimeContext((RuntimeContext)this.runtimeContext);
        this.assignFunction.open(this.conf);
    }

    @Override
    public void invoke(I record) throws Exception {
        HoodieRecord hoodieRecord = this.toHoodieFunction.map((RowData)record);
        ScalaCollector collector = ScalaCollector.getInstance();
        this.assignFunction.processElement(hoodieRecord, null, collector);
        this.writeFunction.processElement(collector.getVal(), null, null);
    }

    @Override
    protected StreamWriteFunction<HoodieRecord<?>> createWriteFunction() {
        return new ConsistentBucketStreamWriteFunction(this.conf);
    }

    @Override
    public void checkpointFunction(long checkpointId) throws Exception {
        MockFunctionSnapshotContext functionSnapshotContext = new MockFunctionSnapshotContext(checkpointId);
        this.coordinator.checkpointCoordinator(checkpointId, new CompletableFuture());
        this.writeFunction.snapshotState((FunctionSnapshotContext)functionSnapshotContext);
        this.assignFunction.snapshotState((FunctionSnapshotContext)functionSnapshotContext);
        this.stateInitializationContext.checkpointBegin(checkpointId);
    }
}

