/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.meta;

import java.io.IOException;
import java.util.stream.IntStream;
import org.apache.flink.configuration.Configuration;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.sink.meta.CkpMetadata;
import org.apache.hudi.sink.meta.TestCkpMetadata;
import org.apache.hudi.util.FlinkWriteClients;
import org.apache.hudi.util.StreamerUtil;
import org.apache.hudi.utils.TestConfigurations;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class TestTimelineBasedCkpMetadata
extends TestCkpMetadata {
    @Override
    public void setup() throws IOException {
        String basePath = this.tempFile.getAbsolutePath();
        this.conf = TestConfigurations.getDefaultConf(basePath);
        this.conf.setString(HoodieWriteConfig.INSTANT_STATE_TIMELINE_SERVER_BASED.key(), "true");
        StreamerUtil.initTableIfNotExists((Configuration)this.conf);
        this.writeClient = FlinkWriteClients.createWriteClient((Configuration)this.conf);
    }

    @ParameterizedTest
    @ValueSource(strings={"", "1"})
    public void testFailOver(String uniqueId) {
        CkpMetadata metadata = this.getCkpMetadata(uniqueId);
        IntStream.range(0, 3).forEach(i -> metadata.startInstant(i + ""));
        MatcherAssert.assertThat((Object)metadata.lastPendingInstant(), (Matcher)CoreMatchers.is((Object)"2"));
        metadata.commitInstant("2");
        MatcherAssert.assertThat((Object)metadata.lastPendingInstant(), (Matcher)CoreMatchers.equalTo(null));
        this.cleanup();
        IntStream.range(3, 6).forEach(i -> metadata.startInstant(i + ""));
        MatcherAssert.assertThat((Object)metadata.getMessages().size(), (Matcher)CoreMatchers.is((Object)3));
        metadata.commitInstant("6");
        metadata.abortInstant("7");
        MatcherAssert.assertThat((Object)metadata.getMessages().size(), (Matcher)CoreMatchers.is((Object)5));
    }

    @ParameterizedTest
    @ValueSource(strings={"", "1"})
    public void testRefreshEveryNCommits(String uniqueId) {
        this.writeClient.getConfig().setValue(HoodieWriteConfig.INSTANT_STATE_TIMELINE_SERVER_BASED.key(), "false");
        CkpMetadata writeMetadata = this.getCkpMetadata(uniqueId);
        this.writeClient.getConfig().setValue(HoodieWriteConfig.INSTANT_STATE_TIMELINE_SERVER_BASED.key(), "true");
        CkpMetadata readOnlyMetadata = this.getCkpMetadata(uniqueId);
        IntStream.range(0, 3).forEach(i -> writeMetadata.startInstant(i + ""));
        MatcherAssert.assertThat((Object)readOnlyMetadata.lastPendingInstant(), (Matcher)CoreMatchers.is((Object)"2"));
        writeMetadata.commitInstant("2");
        this.readCkpMessagesNTimes(readOnlyMetadata, 10);
        MatcherAssert.assertThat((Object)readOnlyMetadata.lastPendingInstant(), (Matcher)CoreMatchers.equalTo((Object)"2"));
        this.readCkpMessagesNTimes(readOnlyMetadata, 100);
        MatcherAssert.assertThat((Object)readOnlyMetadata.lastPendingInstant(), (Matcher)CoreMatchers.equalTo(null));
        IntStream.range(3, 6).forEach(i -> writeMetadata.startInstant(i + ""));
        this.readCkpMessagesNTimes(readOnlyMetadata, 200);
        MatcherAssert.assertThat((Object)readOnlyMetadata.getMessages().size(), (Matcher)CoreMatchers.is((Object)3));
        writeMetadata.commitInstant("6");
        writeMetadata.abortInstant("7");
        this.readCkpMessagesNTimes(readOnlyMetadata, 200);
        MatcherAssert.assertThat((Object)readOnlyMetadata.getMessages().size(), (Matcher)CoreMatchers.is((Object)5));
    }

    private void readCkpMessagesNTimes(CkpMetadata metadata, int maxRetry) {
        for (int retry = 0; retry < maxRetry; ++retry) {
            metadata.getMessages();
        }
    }
}

