/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.compact;

import java.io.IOException;
import java.io.Serializable;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.hudi.common.model.EventTimeAvroPayload;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.util.collection.BitCaskDiskMap;
import org.apache.hudi.common.util.collection.RocksDbDiskMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class TestCustomSerDe
extends HoodieCommonTestHarness {
    @BeforeEach
    public void setup() {
        this.initPath();
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testBitCaskDiskMapPutDecimal(boolean isCompressionEnabled) throws IOException {
        BitCaskDiskMap bitCaskDiskMap = new BitCaskDiskMap(this.basePath, isCompressionEnabled);
        HoodieRecord avroRecord = TestCustomSerDe.createAvroRecordWithDecimalOrderingField();
        bitCaskDiskMap.put((Serializable)((Object)avroRecord.getRecordKey()), (Serializable)avroRecord);
        Assertions.assertDoesNotThrow(() -> (HoodieRecord)bitCaskDiskMap.get((Object)avroRecord.getRecordKey()));
    }

    @Test
    public void testRocksDbDiskMapPutDecimal() throws IOException {
        RocksDbDiskMap rocksDbBasedMap = new RocksDbDiskMap(this.basePath);
        HoodieRecord avroRecord = TestCustomSerDe.createAvroRecordWithDecimalOrderingField();
        rocksDbBasedMap.put((Serializable)((Object)avroRecord.getRecordKey()), (Serializable)avroRecord);
        Assertions.assertDoesNotThrow(() -> (HoodieRecord)rocksDbBasedMap.get((Object)avroRecord.getRecordKey()));
    }

    private static HoodieRecord createAvroRecordWithDecimalOrderingField() {
        Schema precombineFieldSchema = LogicalTypes.decimal((int)20, (int)0).addToSchema(Schema.createFixed((String)"fixed", null, (String)"record.precombineField", (int)9));
        byte[] decimalFieldBytes = new byte[]{0, 0, 0, 1, -122, -16, -116, -90, -32};
        GenericData.Fixed genericFixed = new GenericData.Fixed(precombineFieldSchema, decimalFieldBytes);
        return new HoodieAvroRecord(new HoodieKey("recordKey", "partitionPath"), (HoodieRecordPayload)new EventTimeAvroPayload(null, (Comparable)genericFixed));
    }
}

