/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.compact;

import java.util.List;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.hudi.client.common.HoodieFlinkEngineContext;
import org.apache.hudi.client.timeline.versioning.v2.TimelineArchiverV2;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.config.HoodieArchivalConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.sink.compact.CompactionCommitEvent;
import org.apache.hudi.sink.compact.CompactionCommitSink;
import org.apache.hudi.table.HoodieTable;

public class CompactionCommitTestSink
extends CompactionCommitSink {
    public CompactionCommitTestSink(Configuration conf) {
        super(conf);
    }

    public void invoke(CompactionCommitEvent event, SinkFunction.Context context) throws Exception {
        super.invoke(event, context);
        List instants = this.writeClient.getHoodieTable().getMetaClient().getActiveTimeline().getInstants();
        boolean compactCommitted = instants.stream().anyMatch(i -> i.requestedTime().equals(event.getInstant()) && i.isCompleted());
        if (compactCommitted && this.getRuntimeContext().getAttemptNumber() == 0) {
            this.writeClient.getConfig().setValue(HoodieArchivalConfig.MAX_COMMITS_TO_KEEP, "1");
            this.writeClient.getConfig().setValue(HoodieArchivalConfig.MIN_COMMITS_TO_KEEP, "1");
            TimelineArchiverV2 archiver = new TimelineArchiverV2(this.writeClient.getConfig(), (HoodieTable)this.writeClient.getHoodieTable());
            this.writeClient.getHoodieTable().getMetaClient().reloadActiveTimeline();
            archiver.archiveIfRequired((HoodieEngineContext)HoodieFlinkEngineContext.DEFAULT);
            throw new HoodieException("Fail first attempt to simulate failover in test.");
        }
    }
}

