/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.hudi.common.model.EventTimeAvroPayload;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.sink.TestWriteCopyOnWrite;
import org.apache.hudi.sink.utils.TestWriteBase;
import org.apache.hudi.utils.TestData;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class TestWriteMergeOnRead
extends TestWriteCopyOnWrite {
    @Override
    protected void setUp(Configuration conf) {
        conf.setBoolean(FlinkOptions.COMPACTION_ASYNC_ENABLED, false);
    }

    @Test
    public void testIndexStateBootstrapWithMultiFilesInOneSlice() throws Exception {
        this.preparePipeline(this.conf).consume(TestData.filterOddRows(TestData.DATA_SET_INSERT)).assertEmptyDataFiles().checkpoint(1L).assertNextEvent().checkpointComplete(1L).consume(TestData.filterEvenRows(TestData.DATA_SET_INSERT)).checkpoint(2L).assertNextEvent().checkpointComplete(2L).checkWrittenData(EXPECTED1, 4).consume(TestData.filterEvenRows(TestData.DATA_SET_INSERT)).checkpoint(3L).assertNextEvent().end();
        this.conf.setBoolean(FlinkOptions.INDEX_BOOTSTRAP_ENABLED, true);
        this.validateIndexLoaded();
    }

    @Test
    public void testIndexStateBootstrapWithCompactionScheduled() throws Exception {
        this.conf.setInteger(FlinkOptions.COMPACTION_DELTA_COMMITS, 1);
        this.preparePipeline(this.conf).consume(TestData.DATA_SET_INSERT).assertEmptyDataFiles().checkpoint(1L).assertNextEvent().checkpointComplete(1L).checkWrittenData(EXPECTED1, 4).end();
        this.conf.removeConfig(FlinkOptions.COMPACTION_DELTA_COMMITS);
        this.conf.setBoolean(FlinkOptions.INDEX_BOOTSTRAP_ENABLED, true);
        this.validateIndexLoaded();
    }

    @Test
    public void testEventTimeAvroPayloadMergeRead() throws Exception {
        this.conf.set(FlinkOptions.COMPACTION_ASYNC_ENABLED, (Object)true);
        this.conf.set(FlinkOptions.PATH, (Object)this.tempFile.getAbsolutePath());
        this.conf.set(FlinkOptions.TABLE_TYPE, (Object)HoodieTableType.MERGE_ON_READ.name());
        this.conf.set(FlinkOptions.OPERATION, (Object)"upsert");
        this.conf.set(FlinkOptions.CHANGELOG_ENABLED, (Object)false);
        this.conf.set(FlinkOptions.COMPACTION_DELTA_COMMITS, (Object)2);
        this.conf.set(FlinkOptions.PRE_COMBINE, (Object)true);
        this.conf.set(FlinkOptions.PRECOMBINE_FIELD, (Object)"ts");
        this.conf.set(FlinkOptions.PAYLOAD_CLASS_NAME, (Object)EventTimeAvroPayload.class.getName());
        HashMap<String, String> mergedExpected = new HashMap<String, String>(EXPECTED1);
        mergedExpected.put("par1", "[id1,par1,id1,Danny,22,4,par1, id2,par1,id2,Stephen,33,2,par1]");
        TestWriteBase.TestHarness.instance().preparePipeline(this.tempFile, this.conf).consume(TestData.DATA_SET_INSERT).emptyEventBuffer().checkpoint(1L).assertNextEvent().checkpointComplete(1L).checkWrittenData(EXPECTED1, 4).consume(TestData.DATA_SET_DISORDER_INSERT).emptyEventBuffer().checkpoint(2L).assertNextEvent().checkpointComplete(2L).checkWrittenData(mergedExpected, 4).consume(TestData.DATA_SET_SINGLE_INSERT).emptyEventBuffer().checkpoint(3L).assertNextEvent().checkpointComplete(3L).checkWrittenData(mergedExpected, 4).end();
    }

    @ParameterizedTest
    @ValueSource(ints={1, 2})
    public void testOnlyBaseFileOrOnlyLogFileRead(int compactionDeltaCommits) throws Exception {
        this.conf.set(FlinkOptions.COMPACTION_ASYNC_ENABLED, (Object)true);
        this.conf.set(FlinkOptions.PATH, (Object)this.tempFile.getAbsolutePath());
        this.conf.set(FlinkOptions.TABLE_TYPE, (Object)HoodieTableType.MERGE_ON_READ.name());
        this.conf.set(FlinkOptions.OPERATION, (Object)"upsert");
        this.conf.set(FlinkOptions.CHANGELOG_ENABLED, (Object)false);
        this.conf.set(FlinkOptions.COMPACTION_DELTA_COMMITS, (Object)compactionDeltaCommits);
        TestWriteBase.TestHarness.instance().preparePipeline(this.tempFile, this.conf).consume(TestData.DATA_SET_INSERT).emptyEventBuffer().checkpoint(1L).assertNextEvent().checkpointComplete(1L).checkWrittenData(EXPECTED1, 4).end();
    }

    @Override
    @Test
    public void testPartialFailover() {
    }

    @Override
    @Test
    public void testInsertAppendMode() {
    }

    @Override
    public void testInsertClustering() {
    }

    @Override
    @Test
    public void testInsertAsyncClustering() {
    }

    @Test
    public void testConsistentBucketIndex() throws Exception {
        this.conf.setString(FlinkOptions.INDEX_TYPE, "BUCKET");
        this.conf.setString(FlinkOptions.BUCKET_INDEX_ENGINE_TYPE, "CONSISTENT_HASHING");
        this.conf.setInteger(FlinkOptions.BUCKET_INDEX_NUM_BUCKETS, 4);
        this.conf.setString(HoodieIndexConfig.BUCKET_INDEX_MAX_NUM_BUCKETS.key(), "8");
        this.conf.setBoolean(FlinkOptions.CLUSTERING_SCHEDULE_ENABLED, true);
        this.conf.setString(HoodieClusteringConfig.ASYNC_CLUSTERING_MAX_COMMITS.key(), "1");
        this.conf.set(FlinkOptions.WRITE_PARQUET_MAX_FILE_SIZE, (Object)1);
        this.conf.setString(HoodieIndexConfig.BUCKET_SPLIT_THRESHOLD.key(), String.valueOf(9.5367431640625E-7));
        this.conf.set(FlinkOptions.PRE_COMBINE, (Object)true);
        HashMap<String, String> mergedExpected = new HashMap<String, String>(EXPECTED1);
        mergedExpected.put("par1", "[id1,par1,id1,Danny,22,4,par1, id2,par1,id2,Stephen,33,2,par1]");
        TestWriteBase.TestHarness.instance().preparePipeline(this.tempFile, this.conf).consume(TestData.DATA_SET_INSERT).emptyEventBuffer().checkpoint(1L).assertNextEvent().checkpointComplete(1L).checkWrittenData(EXPECTED1, 4).consume(TestData.DATA_SET_DISORDER_INSERT).emptyEventBuffer().checkpoint(2L).assertNextEvent().checkpointComplete(2L).checkWrittenData(mergedExpected, 4).consume(TestData.DATA_SET_SINGLE_INSERT).emptyEventBuffer().checkpoint(3L).assertNextEvent().checkpointComplete(3L).checkWrittenData(mergedExpected, 4).end();
    }

    @Override
    protected Map<String, String> getExpectedBeforeCheckpointComplete() {
        return EXPECTED1;
    }

    @Override
    protected Map<String, String> getMiniBatchExpected() {
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("par1", "[id1,par1,id1,Danny,23,1,par1]");
        return expected;
    }

    @Override
    protected HoodieTableType getTableType() {
        return HoodieTableType.MERGE_ON_READ;
    }
}

