/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.format;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.PrimitiveIterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.generic.IndexedRecord;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.data.RowData;
import org.apache.flink.types.RowKind;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.model.HoodieOperation;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.table.log.HoodieMergedLogRecordScanner;
import org.apache.hudi.common.table.log.HoodieUnMergedLogRecordScanner;
import org.apache.hudi.common.util.DefaultSizeEstimator;
import org.apache.hudi.common.util.Functions;
import org.apache.hudi.common.util.HoodieRecordUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.SizeEstimator;
import org.apache.hudi.common.util.collection.ExternalSpillableMap;
import org.apache.hudi.common.util.queue.BoundedInMemoryExecutor;
import org.apache.hudi.common.util.queue.FunctionBasedQueueProducer;
import org.apache.hudi.common.util.queue.HoodieMessageQueue;
import org.apache.hudi.common.util.queue.HoodieProducer;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.table.format.mor.MergeOnReadInputSplit;
import org.apache.hudi.util.FlinkWriteClients;
import org.apache.hudi.util.StreamerUtil;

public class FormatUtils {
    private FormatUtils() {
    }

    public static void setRowKind(RowData rowData, IndexedRecord record, int index) {
        if (index == -1) {
            return;
        }
        rowData.setRowKind(FormatUtils.getRowKind(record, index));
    }

    private static RowKind getRowKind(IndexedRecord record, int index) {
        Object val = record.get(index);
        if (val == null) {
            return RowKind.INSERT;
        }
        HoodieOperation operation = HoodieOperation.fromName((String)val.toString());
        if (HoodieOperation.isInsert((HoodieOperation)operation)) {
            return RowKind.INSERT;
        }
        if (HoodieOperation.isUpdateBefore((HoodieOperation)operation)) {
            return RowKind.UPDATE_BEFORE;
        }
        if (HoodieOperation.isUpdateAfter((HoodieOperation)operation)) {
            return RowKind.UPDATE_AFTER;
        }
        if (HoodieOperation.isDelete((HoodieOperation)operation)) {
            return RowKind.DELETE;
        }
        throw new AssertionError();
    }

    public static RowKind getRowKindSafely(IndexedRecord record, int index) {
        if (index == -1) {
            return RowKind.INSERT;
        }
        return FormatUtils.getRowKind(record, index);
    }

    public static GenericRecord buildAvroRecordBySchema(IndexedRecord record, Schema requiredSchema, int[] requiredPos, GenericRecordBuilder recordBuilder) {
        List requiredFields = requiredSchema.getFields();
        assert (requiredFields.size() == requiredPos.length);
        PrimitiveIterator.OfInt positionIterator = Arrays.stream(requiredPos).iterator();
        requiredFields.forEach(f -> recordBuilder.set(f, FormatUtils.getVal(record, (Integer)positionIterator.next())));
        return recordBuilder.build();
    }

    private static Object getVal(IndexedRecord record, int pos) {
        return pos == -1 ? null : record.get(pos);
    }

    public static ExternalSpillableMap<String, byte[]> spillableMap(HoodieWriteConfig writeConfig, long maxCompactionMemoryInBytes) {
        try {
            return new ExternalSpillableMap(Long.valueOf(maxCompactionMemoryInBytes), writeConfig.getSpillableMapBasePath(), (SizeEstimator)new DefaultSizeEstimator(), (SizeEstimator)new DefaultSizeEstimator(), writeConfig.getCommonConfig().getSpillableDiskMapType(), writeConfig.getCommonConfig().isBitCaskDiskMapCompressionEnabled());
        }
        catch (IOException e) {
            throw new HoodieIOException("IOException when creating ExternalSpillableMap at " + writeConfig.getSpillableMapBasePath(), e);
        }
    }

    public static HoodieMergedLogRecordScanner logScanner(MergeOnReadInputSplit split, Schema logSchema, InternalSchema internalSchema, Configuration flinkConf, org.apache.hadoop.conf.Configuration hadoopConf) {
        HoodieWriteConfig writeConfig = FlinkWriteClients.getHoodieClientConfig(flinkConf);
        HoodieStorage storage = HoodieStorageUtils.getStorage((String)split.getTablePath(), (StorageConfiguration)HadoopFSUtils.getStorageConf((org.apache.hadoop.conf.Configuration)hadoopConf));
        return HoodieMergedLogRecordScanner.newBuilder().withStorage(storage).withBasePath(split.getTablePath()).withLogFilePaths((List)split.getLogPaths().get()).withReaderSchema(logSchema).withInternalSchema(internalSchema).withLatestInstantTime(split.getLatestCommit()).withReverseReader(false).withBufferSize(writeConfig.getMaxDFSStreamBufferSize()).withMaxMemorySizeInBytes(Long.valueOf(split.getMaxCompactionMemoryInBytes())).withDiskMapType(writeConfig.getCommonConfig().getSpillableDiskMapType()).withBitCaskDiskMapCompressionEnabled(writeConfig.getCommonConfig().isBitCaskDiskMapCompressionEnabled()).withSpillableMapBasePath(writeConfig.getSpillableMapBasePath()).withInstantRange(split.getInstantRange()).withOperationField(flinkConf.getBoolean(FlinkOptions.CHANGELOG_ENABLED)).withRecordMerger(writeConfig.getRecordMerger()).build();
    }

    public static HoodieMergedLogRecordScanner logScanner(List<String> logPaths, Schema logSchema, String latestInstantTime, HoodieWriteConfig writeConfig, org.apache.hadoop.conf.Configuration hadoopConf) {
        String basePath = writeConfig.getBasePath();
        return HoodieMergedLogRecordScanner.newBuilder().withStorage(HoodieStorageUtils.getStorage((String)basePath, (StorageConfiguration)HadoopFSUtils.getStorageConf((org.apache.hadoop.conf.Configuration)hadoopConf))).withBasePath(basePath).withLogFilePaths(logPaths).withReaderSchema(logSchema).withLatestInstantTime(latestInstantTime).withReverseReader(false).withBufferSize(writeConfig.getMaxDFSStreamBufferSize()).withMaxMemorySizeInBytes(writeConfig.getMaxMemoryPerPartitionMerge()).withSpillableMapBasePath(writeConfig.getSpillableMapBasePath()).withDiskMapType(writeConfig.getCommonConfig().getSpillableDiskMapType()).withBitCaskDiskMapCompressionEnabled(writeConfig.getCommonConfig().isBitCaskDiskMapCompressionEnabled()).withRecordMerger(writeConfig.getRecordMerger()).build();
    }

    private static Boolean string2Boolean(String s) {
        return "true".equals(s.toLowerCase(Locale.ROOT));
    }

    public static class BoundedMemoryRecords {
        private final BoundedInMemoryExecutor<HoodieRecord<?>, HoodieRecord<?>, ?> executor;
        private final Iterator<HoodieRecord<?>> iterator;

        public BoundedMemoryRecords(MergeOnReadInputSplit split, Schema logSchema, InternalSchema internalSchema, org.apache.hadoop.conf.Configuration hadoopConf, Configuration flinkConf) {
            List mergers = Arrays.stream(flinkConf.getString(FlinkOptions.RECORD_MERGER_IMPLS).split(",")).map(String::trim).distinct().collect(Collectors.toList());
            HoodieRecordMerger merger = HoodieRecordUtils.createRecordMerger((String)split.getTablePath(), (EngineType)EngineType.FLINK, mergers, (String)flinkConf.getString(FlinkOptions.RECORD_MERGER_STRATEGY));
            HoodieUnMergedLogRecordScanner.Builder scannerBuilder = HoodieUnMergedLogRecordScanner.newBuilder().withStorage(HoodieStorageUtils.getStorage((String)split.getTablePath(), (StorageConfiguration)HadoopFSUtils.getStorageConf((org.apache.hadoop.conf.Configuration)hadoopConf))).withBasePath(split.getTablePath()).withLogFilePaths((List)split.getLogPaths().get()).withReaderSchema(logSchema).withInternalSchema(internalSchema).withLatestInstantTime(split.getLatestCommit()).withReverseReader(false).withBufferSize(flinkConf.getInteger("hoodie.memory.dfs.buffer.max.size", 0x100000)).withInstantRange(split.getInstantRange()).withRecordMerger(merger);
            this.executor = new BoundedInMemoryExecutor(StreamerUtil.getMaxCompactionMemoryInBytes(flinkConf), this.getParallelProducers(scannerBuilder), Option.empty(), Function.identity(), (SizeEstimator)new DefaultSizeEstimator(), Functions.noop());
            this.iterator = this.executor.getRecordIterator();
            this.executor.startProducingAsync();
        }

        public Iterator<HoodieRecord<?>> getRecordsIterator() {
            return this.iterator;
        }

        private List<HoodieProducer<HoodieRecord<?>>> getParallelProducers(HoodieUnMergedLogRecordScanner.Builder scannerBuilder) {
            ArrayList producers = new ArrayList();
            producers.add((HoodieProducer<HoodieRecord<?>>)new FunctionBasedQueueProducer(queue -> {
                HoodieUnMergedLogRecordScanner scanner = scannerBuilder.withLogRecordScannerCallback(arg_0 -> ((HoodieMessageQueue)queue).insertRecord(arg_0)).build();
                scanner.scan();
                return null;
            }));
            return producers;
        }

        public void close() {
            this.executor.shutdownNow();
        }
    }
}

