/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.source;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.client.common.HoodieFlinkEngineContext;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.configuration.HadoopConfigurations;
import org.apache.hudi.index.bucket.BucketIdentifier;
import org.apache.hudi.source.prune.DataPruner;
import org.apache.hudi.source.prune.PartitionPruners;
import org.apache.hudi.source.stats.ColumnStatsIndices;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePathInfo;
import org.apache.hudi.storage.hadoop.HoodieHadoopStorage;
import org.apache.hudi.util.DataTypeUtils;
import org.apache.hudi.util.StreamerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileIndex {
    private static final Logger LOG = LoggerFactory.getLogger(FileIndex.class);
    private final Path path;
    private final RowType rowType;
    private final boolean tableExists;
    private final HoodieMetadataConfig metadataConfig;
    private final org.apache.hadoop.conf.Configuration hadoopConf;
    private final PartitionPruners.PartitionPruner partitionPruner;
    private final DataPruner dataPruner;
    private final int dataBucket;
    private List<String> partitionPaths;

    private FileIndex(Path path, Configuration conf, RowType rowType, DataPruner dataPruner, PartitionPruners.PartitionPruner partitionPruner, int dataBucket) {
        this.path = path;
        this.rowType = rowType;
        this.hadoopConf = HadoopConfigurations.getHadoopConf(conf);
        this.tableExists = StreamerUtil.tableExists(path.toString(), this.hadoopConf);
        this.metadataConfig = FileIndex.metadataConfig(conf);
        this.dataPruner = this.isDataSkippingFeasible(conf.getBoolean(FlinkOptions.READ_DATA_SKIPPING_ENABLED)) ? dataPruner : null;
        this.partitionPruner = partitionPruner;
        this.dataBucket = dataBucket;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<Map<String, String>> getPartitions(List<String> partitionKeys, String defaultParName, boolean hivePartition) {
        if (partitionKeys.size() == 0) {
            return Collections.emptyList();
        }
        List<String> partitionPaths = this.getOrBuildPartitionPaths();
        if (partitionPaths.size() == 1 && partitionPaths.get(0).isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, String>> partitions = new ArrayList<Map<String, String>>();
        for (String partitionPath : partitionPaths) {
            String[] paths = partitionPath.split("/");
            LinkedHashMap<String, String> partitionMapping = new LinkedHashMap<String, String>();
            if (hivePartition) {
                Arrays.stream(paths).forEach(p -> {
                    String[] kv = p.split("=");
                    if (kv.length == 2) {
                        partitionMapping.put(kv[0], defaultParName.equals(kv[1]) ? null : kv[1]);
                    }
                });
            } else {
                for (int i = 0; i < partitionKeys.size(); ++i) {
                    partitionMapping.put(partitionKeys.get(i), defaultParName.equals(paths[i]) ? null : paths[i]);
                }
            }
            partitions.add(partitionMapping);
        }
        return partitions;
    }

    public List<StoragePathInfo> getFilesInPartitions() {
        Set<String> candidateFiles;
        if (!this.tableExists) {
            return Collections.emptyList();
        }
        String[] partitions = (String[])this.getOrBuildPartitionPaths().stream().map(p -> FileIndex.fullPartitionPath(this.path, p)).toArray(String[]::new);
        List<Object> allFiles = FSUtils.getFilesInPartitions((HoodieEngineContext)new HoodieFlinkEngineContext(this.hadoopConf), (HoodieStorage)new HoodieHadoopStorage(this.path, this.hadoopConf), (HoodieMetadataConfig)this.metadataConfig, (String)this.path.toString(), (String[])partitions).values().stream().flatMap(e -> e.stream()).collect(Collectors.toList());
        if (allFiles.size() == 0) {
            return allFiles;
        }
        if (this.dataBucket >= 0) {
            String bucketIdStr = BucketIdentifier.bucketIdStr((int)this.dataBucket);
            List filesAfterBucketPruning = allFiles.stream().filter(fileInfo -> fileInfo.getPath().getName().contains(bucketIdStr)).collect(Collectors.toList());
            this.logPruningMsg(allFiles.size(), filesAfterBucketPruning.size(), "bucket pruning");
            allFiles = filesAfterBucketPruning;
        }
        if ((candidateFiles = this.candidateFilesInMetadataTable(allFiles)) == null) {
            return allFiles;
        }
        List<StoragePathInfo> results = ((Stream)allFiles.stream().parallel()).filter(fileStatus -> candidateFiles.contains(fileStatus.getPath().getName())).collect(Collectors.toList());
        this.logPruningMsg(allFiles.size(), results.size(), "data skipping");
        return results;
    }

    private static String fullPartitionPath(Path basePath, String partitionPath) {
        if (partitionPath.isEmpty()) {
            return basePath.toString();
        }
        return new Path(basePath, partitionPath).toString();
    }

    @VisibleForTesting
    public void reset() {
        this.partitionPaths = null;
    }

    @Nullable
    private Set<String> candidateFilesInMetadataTable(List<StoragePathInfo> allFileStatus) {
        if (this.dataPruner == null) {
            return null;
        }
        try {
            String[] referencedCols = this.dataPruner.getReferencedCols();
            List<RowData> colStats = ColumnStatsIndices.readColumnStatsIndex(this.path.toString(), this.metadataConfig, referencedCols);
            Pair<List<RowData>, String[]> colStatsTable = ColumnStatsIndices.transposeColumnStatsIndex(colStats, referencedCols, this.rowType);
            List transposedColStats = (List)colStatsTable.getLeft();
            String[] queryCols = (String[])colStatsTable.getRight();
            if (queryCols.length == 0) {
                return null;
            }
            RowType.RowField[] queryFields = DataTypeUtils.projectRowFields(this.rowType, queryCols);
            Set allIndexedFileNames = ((Stream)transposedColStats.stream().parallel()).map(row -> row.getString(0).toString()).collect(Collectors.toSet());
            Set<String> candidateFileNames = ((Stream)transposedColStats.stream().parallel()).filter(row -> this.dataPruner.test((RowData)row, queryFields)).map(row -> row.getString(0).toString()).collect(Collectors.toSet());
            Set nonIndexedFileNames = allFileStatus.stream().map(fileStatus -> fileStatus.getPath().getName()).collect(Collectors.toSet());
            nonIndexedFileNames.removeAll(allIndexedFileNames);
            candidateFileNames.addAll(nonIndexedFileNames);
            return candidateFileNames;
        }
        catch (Throwable throwable) {
            LOG.warn("Read column stats for data skipping error", throwable);
            return null;
        }
    }

    public List<String> getOrBuildPartitionPaths() {
        List allPartitionPaths;
        if (this.partitionPaths != null) {
            return this.partitionPaths;
        }
        List list = allPartitionPaths = this.tableExists ? FSUtils.getAllPartitionPaths((HoodieEngineContext)new HoodieFlinkEngineContext(this.hadoopConf), (HoodieStorage)new HoodieHadoopStorage(this.path, this.hadoopConf), (HoodieMetadataConfig)this.metadataConfig, (String)this.path.toString()) : Collections.emptyList();
        if (this.partitionPruner == null) {
            this.partitionPaths = allPartitionPaths;
        } else {
            Set<String> prunedPartitionPaths = this.partitionPruner.filter(allPartitionPaths);
            this.partitionPaths = new ArrayList<String>(prunedPartitionPaths);
        }
        return this.partitionPaths;
    }

    public static HoodieMetadataConfig metadataConfig(Configuration conf) {
        Properties properties = new Properties();
        properties.put(HoodieMetadataConfig.ENABLE.key(), (Object)conf.getBoolean(FlinkOptions.METADATA_ENABLED));
        return HoodieMetadataConfig.newBuilder().fromProperties(properties).build();
    }

    private boolean isDataSkippingFeasible(boolean dataSkippingEnabled) {
        if (dataSkippingEnabled) {
            if (this.metadataConfig.isEnabled()) {
                return true;
            }
            LOG.warn("Data skipping requires Metadata Table to be enabled! Disable the data skipping");
        }
        return false;
    }

    private void logPruningMsg(int numTotalFiles, int numLeftFiles, String action) {
        LOG.info("\n------------------------------------------------------------\n---------- action:        {}\n---------- total files:   {}\n---------- left files:    {}\n---------- skipping rate: {}\n------------------------------------------------------------", new Object[]{action, numTotalFiles, numLeftFiles, FileIndex.percentage(numTotalFiles, numLeftFiles)});
    }

    private static double percentage(double total, double left) {
        return (total - left) / total;
    }

    public static class Builder {
        private Path path;
        private Configuration conf;
        private RowType rowType;
        private DataPruner dataPruner;
        private PartitionPruners.PartitionPruner partitionPruner;
        private int dataBucket = -1;

        private Builder() {
        }

        public Builder path(Path path) {
            this.path = path;
            return this;
        }

        public Builder conf(Configuration conf) {
            this.conf = conf;
            return this;
        }

        public Builder rowType(RowType rowType) {
            this.rowType = rowType;
            return this;
        }

        public Builder dataPruner(DataPruner dataPruner) {
            this.dataPruner = dataPruner;
            return this;
        }

        public Builder partitionPruner(PartitionPruners.PartitionPruner partitionPruner) {
            this.partitionPruner = partitionPruner;
            return this;
        }

        public Builder dataBucket(int dataBucket) {
            this.dataBucket = dataBucket;
            return this;
        }

        public FileIndex build() {
            return new FileIndex(Objects.requireNonNull(this.path), Objects.requireNonNull(this.conf), Objects.requireNonNull(this.rowType), this.dataPruner, this.partitionPruner, this.dataBucket);
        }
    }
}

