/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.bulk;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.keygen.TimestampBasedAvroKeyGenerator;
import org.apache.hudi.sink.bulk.RowDataKeyGen;

public class AutoRowDataKeyGen
extends RowDataKeyGen {
    private final int taskId;
    private final String instantTime;
    private int rowId;

    public AutoRowDataKeyGen(int taskId, String instantTime, String partitionFields, RowType rowType, boolean hiveStylePartitioning, boolean encodePartitionPath) {
        super((Option<String>)Option.empty(), partitionFields, rowType, hiveStylePartitioning, encodePartitionPath, false, (Option<TimestampBasedAvroKeyGenerator>)Option.empty());
        this.taskId = taskId;
        this.instantTime = instantTime;
    }

    public static RowDataKeyGen instance(Configuration conf, RowType rowType, int taskId, String instantTime) {
        return new AutoRowDataKeyGen(taskId, instantTime, conf.getString(FlinkOptions.PARTITION_PATH_FIELD), rowType, conf.getBoolean(FlinkOptions.HIVE_STYLE_PARTITIONING), conf.getBoolean(FlinkOptions.URL_ENCODE_PARTITIONING));
    }

    @Override
    public String getRecordKey(RowData rowData) {
        return HoodieRecord.generateSequenceId((String)this.instantTime, (int)this.taskId, (long)this.rowId++);
    }
}

