/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics;

import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import org.apache.flink.metrics.MetricGroup;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieInstantTimeGenerator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.metrics.FlinkWriteMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkClusteringMetrics
extends FlinkWriteMetrics {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkClusteringMetrics.class);
    private static final String CLUSTERING_KEY = "clustering";
    private long pendingClusteringCount;
    private long clusteringDelay;
    private long clusteringCost;

    public FlinkClusteringMetrics(MetricGroup metricGroup) {
        super(metricGroup, CLUSTERING_KEY);
    }

    @Override
    public void registerMetrics() {
        super.registerMetrics();
        this.metricGroup.gauge(this.getMetricsName(this.actionType, "pendingClusteringCount"), () -> this.pendingClusteringCount);
        this.metricGroup.gauge(this.getMetricsName(this.actionType, "clusteringDelay"), () -> this.clusteringDelay);
        this.metricGroup.gauge(this.getMetricsName(this.actionType, "clusteringCost"), () -> this.clusteringCost);
    }

    public void setPendingClusteringCount(long pendingClusteringCount) {
        this.pendingClusteringCount = pendingClusteringCount;
    }

    public void setFirstPendingClusteringInstant(Option<HoodieInstant> firstPendingClusteringInstant) {
        try {
            if (!firstPendingClusteringInstant.isPresent()) {
                this.clusteringDelay = 0L;
            } else {
                Instant start = HoodieInstantTimeGenerator.parseDateFromInstantTime((String)((HoodieInstant)firstPendingClusteringInstant.get()).getTimestamp()).toInstant();
                this.clusteringDelay = Duration.between(start, Instant.now()).getSeconds();
            }
        }
        catch (ParseException e) {
            LOG.warn("Invalid input clustering instant" + firstPendingClusteringInstant);
        }
    }

    public void startClustering() {
        this.startTimer(CLUSTERING_KEY);
    }

    public void endClustering() {
        this.clusteringCost = this.stopTimer(CLUSTERING_KEY);
    }
}

