/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.util;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.hudi.common.util.ValidationUtils;

@Internal
public class StringToRowDataConverter {
    private final Converter[] converters;

    public StringToRowDataConverter(LogicalType[] fieldTypes) {
        this.converters = (Converter[])Arrays.stream(fieldTypes).map(StringToRowDataConverter::getConverter).toArray(Converter[]::new);
    }

    public Object[] convert(String[] fields) {
        ValidationUtils.checkArgument((this.converters.length == fields.length ? 1 : 0) != 0, (String)"Field types and values should equal with number");
        Object[] converted = new Object[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            converted[i] = this.converters[i].convert(fields[i]);
        }
        return converted;
    }

    private static Converter getConverter(LogicalType logicalType) {
        switch (logicalType.getTypeRoot()) {
            case NULL: {
                return field -> null;
            }
            case TINYINT: {
                return Byte::parseByte;
            }
            case SMALLINT: {
                return Short::parseShort;
            }
            case BOOLEAN: {
                return Boolean::parseBoolean;
            }
            case INTEGER: 
            case TIME_WITHOUT_TIME_ZONE: {
                return Integer::parseInt;
            }
            case BIGINT: {
                return Long::parseLong;
            }
            case FLOAT: {
                return Float::parseFloat;
            }
            case DOUBLE: {
                return Double::parseDouble;
            }
            case DATE: {
                return field -> (int)LocalDate.parse(field).toEpochDay();
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                int precision = ((TimestampType)logicalType).getPrecision();
                if (precision <= 3) {
                    return field -> TimestampData.fromInstant((Instant)Instant.EPOCH.plus(Long.parseLong(field), ChronoUnit.MILLIS));
                }
                if (precision <= 6) {
                    return field -> TimestampData.fromInstant((Instant)Instant.EPOCH.plus(Long.parseLong(field), ChronoUnit.MICROS));
                }
                throw new UnsupportedOperationException("Unsupported type: " + logicalType);
            }
            case CHAR: 
            case VARCHAR: {
                return StringData::fromString;
            }
            case BINARY: 
            case VARBINARY: {
                return field -> field.getBytes(StandardCharsets.UTF_8);
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)logicalType;
                return field -> DecimalData.fromBigDecimal((BigDecimal)new BigDecimal(field), (int)decimalType.getPrecision(), (int)decimalType.getScale());
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + logicalType);
    }

    private static interface Converter {
        public Object convert(String var1);
    }
}

