/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.source.prune;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.table.types.DataType;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.source.ExpressionEvaluators;
import org.apache.hudi.source.stats.ColumnStats;
import org.apache.hudi.table.format.FilePathUtils;
import org.apache.hudi.util.DataTypeUtils;

public class PartitionPruners {
    public static PartitionPruner getInstance(List<ExpressionEvaluators.Evaluator> partitionEvaluators, List<String> partitionKeys, List<DataType> partitionTypes, String defaultParName, boolean hivePartition) {
        ValidationUtils.checkState((!partitionEvaluators.isEmpty() ? 1 : 0) != 0);
        return new DynamicPartitionPruner(partitionEvaluators, partitionKeys, partitionTypes, defaultParName, hivePartition);
    }

    public static PartitionPruner getInstance(Collection<String> candidatePartitions) {
        return new StaticPartitionPruner(candidatePartitions);
    }

    public static PartitionPruner getInstance(String ... candidatePartitions) {
        return new StaticPartitionPruner(Arrays.asList(candidatePartitions));
    }

    public static class StaticPartitionPruner
    implements PartitionPruner {
        private static final long serialVersionUID = 1L;
        private final Set<String> partitions;

        private StaticPartitionPruner(Collection<String> partitions) {
            this.partitions = new HashSet<String>(partitions);
        }

        @Override
        public Set<String> filter(Collection<String> partitions) {
            return partitions.stream().filter(this.partitions::contains).collect(Collectors.toSet());
        }
    }

    public static class DynamicPartitionPruner
    implements PartitionPruner {
        private static final long serialVersionUID = 1L;
        private final List<ExpressionEvaluators.Evaluator> partitionEvaluator;
        private final String[] partitionKeys;
        private final List<DataType> partitionTypes;
        private final String defaultParName;
        private final boolean hivePartition;

        private DynamicPartitionPruner(List<ExpressionEvaluators.Evaluator> partitionEvaluators, List<String> partitionKeys, List<DataType> partitionTypes, String defaultParName, boolean hivePartition) {
            this.partitionEvaluator = partitionEvaluators;
            this.partitionKeys = partitionKeys.toArray(new String[0]);
            this.partitionTypes = partitionTypes;
            this.defaultParName = defaultParName;
            this.hivePartition = hivePartition;
        }

        @Override
        public Set<String> filter(Collection<String> partitions) {
            return partitions.stream().filter(this::evaluate).collect(Collectors.toSet());
        }

        private boolean evaluate(String partition) {
            String[] partStrArray = FilePathUtils.extractPartitionKeyValues(new Path(partition), this.hivePartition, this.partitionKeys).values().toArray(new String[0]);
            LinkedHashMap<String, ColumnStats> partStats = new LinkedHashMap<String, ColumnStats>();
            for (int idx = 0; idx < this.partitionKeys.length; ++idx) {
                String partKey = this.partitionKeys[idx];
                Object partVal = partKey.equals(this.defaultParName) ? null : DataTypeUtils.resolvePartition(partStrArray[idx], this.partitionTypes.get(idx));
                ColumnStats columnStats = new ColumnStats(partVal, partVal, partVal == null ? 1L : 0L);
                partStats.put(partKey, columnStats);
            }
            return this.partitionEvaluator.stream().allMatch(evaluator -> evaluator.eval(partStats));
        }
    }

    public static interface PartitionPruner
    extends Serializable {
        public Set<String> filter(Collection<String> var1);
    }
}

