/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.partitioner.profile;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.core.fs.Path;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.client.common.HoodieFlinkEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.sink.partitioner.profile.DeltaWriteProfile;
import org.apache.hudi.sink.partitioner.profile.EmptyWriteProfile;
import org.apache.hudi.sink.partitioner.profile.WriteProfile;
import org.apache.hudi.util.StreamerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteProfiles {
    private static final Logger LOG = LoggerFactory.getLogger(WriteProfiles.class);
    private static final Map<String, WriteProfile> PROFILES = new HashMap<String, WriteProfile>();

    private WriteProfiles() {
    }

    public static synchronized WriteProfile singleton(boolean ignoreSmallFiles, boolean delta, HoodieWriteConfig config, HoodieFlinkEngineContext context) {
        return PROFILES.computeIfAbsent(config.getBasePath(), k -> WriteProfiles.getWriteProfile(ignoreSmallFiles, delta, config, context));
    }

    private static WriteProfile getWriteProfile(boolean ignoreSmallFiles, boolean delta, HoodieWriteConfig config, HoodieFlinkEngineContext context) {
        if (ignoreSmallFiles) {
            return new EmptyWriteProfile(config, context);
        }
        if (delta) {
            return new DeltaWriteProfile(config, context);
        }
        return new WriteProfile(config, context);
    }

    public static void clean(String path) {
        PROFILES.remove(path);
    }

    public static FileStatus[] getFilesFromMetadata(Path basePath, Configuration hadoopConf, List<HoodieCommitMetadata> metadataList, HoodieTableType tableType) {
        return WriteProfiles.getFilesFromMetadata(basePath, hadoopConf, metadataList, tableType, true);
    }

    @Nullable
    public static FileStatus[] getFilesFromMetadata(Path basePath, Configuration hadoopConf, List<HoodieCommitMetadata> metadataList, HoodieTableType tableType, boolean ignoreMissingFiles) {
        FileSystem fs = FSUtils.getFs((String)basePath.toString(), (Configuration)hadoopConf);
        HashMap<String, FileStatus> uniqueIdToFileStatus = new HashMap<String, FileStatus>();
        for (int i = metadataList.size() - 1; i >= 0; --i) {
            for (Map.Entry<String, FileStatus> entry : WriteProfiles.getFilesToRead(hadoopConf, metadataList.get(i), basePath.toString(), tableType).entrySet()) {
                if (!StreamerUtil.isValidFile(entry.getValue()) || uniqueIdToFileStatus.containsKey(entry.getKey())) continue;
                if (StreamerUtil.fileExists(fs, entry.getValue().getPath())) {
                    uniqueIdToFileStatus.put(entry.getKey(), entry.getValue());
                    continue;
                }
                if (ignoreMissingFiles) continue;
                return null;
            }
        }
        return uniqueIdToFileStatus.values().toArray(new FileStatus[0]);
    }

    private static Map<String, FileStatus> getFilesToRead(Configuration hadoopConf, HoodieCommitMetadata metadata, String basePath, HoodieTableType tableType) {
        switch (tableType) {
            case COPY_ON_WRITE: {
                return metadata.getFileIdToFileStatus(hadoopConf, basePath);
            }
            case MERGE_ON_READ: {
                return metadata.getFullPathToFileStatus(hadoopConf, basePath);
            }
        }
        throw new AssertionError();
    }

    public static Option<HoodieCommitMetadata> getCommitMetadataSafely(String tableName, Path basePath, HoodieInstant instant, HoodieTimeline timeline) {
        try {
            byte[] data = (byte[])timeline.getInstantDetails(instant).get();
            return Option.of((Object)HoodieCommitMetadata.fromBytes((byte[])data, HoodieCommitMetadata.class));
        }
        catch (FileNotFoundException fe) {
            LOG.warn("Instant {} was deleted by the cleaner, ignore", (Object)instant.getTimestamp());
            return Option.empty();
        }
        catch (Throwable throwable) {
            LOG.error("Get write metadata for table {} with instant {} and path: {} error", new Object[]{tableName, instant.getTimestamp(), basePath});
            return Option.empty();
        }
    }

    public static HoodieCommitMetadata getCommitMetadata(String tableName, Path basePath, HoodieInstant instant, HoodieTimeline timeline) {
        try {
            return TimelineUtils.getCommitMetadata((HoodieInstant)instant, (HoodieTimeline)timeline);
        }
        catch (IOException e) {
            LOG.error("Get write metadata for table {} with instant {} and path: {} error", new Object[]{tableName, instant.getTimestamp(), basePath});
            throw new HoodieException((Throwable)e);
        }
    }
}

