/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utils;

import java.io.File;
import java.io.IOException;
import org.apache.flink.configuration.Configuration;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.table.view.FileSystemViewStorageType;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.util.FlinkWriteClients;
import org.apache.hudi.util.ViewStorageProperties;
import org.apache.hudi.utils.TestConfigurations;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestViewStorageProperties {
    @TempDir
    File tempFile;

    @Test
    void testReadWriteProperties() throws IOException {
        String basePath = this.tempFile.getAbsolutePath();
        FileSystemViewStorageConfig config = FileSystemViewStorageConfig.newBuilder().withStorageType(FileSystemViewStorageType.SPILLABLE_DISK).withRemoteServerHost("host1").withRemoteServerPort(Integer.valueOf(1234)).build();
        Configuration flinkConfig = new Configuration();
        ViewStorageProperties.createProperties((String)basePath, (FileSystemViewStorageConfig)config, (Configuration)flinkConfig);
        ViewStorageProperties.createProperties((String)basePath, (FileSystemViewStorageConfig)config, (Configuration)flinkConfig);
        ViewStorageProperties.createProperties((String)basePath, (FileSystemViewStorageConfig)config, (Configuration)flinkConfig);
        FileSystemViewStorageConfig readConfig = ViewStorageProperties.loadFromProperties((String)basePath, (Configuration)new Configuration());
        MatcherAssert.assertThat((Object)readConfig.getStorageType(), (Matcher)CoreMatchers.is((Object)FileSystemViewStorageType.SPILLABLE_DISK));
        MatcherAssert.assertThat((Object)readConfig.getRemoteViewServerHost(), (Matcher)CoreMatchers.is((Object)"host1"));
        MatcherAssert.assertThat((Object)readConfig.getRemoteViewServerPort(), (Matcher)CoreMatchers.is((Object)1234));
    }

    @Test
    void testDumpRemoteViewStorageConfig() throws IOException {
        Configuration conf = TestConfigurations.getDefaultConf(this.tempFile.getAbsolutePath());
        FlinkWriteClients.createWriteClient((Configuration)conf);
        FileSystemViewStorageConfig storageConfig = ViewStorageProperties.loadFromProperties((String)conf.getString(FlinkOptions.PATH), (Configuration)new Configuration());
        MatcherAssert.assertThat((Object)storageConfig.getStorageType(), (Matcher)CoreMatchers.is((Object)FileSystemViewStorageType.REMOTE_FIRST));
    }
}

