/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utils;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.configuration.HadoopConfigurations;
import org.apache.hudi.source.StreamReadMonitoringFunction;
import org.apache.hudi.table.format.mor.MergeOnReadInputSplit;
import org.apache.hudi.util.StreamerUtil;
import org.apache.hudi.utils.TestConfigurations;
import org.junit.jupiter.api.Assertions;

public class TestUtils {
    public static String getLastPendingInstant(String basePath) {
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(HadoopConfigurations.getHadoopConf((Configuration)new Configuration())).setBasePath(basePath).build();
        return StreamerUtil.getLastPendingInstant((HoodieTableMetaClient)metaClient);
    }

    public static String getLastCompleteInstant(String basePath) {
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(HadoopConfigurations.getHadoopConf((Configuration)new Configuration())).setBasePath(basePath).build();
        return StreamerUtil.getLastCompletedInstant((HoodieTableMetaClient)metaClient);
    }

    public static String getLastCompleteInstant(String basePath, String commitAction) {
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(HadoopConfigurations.getHadoopConf((Configuration)new Configuration())).setBasePath(basePath).build();
        return (String)metaClient.getCommitsTimeline().filterCompletedInstants().filter(instant -> commitAction.equals(instant.getAction())).lastInstant().map(HoodieInstant::getTimestamp).orElse(null);
    }

    public static String getLastDeltaCompleteInstant(String basePath) {
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(HadoopConfigurations.getHadoopConf((Configuration)new Configuration())).setBasePath(basePath).build();
        return (String)metaClient.getCommitsTimeline().filterCompletedInstants().filter(hoodieInstant -> hoodieInstant.getAction().equals("deltacommit")).lastInstant().map(HoodieInstant::getTimestamp).orElse(null);
    }

    public static String getFirstCompleteInstant(String basePath) {
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(HadoopConfigurations.getHadoopConf((Configuration)new Configuration())).setBasePath(basePath).build();
        return (String)metaClient.getCommitsAndCompactionTimeline().filterCompletedInstants().firstInstant().map(HoodieInstant::getTimestamp).orElse(null);
    }

    @Nullable
    public static String getNthCompleteInstant(String basePath, int n, String action) {
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(HadoopConfigurations.getHadoopConf((Configuration)new Configuration())).setBasePath(basePath).build();
        return (String)metaClient.getActiveTimeline().filterCompletedInstants().filter(instant -> action.equals(instant.getAction())).nthInstant(n).map(HoodieInstant::getTimestamp).orElse(null);
    }

    @Nullable
    public static String getNthArchivedInstant(String basePath, int n) {
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(HadoopConfigurations.getHadoopConf((Configuration)new Configuration())).setBasePath(basePath).build();
        return (String)metaClient.getArchivedTimeline().getCommitsTimeline().filterCompletedInstants().nthInstant(n).map(HoodieInstant::getTimestamp).orElse(null);
    }

    public static String getSplitPartitionPath(MergeOnReadInputSplit split) {
        Assertions.assertTrue((boolean)split.getLogPaths().isPresent());
        String logPath = (String)((List)split.getLogPaths().get()).get(0);
        String[] paths = logPath.split("/");
        return paths[paths.length - 2];
    }

    public static StreamReadMonitoringFunction getMonitorFunc(Configuration conf) {
        String basePath = conf.getString(FlinkOptions.PATH);
        return new StreamReadMonitoringFunction(conf, new Path(basePath), TestConfigurations.ROW_TYPE, 0x100000L, null);
    }
}

