/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utils;

import java.math.BigDecimal;
import java.util.Random;
import java.util.UUID;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hudi.client.model.HoodieRowData;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.utils.TestData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHoodieRowData {
    private final int metaColumnsNum = HoodieRecord.HOODIE_META_COLUMNS_WITH_OPERATION.size();
    private static final Random RANDOM = new Random();
    private static final int INTEGER_INDEX = 0;
    private static final int STRING_INDEX = 1;
    private static final int BOOLEAN_INDEX = 2;
    private static final int SHORT_INDEX = 3;
    private static final int BYTE_INDEX = 4;
    private static final int LONG_INDEX = 5;
    private static final int FLOAT_INDEX = 6;
    private static final int DOUBLE_INDEX = 7;
    private static final int DECIMAL_INDEX = 8;
    private static final int BINARY_INDEX = 9;
    private static final int ROW_INDEX = 10;
    private static final DataType BASIC_DATA_TYPE = (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"integer", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"string", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"boolean", (DataType)DataTypes.BOOLEAN()), DataTypes.FIELD((String)"short", (DataType)DataTypes.SMALLINT()), DataTypes.FIELD((String)"byte", (DataType)DataTypes.TINYINT()), DataTypes.FIELD((String)"long", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"float", (DataType)DataTypes.FLOAT()), DataTypes.FIELD((String)"double", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"decimal", (DataType)DataTypes.DECIMAL((int)10, (int)4)), DataTypes.FIELD((String)"binary", (DataType)DataTypes.BYTES()), DataTypes.FIELD((String)"row", (DataType)DataTypes.ROW())}).notNull();
    private static final RowType ROW_TYPE = (RowType)BASIC_DATA_TYPE.getLogicalType();

    @Test
    public void testGet() {
        Object[] values = this.getRandomValue(true);
        BinaryRowData rowData = TestData.insertRow(ROW_TYPE, values);
        HoodieRowData hoodieRowData = new HoodieRowData("commitTime", "commitSeqNo", "recordKey", "partitionPath", "fileName", (RowData)rowData, true);
        this.assertValues(hoodieRowData, "commitTime", "commitSeqNo", "recordKey", "partitionPath", "fileName", values);
    }

    private Object[] getRandomValue(boolean haveRowType) {
        Object[] values = new Object[11];
        values[0] = RANDOM.nextInt();
        values[1] = StringData.fromString((String)UUID.randomUUID().toString());
        values[2] = RANDOM.nextBoolean();
        values[3] = (short)RANDOM.nextInt(2);
        byte[] bytes = new byte[1];
        RANDOM.nextBytes(bytes);
        values[4] = bytes[0];
        values[5] = RANDOM.nextLong();
        values[6] = Float.valueOf(RANDOM.nextFloat());
        values[7] = RANDOM.nextDouble();
        values[8] = DecimalData.fromBigDecimal((BigDecimal)new BigDecimal("1005.12313"), (int)10, (int)4);
        bytes = new byte[20];
        RANDOM.nextBytes(bytes);
        values[9] = bytes;
        if (haveRowType) {
            Object[] rowField = this.getRandomValue(false);
            values[10] = TestData.insertRow(ROW_TYPE, rowField);
        }
        return values;
    }

    private void assertValues(HoodieRowData hoodieRowData, String commitTime, String commitSeqNo, String recordKey, String partitionPath, String filename, Object[] values) {
        Assertions.assertEquals((Object)commitTime, (Object)hoodieRowData.getString(0).toString());
        Assertions.assertEquals((Object)commitSeqNo, (Object)hoodieRowData.getString(1).toString());
        Assertions.assertEquals((Object)recordKey, (Object)hoodieRowData.getString(2).toString());
        Assertions.assertEquals((Object)partitionPath, (Object)hoodieRowData.getString(3).toString());
        Assertions.assertEquals((Object)filename, (Object)hoodieRowData.getString(4).toString());
        Assertions.assertEquals((Object)"I", (Object)hoodieRowData.getString(5).toString());
        Assertions.assertEquals((Object)values[0], (Object)hoodieRowData.getInt(0 + this.metaColumnsNum));
        Assertions.assertEquals((Object)values[1], (Object)hoodieRowData.getString(1 + this.metaColumnsNum));
        Assertions.assertEquals((Object)values[2], (Object)hoodieRowData.getBoolean(2 + this.metaColumnsNum));
        Assertions.assertEquals((Object)values[3], (Object)hoodieRowData.getShort(3 + this.metaColumnsNum));
        Assertions.assertEquals((Object)values[4], (Object)hoodieRowData.getByte(4 + this.metaColumnsNum));
        Assertions.assertEquals((Object)values[5], (Object)hoodieRowData.getLong(5 + this.metaColumnsNum));
        Assertions.assertEquals((Object)values[6], (Object)Float.valueOf(hoodieRowData.getFloat(6 + this.metaColumnsNum)));
        Assertions.assertEquals((Object)values[7], (Object)hoodieRowData.getDouble(7 + this.metaColumnsNum));
        Assertions.assertEquals((Object)values[8], (Object)hoodieRowData.getDecimal(8 + this.metaColumnsNum, 10, 4));
        byte[] exceptBinary = (byte[])values[9];
        byte[] binary = hoodieRowData.getBinary(9 + this.metaColumnsNum);
        for (int i = 0; i < exceptBinary.length; ++i) {
            Assertions.assertEquals((byte)exceptBinary[i], (byte)binary[i]);
        }
        Assertions.assertEquals((Object)values[10], (Object)hoodieRowData.getRow(10 + this.metaColumnsNum, values.length));
    }
}

