/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utils;

import org.apache.avro.Schema;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.hudi.avro.model.HoodieMetadataRecord;
import org.apache.hudi.util.AvroSchemaConverter;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;

public class TestAvroSchemaConverter {
    @Test
    void testUnionSchemaWithMultipleRecordTypes() {
        Schema schema = HoodieMetadataRecord.SCHEMA$;
        DataType dataType = AvroSchemaConverter.convertToDataType((Schema)schema);
        int pos = HoodieMetadataRecord.SCHEMA$.getField("ColumnStatsMetadata").pos();
        String expected = "ROW<`fileName` STRING, `columnName` STRING, `minValue` ROW<`wrapper` RAW('java.lang.Object', ?) NOT NULL>, `maxValue` ROW<`wrapper` RAW('java.lang.Object', ?) NOT NULL>, `valueCount` BIGINT, `nullCount` BIGINT, `totalSize` BIGINT, `totalUncompressedSize` BIGINT, `isDeleted` BOOLEAN NOT NULL>";
        MatcherAssert.assertThat((Object)((DataType)dataType.getChildren().get(pos)).toString(), (Matcher)CoreMatchers.is((Object)"ROW<`fileName` STRING, `columnName` STRING, `minValue` ROW<`wrapper` RAW('java.lang.Object', ?) NOT NULL>, `maxValue` ROW<`wrapper` RAW('java.lang.Object', ?) NOT NULL>, `valueCount` BIGINT, `nullCount` BIGINT, `totalSize` BIGINT, `totalUncompressedSize` BIGINT, `isDeleted` BOOLEAN NOT NULL>"));
    }

    @Test
    void testLocalTimestampType() {
        DataType dataType = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f_localtimestamp_millis", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3)), DataTypes.FIELD((String)"f_localtimestamp_micros", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)6))});
        Schema schema = AvroSchemaConverter.convertToSchema((LogicalType)dataType.getLogicalType());
        String expectedSchema = "[ \"null\", {\n  \"type\" : \"record\",\n  \"name\" : \"record\",\n  \"fields\" : [ {\n    \"name\" : \"f_localtimestamp_millis\",\n    \"type\" : [ \"null\", {\n      \"type\" : \"long\",\n      \"logicalType\" : \"local-timestamp-millis\"\n    } ],\n    \"default\" : null\n  }, {\n    \"name\" : \"f_localtimestamp_micros\",\n    \"type\" : [ \"null\", {\n      \"type\" : \"long\",\n      \"logicalType\" : \"local-timestamp-micros\"\n    } ],\n    \"default\" : null\n  } ]\n} ]";
        MatcherAssert.assertThat((Object)schema.toString(true), (Matcher)CoreMatchers.is((Object)"[ \"null\", {\n  \"type\" : \"record\",\n  \"name\" : \"record\",\n  \"fields\" : [ {\n    \"name\" : \"f_localtimestamp_millis\",\n    \"type\" : [ \"null\", {\n      \"type\" : \"long\",\n      \"logicalType\" : \"local-timestamp-millis\"\n    } ],\n    \"default\" : null\n  }, {\n    \"name\" : \"f_localtimestamp_micros\",\n    \"type\" : [ \"null\", {\n      \"type\" : \"long\",\n      \"logicalType\" : \"local-timestamp-micros\"\n    } ],\n    \"default\" : null\n  } ]\n} ]"));
        DataType convertedDataType = AvroSchemaConverter.convertToDataType((Schema)schema);
        String expectedDataType = "ROW<`f_localtimestamp_millis` TIMESTAMP_LTZ(3), `f_localtimestamp_micros` TIMESTAMP_LTZ(6)>";
        MatcherAssert.assertThat((Object)convertedDataType.toString(), (Matcher)CoreMatchers.is((Object)"ROW<`f_localtimestamp_millis` TIMESTAMP_LTZ(3), `f_localtimestamp_micros` TIMESTAMP_LTZ(6)>"));
    }
}

