/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utils;

import java.util.Collection;
import org.apache.flink.runtime.client.JobStatusMessage;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.test.util.MiniClusterWithClientResource;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkMiniCluster
implements BeforeAllCallback,
AfterAllCallback,
AfterEachCallback {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkMiniCluster.class);
    public static final int DEFAULT_PARALLELISM = 4;
    private static final MiniClusterWithClientResource MINI_CLUSTER_RESOURCE = new MiniClusterWithClientResource(new MiniClusterResourceConfiguration.Builder().setNumberTaskManagers(1).setNumberSlotsPerTaskManager(4).build());

    public void beforeAll(ExtensionContext context) throws Exception {
        MINI_CLUSTER_RESOURCE.before();
    }

    public void afterAll(ExtensionContext context) {
        MINI_CLUSTER_RESOURCE.after();
    }

    public void afterEach(ExtensionContext context) throws Exception {
        this.cleanupRunningJobs();
    }

    private void cleanupRunningJobs() throws Exception {
        if (!MINI_CLUSTER_RESOURCE.getMiniCluster().isRunning()) {
            LOG.warn("Mini cluster is not running after the test!");
            return;
        }
        for (JobStatusMessage path : (Collection)MINI_CLUSTER_RESOURCE.getClusterClient().listJobs().get()) {
            if (path.getJobState().isTerminalState()) continue;
            try {
                MINI_CLUSTER_RESOURCE.getClusterClient().cancel(path.getJobId()).get();
            }
            catch (Exception exception) {}
        }
    }
}

