/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.format.cow;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.hadoop.fs.BlockLocation;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.jupiter.api.Test;

public class TestBlockLocationSort {
    private static BlockLocation createBlockLocation(int offset, int length) {
        return new BlockLocation(new String[0], new String[0], (long)offset, (long)length);
    }

    @Test
    void testBlockLocationSort() {
        BlockLocation o1 = TestBlockLocationSort.createBlockLocation(0, 5);
        BlockLocation o2 = TestBlockLocationSort.createBlockLocation(6, 4);
        BlockLocation o3 = TestBlockLocationSort.createBlockLocation(5, 5);
        BlockLocation[] blocks = new BlockLocation[]{o1, o2, o3};
        BlockLocation[] sortedBlocks = new BlockLocation[]{o1, o3, o2};
        Arrays.sort(blocks, Comparator.comparingLong(BlockLocation::getOffset));
        MatcherAssert.assertThat((Object)blocks, (Matcher)IsEqual.equalTo((Object)sortedBlocks));
        Arrays.sort(blocks, Comparator.comparingLong(BlockLocation::getOffset));
        MatcherAssert.assertThat((Object)blocks, (Matcher)IsEqual.equalTo((Object)sortedBlocks));
    }
}

