/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.format;

import java.math.BigDecimal;
import java.time.LocalDate;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.hudi.table.format.CastMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestCastMap {
    @Test
    public void testCastInt() {
        CastMap castMap = new CastMap();
        castMap.add(0, (LogicalType)new IntType(), (LogicalType)new BigIntType());
        castMap.add(1, (LogicalType)new IntType(), (LogicalType)new FloatType());
        castMap.add(2, (LogicalType)new IntType(), (LogicalType)new DoubleType());
        castMap.add(3, (LogicalType)new IntType(), (LogicalType)new DecimalType());
        castMap.add(4, (LogicalType)new IntType(), (LogicalType)new VarCharType());
        int val = 1;
        Assertions.assertEquals((Object)1L, (Object)castMap.castIfNeeded(0, (Object)val));
        Assertions.assertEquals((Object)Float.valueOf(1.0f), (Object)castMap.castIfNeeded(1, (Object)val));
        Assertions.assertEquals((Object)1.0, (Object)castMap.castIfNeeded(2, (Object)val));
        Assertions.assertEquals((Object)DecimalData.fromBigDecimal((BigDecimal)BigDecimal.ONE, (int)1, (int)0), (Object)castMap.castIfNeeded(3, (Object)val));
        Assertions.assertEquals((Object)BinaryStringData.fromString((String)"1"), (Object)castMap.castIfNeeded(4, (Object)val));
    }

    @Test
    public void testCastLong() {
        CastMap castMap = new CastMap();
        castMap.add(0, (LogicalType)new BigIntType(), (LogicalType)new FloatType());
        castMap.add(1, (LogicalType)new BigIntType(), (LogicalType)new DoubleType());
        castMap.add(2, (LogicalType)new BigIntType(), (LogicalType)new DecimalType());
        castMap.add(3, (LogicalType)new BigIntType(), (LogicalType)new VarCharType());
        long val = 1L;
        Assertions.assertEquals((Object)Float.valueOf(1.0f), (Object)castMap.castIfNeeded(0, (Object)val));
        Assertions.assertEquals((Object)1.0, (Object)castMap.castIfNeeded(1, (Object)val));
        Assertions.assertEquals((Object)DecimalData.fromBigDecimal((BigDecimal)BigDecimal.ONE, (int)1, (int)0), (Object)castMap.castIfNeeded(2, (Object)val));
        Assertions.assertEquals((Object)BinaryStringData.fromString((String)"1"), (Object)castMap.castIfNeeded(3, (Object)val));
    }

    @Test
    public void testCastFloat() {
        CastMap castMap = new CastMap();
        castMap.add(0, (LogicalType)new FloatType(), (LogicalType)new DoubleType());
        castMap.add(1, (LogicalType)new FloatType(), (LogicalType)new DecimalType());
        castMap.add(2, (LogicalType)new FloatType(), (LogicalType)new VarCharType());
        float val = 1.0f;
        Assertions.assertEquals((Object)1.0, (Object)castMap.castIfNeeded(0, (Object)Float.valueOf(val)));
        Assertions.assertEquals((Object)DecimalData.fromBigDecimal((BigDecimal)BigDecimal.ONE, (int)1, (int)0), (Object)castMap.castIfNeeded(1, (Object)Float.valueOf(val)));
        Assertions.assertEquals((Object)BinaryStringData.fromString((String)"1.0"), (Object)castMap.castIfNeeded(2, (Object)Float.valueOf(val)));
    }

    @Test
    public void testCastDouble() {
        CastMap castMap = new CastMap();
        castMap.add(0, (LogicalType)new DoubleType(), (LogicalType)new DecimalType());
        castMap.add(1, (LogicalType)new DoubleType(), (LogicalType)new VarCharType());
        double val = 1.0;
        Assertions.assertEquals((Object)DecimalData.fromBigDecimal((BigDecimal)BigDecimal.ONE, (int)1, (int)0), (Object)castMap.castIfNeeded(0, (Object)val));
        Assertions.assertEquals((Object)BinaryStringData.fromString((String)"1.0"), (Object)castMap.castIfNeeded(1, (Object)val));
    }

    @Test
    public void testCastDecimal() {
        CastMap castMap = new CastMap();
        castMap.add(0, (LogicalType)new DecimalType(2, 1), (LogicalType)new DecimalType(3, 2));
        castMap.add(1, (LogicalType)new DecimalType(), (LogicalType)new VarCharType());
        DecimalData val = DecimalData.fromBigDecimal((BigDecimal)BigDecimal.ONE, (int)2, (int)1);
        Assertions.assertEquals((Object)DecimalData.fromBigDecimal((BigDecimal)BigDecimal.ONE, (int)3, (int)2), (Object)castMap.castIfNeeded(0, (Object)val));
        Assertions.assertEquals((Object)BinaryStringData.fromString((String)"1.0"), (Object)castMap.castIfNeeded(1, (Object)val));
    }

    @Test
    public void testCastString() {
        CastMap castMap = new CastMap();
        castMap.add(0, (LogicalType)new VarCharType(), (LogicalType)new DecimalType());
        castMap.add(1, (LogicalType)new VarCharType(), (LogicalType)new DateType());
        Assertions.assertEquals((Object)DecimalData.fromBigDecimal((BigDecimal)BigDecimal.ONE, (int)1, (int)0), (Object)castMap.castIfNeeded(0, (Object)BinaryStringData.fromString((String)"1.0")));
        Assertions.assertEquals((Object)((int)LocalDate.parse("2022-05-12").toEpochDay()), (Object)castMap.castIfNeeded(1, (Object)BinaryStringData.fromString((String)"2022-05-12")));
    }

    @Test
    public void testCastDate() {
        CastMap castMap = new CastMap();
        castMap.add(0, (LogicalType)new DateType(), (LogicalType)new VarCharType());
        Assertions.assertEquals((Object)BinaryStringData.fromString((String)"2022-05-12"), (Object)castMap.castIfNeeded(0, (Object)((int)LocalDate.parse("2022-05-12").toEpochDay())));
    }
}

