/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.catalog;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionNotExistException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.types.DataType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.exception.HoodieCatalogException;
import org.apache.hudi.sink.partitioner.profile.WriteProfiles;
import org.apache.hudi.table.catalog.HoodieCatalogTestUtils;
import org.apache.hudi.table.catalog.HoodieCatalogUtil;
import org.apache.hudi.table.catalog.HoodieHiveCatalog;
import org.apache.hudi.util.StreamerUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class TestHoodieHiveCatalog {
    TableSchema schema = TableSchema.builder().field("uuid", (DataType)DataTypes.INT().notNull()).field("name", DataTypes.STRING()).field("age", DataTypes.INT()).field("par1", DataTypes.STRING()).field("ts", DataTypes.BIGINT()).primaryKey(new String[]{"uuid"}).build();
    List<String> partitions = Collections.singletonList("par1");
    private static HoodieHiveCatalog hoodieCatalog;
    private final ObjectPath tablePath = new ObjectPath("default", "test");

    @BeforeAll
    public static void createCatalog() {
        hoodieCatalog = HoodieCatalogTestUtils.createHiveCatalog();
        hoodieCatalog.open();
    }

    @AfterEach
    public void dropTable() throws TableNotExistException {
        hoodieCatalog.dropTable(this.tablePath, true);
    }

    @AfterAll
    public static void closeCatalog() {
        if (hoodieCatalog != null) {
            hoodieCatalog.close();
        }
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testCreateAndGetHoodieTable(HoodieTableType tableType) throws Exception {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(FactoryUtil.CONNECTOR.key(), "hudi");
        options.put(FlinkOptions.TABLE_TYPE.key(), tableType.toString());
        CatalogTableImpl table = new CatalogTableImpl(this.schema, this.partitions, options, "hudi table");
        hoodieCatalog.createTable(this.tablePath, (CatalogBaseTable)table, false);
        Table hiveTable = hoodieCatalog.getHiveTable(this.tablePath);
        String fieldSchema = hiveTable.getSd().getCols().stream().map(f -> f.getName() + ":" + f.getType()).collect(Collectors.joining(","));
        String expectedFieldSchema = "_hoodie_commit_time:string,_hoodie_commit_seqno:string,_hoodie_record_key:string,_hoodie_partition_path:string,_hoodie_file_name:string,uuid:int,name:string,age:int,ts:bigint";
        Assertions.assertEquals((Object)expectedFieldSchema, (Object)fieldSchema);
        String partitionSchema = hiveTable.getPartitionKeys().stream().map(f -> f.getName() + ":" + f.getType()).collect(Collectors.joining(","));
        Assertions.assertEquals((Object)"par1:string", (Object)partitionSchema);
        String avroSchemaStr = (String)hiveTable.getParameters().get("spark.sql.sources.schema.part.0");
        String expectedAvroSchemaStr = "{\"type\":\"struct\",\"fields\":[{\"name\":\"_hoodie_commit_time\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}},{\"name\":\"_hoodie_commit_seqno\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}},{\"name\":\"_hoodie_record_key\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}},{\"name\":\"_hoodie_partition_path\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}},{\"name\":\"_hoodie_file_name\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}},{\"name\":\"uuid\",\"type\":\"integer\",\"nullable\":false,\"metadata\":{}},{\"name\":\"name\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}},{\"name\":\"age\",\"type\":\"integer\",\"nullable\":true,\"metadata\":{}},{\"name\":\"ts\",\"type\":\"long\",\"nullable\":true,\"metadata\":{}},{\"name\":\"par1\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}}]}";
        Assertions.assertEquals((Object)expectedAvroSchemaStr, (Object)avroSchemaStr);
        CatalogBaseTable table1 = hoodieCatalog.getTable(this.tablePath);
        Assertions.assertEquals((Object)"hudi", table1.getOptions().get(FactoryUtil.CONNECTOR.key()));
        Assertions.assertEquals((Object)tableType.toString(), table1.getOptions().get(FlinkOptions.TABLE_TYPE.key()));
        Assertions.assertEquals((Object)"uuid", table1.getOptions().get(FlinkOptions.RECORD_KEY_FIELD.key()));
        Assertions.assertNull(table1.getOptions().get(FlinkOptions.PRECOMBINE_FIELD.key()), (String)"preCombine key is not declared");
        String tableSchema = table1.getUnresolvedSchema().getColumns().stream().map(Schema.UnresolvedColumn::toString).collect(Collectors.joining(","));
        String expectedTableSchema = "`uuid` INT NOT NULL,`name` STRING,`age` INT,`par1` STRING,`ts` BIGINT";
        Assertions.assertEquals((Object)expectedTableSchema, (Object)tableSchema);
        Assertions.assertEquals(Collections.singletonList("uuid"), (Object)((Schema.UnresolvedPrimaryKey)table1.getUnresolvedSchema().getPrimaryKey().get()).getColumnNames());
        Assertions.assertEquals(Collections.singletonList("par1"), (Object)((CatalogTable)table1).getPartitionKeys());
        options.put(FlinkOptions.RECORD_KEY_FIELD.key(), "id");
        table = new CatalogTableImpl(this.schema, this.partitions, options, "hudi table");
        hoodieCatalog.alterTable(this.tablePath, (CatalogBaseTable)table, true);
        CatalogBaseTable table2 = hoodieCatalog.getTable(this.tablePath);
        Assertions.assertEquals((Object)"id", table2.getOptions().get(FlinkOptions.RECORD_KEY_FIELD.key()));
    }

    @Test
    public void testCreateExternalTable() throws TableAlreadyExistException, DatabaseNotExistException, TableNotExistException, IOException {
        HoodieHiveCatalog catalog = HoodieCatalogTestUtils.createHiveCatalog("myCatalog", true);
        catalog.open();
        HashMap<String, String> originOptions = new HashMap<String, String>();
        originOptions.put(FactoryUtil.CONNECTOR.key(), "hudi");
        CatalogTableImpl table = new CatalogTableImpl(this.schema, originOptions, "hudi table");
        catalog.createTable(this.tablePath, (CatalogBaseTable)table, false);
        Table table1 = catalog.getHiveTable(this.tablePath);
        Assertions.assertTrue((boolean)Boolean.parseBoolean((String)table1.getParameters().get("EXTERNAL")));
        Assertions.assertEquals((Object)"EXTERNAL_TABLE", (Object)table1.getTableType());
        catalog.dropTable(this.tablePath, false);
        org.apache.hadoop.fs.Path path = new org.apache.hadoop.fs.Path((String)table1.getParameters().get(FlinkOptions.PATH.key()));
        boolean created = StreamerUtil.fileExists((FileSystem)FSUtils.getFs((org.apache.hadoop.fs.Path)path, (Configuration)new Configuration()), (org.apache.hadoop.fs.Path)path);
        Assertions.assertTrue((boolean)created, (String)"Table should have been created");
    }

    @Test
    public void testCreateNonHoodieTable() throws TableAlreadyExistException, DatabaseNotExistException {
        CatalogTableImpl table = new CatalogTableImpl(this.schema, Collections.emptyMap(), "hudi table");
        try {
            hoodieCatalog.createTable(this.tablePath, (CatalogBaseTable)table, false);
        }
        catch (HoodieCatalogException e) {
            Assertions.assertEquals((Object)String.format("The %s is not hoodie table", this.tablePath.getObjectName()), (Object)e.getMessage());
        }
    }

    @Test
    public void testAlterTable() throws Exception {
        HashMap<String, String> originOptions = new HashMap<String, String>();
        originOptions.put(FactoryUtil.CONNECTOR.key(), "hudi");
        CatalogTableImpl originTable = new CatalogTableImpl(this.schema, this.partitions, originOptions, "hudi table");
        hoodieCatalog.createTable(this.tablePath, (CatalogBaseTable)originTable, false);
        Table hiveTable = hoodieCatalog.getHiveTable(this.tablePath);
        Map newOptions = hiveTable.getParameters();
        newOptions.put("k", "v");
        CatalogTableImpl newTable = new CatalogTableImpl(this.schema, this.partitions, newOptions, "alter hudi table");
        hoodieCatalog.alterTable(this.tablePath, (CatalogBaseTable)newTable, false);
        hiveTable = hoodieCatalog.getHiveTable(this.tablePath);
        Assertions.assertEquals(hiveTable.getParameters().get(FactoryUtil.CONNECTOR.key()), (Object)"hudi");
        Assertions.assertEquals(hiveTable.getParameters().get("k"), (Object)"v");
    }

    @Test
    public void testRenameTable() throws Exception {
        HashMap<String, String> originOptions = new HashMap<String, String>();
        originOptions.put(FactoryUtil.CONNECTOR.key(), "hudi");
        CatalogTableImpl originTable = new CatalogTableImpl(this.schema, this.partitions, originOptions, "hudi table");
        hoodieCatalog.createTable(this.tablePath, (CatalogBaseTable)originTable, false);
        hoodieCatalog.renameTable(this.tablePath, "test1", false);
        Assertions.assertEquals((Object)hoodieCatalog.getHiveTable(new ObjectPath("default", "test1")).getTableName(), (Object)"test1");
        hoodieCatalog.renameTable(new ObjectPath("default", "test1"), "test", false);
    }

    @Test
    public void testDropPartition() throws Exception {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(FactoryUtil.CONNECTOR.key(), "hudi");
        CatalogTableImpl table = new CatalogTableImpl(this.schema, this.partitions, options, "hudi table");
        hoodieCatalog.createTable(this.tablePath, (CatalogBaseTable)table, false);
        CatalogPartitionSpec partitionSpec = new CatalogPartitionSpec((Map)new HashMap<String, String>(){
            {
                this.put("par1", "20221020");
            }
        });
        Assertions.assertThrows(PartitionNotExistException.class, () -> hoodieCatalog.dropPartition(this.tablePath, partitionSpec, false));
        Table hiveTable = hoodieCatalog.getHiveTable(this.tablePath);
        StorageDescriptor partitionSd = new StorageDescriptor(hiveTable.getSd());
        partitionSd.setLocation(new org.apache.hadoop.fs.Path(partitionSd.getLocation(), HoodieCatalogUtil.inferPartitionPath((boolean)true, (CatalogPartitionSpec)partitionSpec)).toString());
        hoodieCatalog.getClient().add_partition(new Partition(Collections.singletonList("20221020"), this.tablePath.getDatabaseName(), this.tablePath.getObjectName(), 0, 0, partitionSd, null));
        Assertions.assertNotNull((Object)this.getHivePartition(partitionSpec));
        hoodieCatalog.dropPartition(this.tablePath, partitionSpec, false);
        String tablePathStr = hoodieCatalog.inferTablePath(this.tablePath, hoodieCatalog.getTable(this.tablePath));
        HoodieTableMetaClient metaClient = StreamerUtil.createMetaClient((String)tablePathStr, (Configuration)hoodieCatalog.getHiveConf());
        HoodieInstant latestInstant = (HoodieInstant)metaClient.getActiveTimeline().filterCompletedInstants().lastInstant().orElse(null);
        Assertions.assertNotNull((Object)latestInstant, (String)"Delete partition commit should be completed");
        HoodieCommitMetadata commitMetadata = WriteProfiles.getCommitMetadata((String)this.tablePath.getObjectName(), (Path)new Path(tablePathStr), (HoodieInstant)latestInstant, (HoodieTimeline)metaClient.getActiveTimeline());
        MatcherAssert.assertThat((Object)commitMetadata, (Matcher)CoreMatchers.instanceOf(HoodieReplaceCommitMetadata.class));
        HoodieReplaceCommitMetadata replaceCommitMetadata = (HoodieReplaceCommitMetadata)commitMetadata;
        MatcherAssert.assertThat((Object)replaceCommitMetadata.getPartitionToReplaceFileIds().size(), (Matcher)CoreMatchers.is((Object)1));
        Assertions.assertThrows(NoSuchObjectException.class, () -> this.getHivePartition(partitionSpec));
    }

    private Partition getHivePartition(CatalogPartitionSpec partitionSpec) throws Exception {
        return hoodieCatalog.getClient().getPartition(this.tablePath.getDatabaseName(), this.tablePath.getObjectName(), HoodieCatalogUtil.getOrderedPartitionValues((String)hoodieCatalog.getName(), (HiveConf)hoodieCatalog.getHiveConf(), (CatalogPartitionSpec)partitionSpec, this.partitions, (ObjectPath)this.tablePath));
    }
}

