/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.catalog;

import java.io.IOException;
import java.net.URL;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hudi.table.catalog.CatalogOptions;
import org.apache.hudi.table.catalog.HoodieHiveCatalog;
import org.junit.rules.TemporaryFolder;

public class HoodieCatalogTestUtils {
    private static final String HIVE_WAREHOUSE_URI_FORMAT = "jdbc:derby:;databaseName=%s;create=true";
    private static final String TEST_CATALOG_NAME = "test_catalog";
    private static final TemporaryFolder TEMPORARY_FOLDER = new TemporaryFolder();

    public static HoodieHiveCatalog createHiveCatalog() {
        return HoodieCatalogTestUtils.createHiveCatalog(TEST_CATALOG_NAME);
    }

    public static HoodieHiveCatalog createHiveCatalog(String name) {
        return HoodieCatalogTestUtils.createHiveCatalog(name, false);
    }

    public static HoodieHiveCatalog createHiveCatalog(String name, boolean external) {
        Configuration options = new Configuration();
        options.setBoolean(CatalogOptions.TABLE_EXTERNAL, external);
        return new HoodieHiveCatalog(name, options, HoodieCatalogTestUtils.createHiveConf(), true);
    }

    public static HiveConf createHiveConf() {
        ClassLoader classLoader = HoodieCatalogTestUtils.class.getClassLoader();
        try {
            TEMPORARY_FOLDER.create();
            String warehouseDir = TEMPORARY_FOLDER.newFolder().getAbsolutePath() + "/metastore_db";
            String warehouseUri = String.format(HIVE_WAREHOUSE_URI_FORMAT, warehouseDir);
            HiveConf.setHiveSiteLocation((URL)classLoader.getResource("hive-site.xml"));
            HiveConf hiveConf = new HiveConf();
            hiveConf.setVar(HiveConf.ConfVars.METASTOREWAREHOUSE, TEMPORARY_FOLDER.newFolder("hive_warehouse").getAbsolutePath());
            hiveConf.setVar(HiveConf.ConfVars.METASTORECONNECTURLKEY, warehouseUri);
            return hiveConf;
        }
        catch (IOException e) {
            throw new CatalogException("Failed to create test HiveConf to HiveCatalog.", (Throwable)e);
        }
    }
}

