/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.source;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.source.IncrementalInputSplits;
import org.apache.hudi.utils.TestConfigurations;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestIncrementalInputSplits
extends HoodieCommonTestHarness {
    @BeforeEach
    private void init() throws IOException {
        this.initPath();
        this.initMetaClient();
    }

    @Test
    void testFilterInstantsWithRange() {
        HoodieActiveTimeline timeline = new HoodieActiveTimeline(this.metaClient, true);
        Configuration conf = TestConfigurations.getDefaultConf(this.basePath);
        IncrementalInputSplits iis = IncrementalInputSplits.builder().conf(conf).path(new Path(this.basePath)).rowType(TestConfigurations.ROW_TYPE).build();
        HoodieInstant commit1 = new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", "1");
        HoodieInstant commit2 = new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", "2");
        HoodieInstant commit3 = new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", "3");
        timeline.createNewInstant(commit1);
        timeline.createNewInstant(commit2);
        timeline.createNewInstant(commit3);
        timeline = timeline.reload();
        List instantRange2 = iis.filterInstantsWithRange((HoodieTimeline)timeline, "1");
        Assertions.assertEquals((int)2, (int)instantRange2.size());
        Assertions.assertIterableEquals(Arrays.asList(commit2, commit3), (Iterable)instantRange2);
        List instantRange1 = iis.filterInstantsWithRange((HoodieTimeline)timeline, null);
        Assertions.assertEquals((int)1, (int)instantRange1.size());
        Assertions.assertIterableEquals(Collections.singletonList(commit3), (Iterable)instantRange1);
        conf.set(FlinkOptions.READ_START_COMMIT, (Object)"1");
        conf.set(FlinkOptions.READ_END_COMMIT, (Object)"3");
        List instantRange3 = iis.filterInstantsWithRange((HoodieTimeline)timeline, null);
        Assertions.assertEquals((int)3, (int)instantRange3.size());
        Assertions.assertIterableEquals(Arrays.asList(commit1, commit2, commit3), (Iterable)instantRange3);
        HoodieInstant commit4 = new HoodieInstant(HoodieInstant.State.INFLIGHT, "compaction", "4");
        timeline.createNewInstant(commit4);
        timeline = timeline.reload();
        Assertions.assertEquals((int)4, (int)timeline.getInstants().size());
        List instantRange4 = iis.filterInstantsWithRange((HoodieTimeline)timeline, null);
        Assertions.assertEquals((int)3, (int)instantRange4.size());
    }
}

