/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.source;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.keygen.NonpartitionedAvroKeyGenerator;
import org.apache.hudi.source.FileIndex;
import org.apache.hudi.utils.TestConfigurations;
import org.apache.hudi.utils.TestData;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class TestFileIndex {
    @TempDir
    File tempFile;

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testFileListingUsingMetadata(boolean hiveStylePartitioning) throws Exception {
        Configuration conf = TestConfigurations.getDefaultConf(this.tempFile.getAbsolutePath());
        conf.setBoolean(FlinkOptions.METADATA_ENABLED, true);
        conf.setBoolean(FlinkOptions.HIVE_STYLE_PARTITIONING, hiveStylePartitioning);
        TestData.writeData(TestData.DATA_SET_INSERT, conf);
        FileIndex fileIndex = FileIndex.instance((Path)new Path(this.tempFile.getAbsolutePath()), (Configuration)conf, (RowType)TestConfigurations.ROW_TYPE);
        List<String> partitionKeys = Collections.singletonList("partition");
        List partitions = fileIndex.getPartitions(partitionKeys, (String)FlinkOptions.PARTITION_DEFAULT_NAME.defaultValue(), hiveStylePartitioning);
        Assertions.assertTrue((boolean)partitions.stream().allMatch(m -> m.size() == 1));
        String partitionPaths = partitions.stream().map(Map::values).flatMap(Collection::stream).sorted().collect(Collectors.joining(","));
        MatcherAssert.assertThat((String)"should have 4 partitions", (Object)partitionPaths, (Matcher)CoreMatchers.is((Object)"par1,par2,par3,par4"));
        FileStatus[] fileStatuses = fileIndex.getFilesInPartitions();
        MatcherAssert.assertThat((Object)fileStatuses.length, (Matcher)CoreMatchers.is((Object)4));
        Assertions.assertTrue((boolean)Arrays.stream(fileStatuses).allMatch(fileStatus -> fileStatus.getPath().toString().endsWith(HoodieFileFormat.PARQUET.getFileExtension())));
    }

    @Test
    void testFileListingUsingMetadataNonPartitionedTable() throws Exception {
        Configuration conf = TestConfigurations.getDefaultConf(this.tempFile.getAbsolutePath());
        conf.setString(FlinkOptions.PARTITION_PATH_FIELD, "");
        conf.setString(FlinkOptions.KEYGEN_CLASS_NAME, NonpartitionedAvroKeyGenerator.class.getName());
        conf.setBoolean(FlinkOptions.METADATA_ENABLED, true);
        TestData.writeData(TestData.DATA_SET_INSERT, conf);
        FileIndex fileIndex = FileIndex.instance((Path)new Path(this.tempFile.getAbsolutePath()), (Configuration)conf, (RowType)TestConfigurations.ROW_TYPE);
        List<String> partitionKeys = Collections.singletonList("");
        List partitions = fileIndex.getPartitions(partitionKeys, (String)FlinkOptions.PARTITION_DEFAULT_NAME.defaultValue(), false);
        MatcherAssert.assertThat((Object)partitions.size(), (Matcher)CoreMatchers.is((Object)0));
        FileStatus[] fileStatuses = fileIndex.getFilesInPartitions();
        MatcherAssert.assertThat((Object)fileStatuses.length, (Matcher)CoreMatchers.is((Object)1));
        Assertions.assertTrue((boolean)fileStatuses[0].getPath().toString().endsWith(HoodieFileFormat.PARQUET.getFileExtension()));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testFileListingEmptyTable(boolean enableMetadata) {
        Configuration conf = TestConfigurations.getDefaultConf(this.tempFile.getAbsolutePath());
        conf.setBoolean(FlinkOptions.METADATA_ENABLED, enableMetadata);
        FileIndex fileIndex = FileIndex.instance((Path)new Path(this.tempFile.getAbsolutePath()), (Configuration)conf, (RowType)TestConfigurations.ROW_TYPE);
        List<String> partitionKeys = Collections.singletonList("partition");
        List partitions = fileIndex.getPartitions(partitionKeys, (String)FlinkOptions.PARTITION_DEFAULT_NAME.defaultValue(), false);
        MatcherAssert.assertThat((Object)partitions.size(), (Matcher)CoreMatchers.is((Object)0));
        FileStatus[] fileStatuses = fileIndex.getFilesInPartitions();
        MatcherAssert.assertThat((Object)fileStatuses.length, (Matcher)CoreMatchers.is((Object)0));
    }
}

