/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.utils;

import java.util.HashMap;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.state.KeyedStateStore;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.testutils.MockEnvironment;
import org.apache.flink.runtime.operators.testutils.MockEnvironmentBuilder;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.streaming.runtime.tasks.TestProcessingTimeService;
import org.apache.hudi.adapter.StreamingRuntimeContextAdapter;
import org.apache.hudi.sink.utils.MockOperatorStateStore;

public class MockStreamingRuntimeContext
extends StreamingRuntimeContextAdapter {
    private final boolean isCheckpointingEnabled;
    private final int numParallelSubtasks;
    private final int subtaskIndex;

    public MockStreamingRuntimeContext(boolean isCheckpointingEnabled, int numParallelSubtasks, int subtaskIndex) {
        this(isCheckpointingEnabled, numParallelSubtasks, subtaskIndex, new MockEnvironmentBuilder().setTaskName("mockTask").setManagedMemorySize(131072L).build());
    }

    public MockStreamingRuntimeContext(boolean isCheckpointingEnabled, int numParallelSubtasks, int subtaskIndex, MockEnvironment environment) {
        super((AbstractStreamOperator)new MockStreamOperator(), (Environment)environment, new HashMap());
        this.isCheckpointingEnabled = isCheckpointingEnabled;
        this.numParallelSubtasks = numParallelSubtasks;
        this.subtaskIndex = subtaskIndex;
    }

    public boolean isCheckpointingEnabled() {
        return this.isCheckpointingEnabled;
    }

    public int getIndexOfThisSubtask() {
        return this.subtaskIndex;
    }

    public int getNumberOfParallelSubtasks() {
        return this.numParallelSubtasks;
    }

    private static class MockStreamOperator
    extends AbstractStreamOperator<Integer> {
        private static final long serialVersionUID = -1153976702711944427L;
        private transient TestProcessingTimeService testProcessingTimeService;
        private transient MockOperatorStateStore mockOperatorStateStore;

        private MockStreamOperator() {
        }

        public ExecutionConfig getExecutionConfig() {
            return new ExecutionConfig();
        }

        public OperatorID getOperatorID() {
            return new OperatorID();
        }

        public ProcessingTimeService getProcessingTimeService() {
            if (this.testProcessingTimeService == null) {
                this.testProcessingTimeService = new TestProcessingTimeService();
            }
            return this.testProcessingTimeService;
        }

        public KeyedStateStore getKeyedStateStore() {
            if (this.mockOperatorStateStore == null) {
                this.mockOperatorStateStore = new MockOperatorStateStore();
            }
            return this.mockOperatorStateStore;
        }
    }
}

