/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.utils;

import org.apache.flink.runtime.operators.coordination.OperatorCoordinator;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.function.ThrowingRunnable;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.sink.utils.NonThrownExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockCoordinatorExecutor
extends NonThrownExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(MockCoordinatorExecutor.class);

    public MockCoordinatorExecutor(OperatorCoordinator.Context context) {
        super(LOG, (errMsg, t) -> context.failJob((Throwable)new HoodieException(errMsg, t)), true);
    }

    public void execute(ThrowingRunnable<Throwable> action, NonThrownExecutor.ExceptionHook hook, String actionName, Object ... actionParams) {
        block2: {
            String actionString = String.format(actionName, actionParams);
            try {
                action.run();
                LOG.info("Executor executes action [{}] success!", (Object)actionString);
            }
            catch (Throwable t) {
                ExceptionUtils.rethrowIfFatalErrorOrOOM((Throwable)t);
                String errMsg = String.format("Executor executes action [%s] error", actionString);
                if (hook == null) break block2;
                hook.apply(errMsg, t);
            }
        }
    }
}

