/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.bulk;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.exception.HoodieKeyException;
import org.apache.hudi.sink.bulk.RowDataKeyGen;
import org.apache.hudi.table.HoodieTableFactory;
import org.apache.hudi.utils.TestConfigurations;
import org.apache.hudi.utils.TestData;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class TestRowDataKeyGen {
    @Test
    void testSimpleKeyAndPartition() {
        Configuration conf = TestConfigurations.getDefaultConf("path1");
        BinaryRowData rowData1 = TestData.insertRow(StringData.fromString((String)"id1"), StringData.fromString((String)"Danny"), 23, TimestampData.fromEpochMillis((long)1L), StringData.fromString((String)"par1"));
        RowDataKeyGen keyGen1 = RowDataKeyGen.instance((Configuration)conf, (RowType)TestConfigurations.ROW_TYPE);
        MatcherAssert.assertThat((Object)keyGen1.getRecordKey((RowData)rowData1), (Matcher)CoreMatchers.is((Object)"id1"));
        MatcherAssert.assertThat((Object)keyGen1.getPartitionPath((RowData)rowData1), (Matcher)CoreMatchers.is((Object)"par1"));
        BinaryRowData rowData2 = TestData.insertRow(TestConfigurations.ROW_TYPE, new Object[]{null, StringData.fromString((String)"Danny"), 23, TimestampData.fromEpochMillis((long)1L), null});
        Assertions.assertThrows(HoodieKeyException.class, () -> TestRowDataKeyGen.lambda$testSimpleKeyAndPartition$0(keyGen1, (RowData)rowData2));
        MatcherAssert.assertThat((Object)keyGen1.getPartitionPath((RowData)rowData2), (Matcher)CoreMatchers.is((Object)"__HIVE_DEFAULT_PARTITION__"));
        BinaryRowData rowData3 = TestData.insertRow(StringData.fromString((String)""), StringData.fromString((String)"Danny"), 23, TimestampData.fromEpochMillis((long)1L), StringData.fromString((String)""));
        Assertions.assertThrows(HoodieKeyException.class, () -> TestRowDataKeyGen.lambda$testSimpleKeyAndPartition$1(keyGen1, (RowData)rowData3));
        MatcherAssert.assertThat((Object)keyGen1.getPartitionPath((RowData)rowData3), (Matcher)CoreMatchers.is((Object)"__HIVE_DEFAULT_PARTITION__"));
        conf.set(FlinkOptions.HIVE_STYLE_PARTITIONING, (Object)true);
        RowDataKeyGen keyGen2 = RowDataKeyGen.instance((Configuration)conf, (RowType)TestConfigurations.ROW_TYPE);
        MatcherAssert.assertThat((Object)keyGen2.getPartitionPath((RowData)rowData1), (Matcher)CoreMatchers.is((Object)String.format("partition=%s", "par1")));
        MatcherAssert.assertThat((Object)keyGen2.getPartitionPath((RowData)rowData2), (Matcher)CoreMatchers.is((Object)String.format("partition=%s", "__HIVE_DEFAULT_PARTITION__")));
        MatcherAssert.assertThat((Object)keyGen2.getPartitionPath((RowData)rowData3), (Matcher)CoreMatchers.is((Object)String.format("partition=%s", "__HIVE_DEFAULT_PARTITION__")));
    }

    @Test
    void testComplexKeyAndPartition() {
        Configuration conf = TestConfigurations.getDefaultConf("path1");
        conf.set(FlinkOptions.RECORD_KEY_FIELD, (Object)"uuid,name");
        conf.set(FlinkOptions.PARTITION_PATH_FIELD, (Object)"partition,ts");
        BinaryRowData rowData1 = TestData.insertRow(StringData.fromString((String)"id1"), StringData.fromString((String)"Danny"), 23, TimestampData.fromEpochMillis((long)1L), StringData.fromString((String)"par1"));
        RowDataKeyGen keyGen1 = RowDataKeyGen.instance((Configuration)conf, (RowType)TestConfigurations.ROW_TYPE);
        MatcherAssert.assertThat((Object)keyGen1.getRecordKey((RowData)rowData1), (Matcher)CoreMatchers.is((Object)"uuid:id1,name:Danny"));
        MatcherAssert.assertThat((Object)keyGen1.getPartitionPath((RowData)rowData1), (Matcher)CoreMatchers.is((Object)"par1/1970-01-01T00:00:00.001"));
        BinaryRowData rowData2 = TestData.insertRow(TestConfigurations.ROW_TYPE, new Object[]{null, null, 23, null, null});
        Assertions.assertThrows(HoodieKeyException.class, () -> TestRowDataKeyGen.lambda$testComplexKeyAndPartition$2(keyGen1, (RowData)rowData2));
        MatcherAssert.assertThat((Object)keyGen1.getPartitionPath((RowData)rowData2), (Matcher)CoreMatchers.is((Object)String.format("%s/%s", "__HIVE_DEFAULT_PARTITION__", "__HIVE_DEFAULT_PARTITION__")));
        BinaryRowData rowData3 = TestData.insertRow(StringData.fromString((String)""), StringData.fromString((String)""), 23, TimestampData.fromEpochMillis((long)1L), StringData.fromString((String)""));
        Assertions.assertThrows(HoodieKeyException.class, () -> TestRowDataKeyGen.lambda$testComplexKeyAndPartition$3(keyGen1, (RowData)rowData3));
        MatcherAssert.assertThat((Object)keyGen1.getPartitionPath((RowData)rowData3), (Matcher)CoreMatchers.is((Object)String.format("%s/1970-01-01T00:00:00.001", "__HIVE_DEFAULT_PARTITION__")));
        conf.set(FlinkOptions.HIVE_STYLE_PARTITIONING, (Object)true);
        RowDataKeyGen keyGen2 = RowDataKeyGen.instance((Configuration)conf, (RowType)TestConfigurations.ROW_TYPE);
        MatcherAssert.assertThat((Object)keyGen2.getPartitionPath((RowData)rowData1), (Matcher)CoreMatchers.is((Object)String.format("partition=%s/ts=%s", "par1", "1970-01-01T00:00:00.001")));
        MatcherAssert.assertThat((Object)keyGen2.getPartitionPath((RowData)rowData2), (Matcher)CoreMatchers.is((Object)String.format("partition=%s/ts=%s", "__HIVE_DEFAULT_PARTITION__", "__HIVE_DEFAULT_PARTITION__")));
        MatcherAssert.assertThat((Object)keyGen2.getPartitionPath((RowData)rowData3), (Matcher)CoreMatchers.is((Object)String.format("partition=%s/ts=%s", "__HIVE_DEFAULT_PARTITION__", "1970-01-01T00:00:00.001")));
    }

    @Test
    void testTimestampBasedKeyGenerator() {
        Configuration conf = TestConfigurations.getDefaultConf("path1");
        conf.setString(FlinkOptions.PARTITION_PATH_FIELD, "ts");
        HoodieTableFactory.setupTimestampKeygenOptions((Configuration)conf, (DataType)DataTypes.TIMESTAMP((int)3));
        BinaryRowData rowData1 = TestData.insertRow(StringData.fromString((String)"id1"), StringData.fromString((String)"Danny"), 23, TimestampData.fromEpochMillis((long)0x6DDD00L), StringData.fromString((String)"par1"));
        RowDataKeyGen keyGen1 = RowDataKeyGen.instance((Configuration)conf, (RowType)TestConfigurations.ROW_TYPE);
        MatcherAssert.assertThat((Object)keyGen1.getRecordKey((RowData)rowData1), (Matcher)CoreMatchers.is((Object)"id1"));
        MatcherAssert.assertThat((Object)keyGen1.getPartitionPath((RowData)rowData1), (Matcher)CoreMatchers.is((Object)"1970010102"));
        BinaryRowData rowData2 = TestData.insertRow(TestConfigurations.ROW_TYPE, new Object[]{null, StringData.fromString((String)"Danny"), 23, null, StringData.fromString((String)"par1")});
        Assertions.assertThrows(HoodieKeyException.class, () -> TestRowDataKeyGen.lambda$testTimestampBasedKeyGenerator$4(keyGen1, (RowData)rowData2));
        MatcherAssert.assertThat((Object)keyGen1.getPartitionPath((RowData)rowData2), (Matcher)CoreMatchers.is((Object)"1970010100"));
        BinaryRowData rowData3 = TestData.insertRow(StringData.fromString((String)""), StringData.fromString((String)"Danny"), 23, TimestampData.fromEpochMillis((long)1L), StringData.fromString((String)"par1"));
        Assertions.assertThrows(HoodieKeyException.class, () -> TestRowDataKeyGen.lambda$testTimestampBasedKeyGenerator$5(keyGen1, (RowData)rowData3));
        MatcherAssert.assertThat((Object)keyGen1.getPartitionPath((RowData)rowData3), (Matcher)CoreMatchers.is((Object)"1970010100"));
        conf.set(FlinkOptions.HIVE_STYLE_PARTITIONING, (Object)true);
        RowDataKeyGen keyGen2 = RowDataKeyGen.instance((Configuration)conf, (RowType)TestConfigurations.ROW_TYPE);
        MatcherAssert.assertThat((Object)keyGen2.getPartitionPath((RowData)rowData1), (Matcher)CoreMatchers.is((Object)"ts=1970010102"));
        MatcherAssert.assertThat((Object)keyGen2.getPartitionPath((RowData)rowData2), (Matcher)CoreMatchers.is((Object)"ts=1970010100"));
        MatcherAssert.assertThat((Object)keyGen2.getPartitionPath((RowData)rowData3), (Matcher)CoreMatchers.is((Object)"ts=1970010100"));
    }

    @ParameterizedTest
    @ValueSource(strings={"yyyy-MM-dd", "yyyyMMdd"})
    void testDateBasedKeyGenerator(String partitionFormat) {
        boolean dashed = partitionFormat.equals("yyyy-MM-dd");
        Configuration conf = TestConfigurations.getDefaultConf("path1", TestConfigurations.ROW_DATA_TYPE_DATE);
        conf.setString(FlinkOptions.PARTITION_PATH_FIELD, "dt");
        conf.setString(FlinkOptions.PARTITION_FORMAT, partitionFormat);
        HoodieTableFactory.setupTimestampKeygenOptions((Configuration)conf, (DataType)DataTypes.DATE());
        BinaryRowData rowData1 = TestData.insertRow(TestConfigurations.ROW_TYPE_DATE, new Object[]{StringData.fromString((String)"id1"), StringData.fromString((String)"Danny"), 23, 1});
        RowDataKeyGen keyGen1 = RowDataKeyGen.instance((Configuration)conf, (RowType)TestConfigurations.ROW_TYPE_DATE);
        MatcherAssert.assertThat((Object)keyGen1.getRecordKey((RowData)rowData1), (Matcher)CoreMatchers.is((Object)"id1"));
        String expectedPartition1 = dashed ? "1970-01-02" : "19700102";
        MatcherAssert.assertThat((Object)keyGen1.getPartitionPath((RowData)rowData1), (Matcher)CoreMatchers.is((Object)expectedPartition1));
        BinaryRowData rowData2 = TestData.insertRow(TestConfigurations.ROW_TYPE_DATE, new Object[]{null, StringData.fromString((String)"Danny"), 23, null});
        Assertions.assertThrows(HoodieKeyException.class, () -> TestRowDataKeyGen.lambda$testDateBasedKeyGenerator$6(keyGen1, (RowData)rowData2));
        String expectedPartition2 = dashed ? "1970-01-02" : "19700102";
        MatcherAssert.assertThat((Object)keyGen1.getPartitionPath((RowData)rowData2), (Matcher)CoreMatchers.is((Object)expectedPartition2));
        String expectedPartition3 = dashed ? "1970-01-03" : "19700103";
        BinaryRowData rowData3 = TestData.insertRow(TestConfigurations.ROW_TYPE_DATE, new Object[]{StringData.fromString((String)""), StringData.fromString((String)"Danny"), 23, 2});
        Assertions.assertThrows(HoodieKeyException.class, () -> TestRowDataKeyGen.lambda$testDateBasedKeyGenerator$7(keyGen1, (RowData)rowData3));
        MatcherAssert.assertThat((Object)keyGen1.getPartitionPath((RowData)rowData3), (Matcher)CoreMatchers.is((Object)expectedPartition3));
        conf.set(FlinkOptions.HIVE_STYLE_PARTITIONING, (Object)true);
        RowDataKeyGen keyGen2 = RowDataKeyGen.instance((Configuration)conf, (RowType)TestConfigurations.ROW_TYPE_DATE);
        MatcherAssert.assertThat((Object)keyGen2.getPartitionPath((RowData)rowData1), (Matcher)CoreMatchers.is((Object)("dt=" + expectedPartition1)));
        MatcherAssert.assertThat((Object)keyGen2.getPartitionPath((RowData)rowData2), (Matcher)CoreMatchers.is((Object)("dt=" + expectedPartition2)));
        MatcherAssert.assertThat((Object)keyGen2.getPartitionPath((RowData)rowData3), (Matcher)CoreMatchers.is((Object)("dt=" + expectedPartition3)));
    }

    @Test
    void testPrimaryKeylessWrite() {
        Configuration conf = TestConfigurations.getDefaultConf("path1");
        conf.setString(FlinkOptions.RECORD_KEY_FIELD, "");
        BinaryRowData rowData1 = TestData.insertRow(StringData.fromString((String)"id1"), StringData.fromString((String)"Danny"), 23, TimestampData.fromEpochMillis((long)1L), StringData.fromString((String)"par1"));
        RowDataKeyGen keyGen1 = RowDataKeyGen.instance((Configuration)conf, (RowType)TestConfigurations.ROW_TYPE);
        MatcherAssert.assertThat((Object)keyGen1.getRecordKey((RowData)rowData1), (Matcher)CoreMatchers.is((Object)"__empty__"));
        BinaryRowData rowData2 = TestData.insertRow(TestConfigurations.ROW_TYPE, new Object[]{null, StringData.fromString((String)"Danny"), 23, TimestampData.fromEpochMillis((long)1L), null});
        MatcherAssert.assertThat((Object)keyGen1.getRecordKey((RowData)rowData2), (Matcher)CoreMatchers.is((Object)"__empty__"));
        BinaryRowData rowData3 = TestData.insertRow(StringData.fromString((String)""), StringData.fromString((String)"Danny"), 23, TimestampData.fromEpochMillis((long)1L), StringData.fromString((String)""));
        MatcherAssert.assertThat((Object)keyGen1.getRecordKey((RowData)rowData3), (Matcher)CoreMatchers.is((Object)"__empty__"));
    }

    private static /* synthetic */ void lambda$testDateBasedKeyGenerator$7(RowDataKeyGen keyGen1, RowData rowData3) throws Throwable {
        keyGen1.getRecordKey(rowData3);
    }

    private static /* synthetic */ void lambda$testDateBasedKeyGenerator$6(RowDataKeyGen keyGen1, RowData rowData2) throws Throwable {
        keyGen1.getRecordKey(rowData2);
    }

    private static /* synthetic */ void lambda$testTimestampBasedKeyGenerator$5(RowDataKeyGen keyGen1, RowData rowData3) throws Throwable {
        keyGen1.getRecordKey(rowData3);
    }

    private static /* synthetic */ void lambda$testTimestampBasedKeyGenerator$4(RowDataKeyGen keyGen1, RowData rowData2) throws Throwable {
        keyGen1.getRecordKey(rowData2);
    }

    private static /* synthetic */ void lambda$testComplexKeyAndPartition$3(RowDataKeyGen keyGen1, RowData rowData3) throws Throwable {
        keyGen1.getRecordKey(rowData3);
    }

    private static /* synthetic */ void lambda$testComplexKeyAndPartition$2(RowDataKeyGen keyGen1, RowData rowData2) throws Throwable {
        keyGen1.getRecordKey(rowData2);
    }

    private static /* synthetic */ void lambda$testSimpleKeyAndPartition$1(RowDataKeyGen keyGen1, RowData rowData3) throws Throwable {
        keyGen1.getRecordKey(rowData3);
    }

    private static /* synthetic */ void lambda$testSimpleKeyAndPartition$0(RowDataKeyGen keyGen1, RowData rowData2) throws Throwable {
        keyGen1.getRecordKey(rowData2);
    }
}

