/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.catalog;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.types.DataType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.exception.HoodieCatalogException;
import org.apache.hudi.table.catalog.HoodieCatalogTestUtils;
import org.apache.hudi.table.catalog.HoodieHiveCatalog;
import org.apache.hudi.util.StreamerUtil;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.ValueSource;

public class TestHoodieHiveCatalog {
    TableSchema schema = TableSchema.builder().field("uuid", (DataType)DataTypes.INT().notNull()).field("name", DataTypes.STRING()).field("age", DataTypes.INT()).field("par1", DataTypes.STRING()).field("ts", DataTypes.BIGINT()).primaryKey(new String[]{"uuid"}).build();
    List<String> partitions = Collections.singletonList("par1");
    private static HoodieHiveCatalog hoodieCatalog;
    private final ObjectPath tablePath = new ObjectPath("default", "test");

    @BeforeAll
    public static void createCatalog() {
        hoodieCatalog = HoodieCatalogTestUtils.createHiveCatalog();
        hoodieCatalog.open();
    }

    @AfterEach
    public void dropTable() throws TableNotExistException {
        hoodieCatalog.dropTable(this.tablePath, true);
    }

    @AfterAll
    public static void closeCatalog() {
        if (hoodieCatalog != null) {
            hoodieCatalog.close();
        }
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testCreateAndGetHoodieTable(HoodieTableType tableType) throws Exception {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(FactoryUtil.CONNECTOR.key(), "hudi");
        options.put(FlinkOptions.TABLE_TYPE.key(), tableType.toString());
        CatalogTableImpl table = new CatalogTableImpl(this.schema, this.partitions, options, "hudi table");
        hoodieCatalog.createTable(this.tablePath, (CatalogBaseTable)table, false);
        Table hiveTable = hoodieCatalog.getHiveTable(this.tablePath);
        String fieldSchema = hiveTable.getSd().getCols().stream().map(f -> f.getName() + ":" + f.getType()).collect(Collectors.joining(","));
        String expectedFieldSchema = "_hoodie_commit_time:string,_hoodie_commit_seqno:string,_hoodie_record_key:string,_hoodie_partition_path:string,_hoodie_file_name:string,uuid:int,name:string,age:int,ts:bigint";
        Assertions.assertEquals((Object)expectedFieldSchema, (Object)fieldSchema);
        String partitionSchema = hiveTable.getPartitionKeys().stream().map(f -> f.getName() + ":" + f.getType()).collect(Collectors.joining(","));
        Assertions.assertEquals((Object)"par1:string", (Object)partitionSchema);
        String avroSchemaStr = (String)hiveTable.getParameters().get("spark.sql.sources.schema.part.0");
        String expectedAvroSchemaStr = "{\"type\":\"struct\",\"fields\":[{\"name\":\"_hoodie_commit_time\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}},{\"name\":\"_hoodie_commit_seqno\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}},{\"name\":\"_hoodie_record_key\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}},{\"name\":\"_hoodie_partition_path\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}},{\"name\":\"_hoodie_file_name\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}},{\"name\":\"uuid\",\"type\":\"integer\",\"nullable\":false,\"metadata\":{}},{\"name\":\"name\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}},{\"name\":\"age\",\"type\":\"integer\",\"nullable\":true,\"metadata\":{}},{\"name\":\"ts\",\"type\":\"long\",\"nullable\":true,\"metadata\":{}},{\"name\":\"par1\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}}]}";
        Assertions.assertEquals((Object)expectedAvroSchemaStr, (Object)avroSchemaStr);
        CatalogBaseTable table1 = hoodieCatalog.getTable(this.tablePath);
        Assertions.assertEquals((Object)"hudi", table1.getOptions().get(FactoryUtil.CONNECTOR.key()));
        Assertions.assertEquals((Object)tableType.toString(), table1.getOptions().get(FlinkOptions.TABLE_TYPE.key()));
        Assertions.assertEquals((Object)"uuid", table1.getOptions().get(FlinkOptions.RECORD_KEY_FIELD.key()));
        Assertions.assertNull(table1.getOptions().get(FlinkOptions.PRECOMBINE_FIELD.key()), (String)"preCombine key is not declared");
        String tableSchema = table1.getUnresolvedSchema().getColumns().stream().map(Schema.UnresolvedColumn::toString).collect(Collectors.joining(","));
        String expectedTableSchema = "`uuid` INT NOT NULL,`name` STRING,`age` INT,`par1` STRING,`ts` BIGINT";
        Assertions.assertEquals((Object)expectedTableSchema, (Object)tableSchema);
        Assertions.assertEquals(Collections.singletonList("uuid"), (Object)((Schema.UnresolvedPrimaryKey)table1.getUnresolvedSchema().getPrimaryKey().get()).getColumnNames());
        Assertions.assertEquals(Collections.singletonList("par1"), (Object)((CatalogTable)table1).getPartitionKeys());
        options.put(FlinkOptions.RECORD_KEY_FIELD.key(), "id");
        table = new CatalogTableImpl(this.schema, this.partitions, options, "hudi table");
        hoodieCatalog.alterTable(this.tablePath, (CatalogBaseTable)table, true);
        CatalogBaseTable table2 = hoodieCatalog.getTable(this.tablePath);
        Assertions.assertEquals((Object)"id", table2.getOptions().get(FlinkOptions.RECORD_KEY_FIELD.key()));
    }

    @Test
    public void testCreateExternalTable() throws TableAlreadyExistException, DatabaseNotExistException, TableNotExistException, IOException {
        HoodieHiveCatalog catalog = HoodieCatalogTestUtils.createHiveCatalog("myCatalog", true);
        catalog.open();
        HashMap<String, String> originOptions = new HashMap<String, String>();
        originOptions.put(FactoryUtil.CONNECTOR.key(), "hudi");
        CatalogTableImpl table = new CatalogTableImpl(this.schema, originOptions, "hudi table");
        catalog.createTable(this.tablePath, (CatalogBaseTable)table, false);
        Table table1 = catalog.getHiveTable(this.tablePath);
        Assertions.assertTrue((boolean)Boolean.parseBoolean((String)table1.getParameters().get("EXTERNAL")));
        Assertions.assertEquals((Object)"EXTERNAL_TABLE", (Object)table1.getTableType());
        catalog.dropTable(this.tablePath, false);
        Path path = new Path((String)table1.getParameters().get(FlinkOptions.PATH.key()));
        boolean created = StreamerUtil.fileExists((FileSystem)FSUtils.getFs((Path)path, (Configuration)new Configuration()), (Path)path);
        Assertions.assertTrue((boolean)created, (String)"Table should have been created");
    }

    @Test
    public void testCreateNonHoodieTable() throws TableAlreadyExistException, DatabaseNotExistException {
        CatalogTableImpl table = new CatalogTableImpl(this.schema, Collections.emptyMap(), "hudi table");
        try {
            hoodieCatalog.createTable(this.tablePath, (CatalogBaseTable)table, false);
        }
        catch (HoodieCatalogException e) {
            Assertions.assertEquals((Object)String.format("The %s is not hoodie table", this.tablePath.getObjectName()), (Object)e.getMessage());
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDropTable(boolean external) throws TableAlreadyExistException, DatabaseNotExistException, TableNotExistException, IOException {
        HoodieHiveCatalog catalog = HoodieCatalogTestUtils.createHiveCatalog("myCatalog", external);
        catalog.open();
        CatalogTableImpl catalogTable = new CatalogTableImpl(this.schema, Collections.singletonMap(FactoryUtil.CONNECTOR.key(), "hudi"), "hudi table");
        catalog.createTable(this.tablePath, (CatalogBaseTable)catalogTable, false);
        Table table = catalog.getHiveTable(this.tablePath);
        Assertions.assertEquals((Object)external, (Object)Boolean.parseBoolean((String)table.getParameters().get("EXTERNAL")));
        catalog.dropTable(this.tablePath, false);
        Path path = new Path((String)table.getParameters().get(FlinkOptions.PATH.key()));
        boolean existing = StreamerUtil.fileExists((FileSystem)FSUtils.getFs((Path)path, (Configuration)new Configuration()), (Path)path);
        Assertions.assertEquals((Object)external, (Object)existing);
    }

    @Test
    public void testAlterTable() throws Exception {
        HashMap<String, String> originOptions = new HashMap<String, String>();
        originOptions.put(FactoryUtil.CONNECTOR.key(), "hudi");
        CatalogTableImpl originTable = new CatalogTableImpl(this.schema, this.partitions, originOptions, "hudi table");
        hoodieCatalog.createTable(this.tablePath, (CatalogBaseTable)originTable, false);
        Table hiveTable = hoodieCatalog.getHiveTable(this.tablePath);
        Map newOptions = hiveTable.getParameters();
        newOptions.put("k", "v");
        CatalogTableImpl newTable = new CatalogTableImpl(this.schema, this.partitions, newOptions, "alter hudi table");
        hoodieCatalog.alterTable(this.tablePath, (CatalogBaseTable)newTable, false);
        hiveTable = hoodieCatalog.getHiveTable(this.tablePath);
        Assertions.assertEquals(hiveTable.getParameters().get(FactoryUtil.CONNECTOR.key()), (Object)"hudi");
        Assertions.assertEquals(hiveTable.getParameters().get("k"), (Object)"v");
    }

    @Test
    public void testRenameTable() throws Exception {
        HashMap<String, String> originOptions = new HashMap<String, String>();
        originOptions.put(FactoryUtil.CONNECTOR.key(), "hudi");
        CatalogTableImpl originTable = new CatalogTableImpl(this.schema, this.partitions, originOptions, "hudi table");
        hoodieCatalog.createTable(this.tablePath, (CatalogBaseTable)originTable, false);
        hoodieCatalog.renameTable(this.tablePath, "test1", false);
        Assertions.assertEquals((Object)hoodieCatalog.getHiveTable(new ObjectPath("default", "test1")).getTableName(), (Object)"test1");
        hoodieCatalog.renameTable(new ObjectPath("default", "test1"), "test", false);
    }
}

