/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.table.HoodieTableSource;
import org.apache.hudi.table.format.mor.MergeOnReadInputFormat;
import org.apache.hudi.utils.TestConfigurations;
import org.apache.hudi.utils.TestData;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHoodieTableSource {
    private static final Logger LOG = LoggerFactory.getLogger(TestHoodieTableSource.class);
    private Configuration conf;
    @TempDir
    File tempFile;

    void beforeEach() throws Exception {
        String path = this.tempFile.getAbsolutePath();
        this.conf = TestConfigurations.getDefaultConf(path);
        TestData.writeData(TestData.DATA_SET_INSERT, this.conf);
    }

    @Test
    void testGetReadPaths() throws Exception {
        this.beforeEach();
        HoodieTableSource tableSource = new HoodieTableSource(TestConfigurations.TABLE_SCHEMA, new Path(this.tempFile.getPath()), Arrays.asList(this.conf.getString(FlinkOptions.PARTITION_PATH_FIELD).split(",")), "default-par", this.conf);
        FileStatus[] fileStatuses = tableSource.getReadFiles();
        Assertions.assertNotNull((Object)fileStatuses);
        MatcherAssert.assertThat((Object)fileStatuses.length, (Matcher)Is.is((Object)4));
        HashMap<String, String> partitions = new HashMap<String, String>();
        partitions.put("partition", "par1");
        tableSource.applyPartitions(Collections.singletonList(partitions));
        FileStatus[] fileStatuses2 = tableSource.getReadFiles();
        Assertions.assertNotNull((Object)fileStatuses2);
        MatcherAssert.assertThat((Object)fileStatuses2.length, (Matcher)Is.is((Object)1));
    }

    @Test
    void testGetInputFormat() throws Exception {
        this.beforeEach();
        TestData.writeData(TestData.DATA_SET_INSERT, this.conf);
        HoodieTableSource tableSource = new HoodieTableSource(TestConfigurations.TABLE_SCHEMA, new Path(this.tempFile.getPath()), Arrays.asList(this.conf.getString(FlinkOptions.PARTITION_PATH_FIELD).split(",")), "default-par", this.conf);
        InputFormat inputFormat = tableSource.getInputFormat();
        MatcherAssert.assertThat((Object)inputFormat, (Matcher)Is.is((Matcher)CoreMatchers.instanceOf(FileInputFormat.class)));
        this.conf.setString(FlinkOptions.TABLE_TYPE, FlinkOptions.TABLE_TYPE_MERGE_ON_READ);
        inputFormat = tableSource.getInputFormat();
        MatcherAssert.assertThat((Object)inputFormat, (Matcher)Is.is((Matcher)CoreMatchers.instanceOf(MergeOnReadInputFormat.class)));
        this.conf.setString(FlinkOptions.QUERY_TYPE.key(), "incremental");
        Assertions.assertDoesNotThrow(() -> ((HoodieTableSource)tableSource).getInputFormat(), (String)"Query type: 'incremental' should be supported");
    }

    @Test
    void testGetTableAvroSchema() {
        HoodieTableSource tableSource = this.getEmptyStreamingSource();
        Assertions.assertNull((Object)tableSource.getMetaClient(), (String)"Streaming source with empty table path is allowed");
        String schemaFields = tableSource.getTableAvroSchema().getFields().stream().map(Schema.Field::name).collect(Collectors.joining(","));
        String expected = "_hoodie_commit_time,_hoodie_commit_seqno,_hoodie_record_key,_hoodie_partition_path,_hoodie_file_name,uuid,name,age,ts,partition";
        MatcherAssert.assertThat((Object)schemaFields, (Matcher)Is.is((Object)"_hoodie_commit_time,_hoodie_commit_seqno,_hoodie_record_key,_hoodie_partition_path,_hoodie_file_name,uuid,name,age,ts,partition"));
    }

    @Test
    void testDataSkippingFilterShouldBeNotNullWhenTableSourceIsCopied() {
        HoodieTableSource tableSource = this.getEmptyStreamingSource();
        CallExpression mockExpression = new CallExpression((FunctionDefinition)BuiltInFunctionDefinitions.IN, Collections.emptyList(), TestConfigurations.ROW_DATA_TYPE);
        List<CallExpression> expectedFilters = Collections.singletonList(mockExpression);
        tableSource.applyFilters(expectedFilters);
        HoodieTableSource copiedSource = (HoodieTableSource)tableSource.copy();
        List actualFilters = copiedSource.getFileIndex().getFilters();
        Assertions.assertEquals(expectedFilters, (Object)actualFilters);
    }

    @Test
    void testHoodieSourceCachedMetaClient() {
        HoodieTableSource tableSource = this.getEmptyStreamingSource();
        HoodieTableMetaClient metaClient = tableSource.getMetaClient();
        HoodieTableSource tableSourceCopy = (HoodieTableSource)tableSource.copy();
        MatcherAssert.assertThat((Object)metaClient, (Matcher)Is.is((Object)tableSourceCopy.getMetaClient()));
    }

    private HoodieTableSource getEmptyStreamingSource() {
        String path = this.tempFile.getAbsolutePath();
        this.conf = TestConfigurations.getDefaultConf(path);
        this.conf.setBoolean(FlinkOptions.READ_AS_STREAMING, true);
        return new HoodieTableSource(TestConfigurations.TABLE_SCHEMA, new Path(this.tempFile.getPath()), Arrays.asList(this.conf.getString(FlinkOptions.PARTITION_PATH_FIELD).split(",")), "default-par", this.conf);
    }
}

