/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.source.stats;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.source.stats.ColumnStatsIndices;
import org.apache.hudi.utils.TestConfigurations;
import org.apache.hudi.utils.TestData;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestColumnStatsIndices {
    @TempDir
    File tempFile;

    @Test
    void testTransposeColumnStatsIndex() throws Exception {
        String path = this.tempFile.getAbsolutePath();
        Configuration conf = TestConfigurations.getDefaultConf(path);
        conf.setBoolean(FlinkOptions.METADATA_ENABLED, true);
        conf.setBoolean(FlinkOptions.READ_DATA_SKIPPING_ENABLED, true);
        conf.setString("hoodie.metadata.index.column.stats.enable", "true");
        HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().enable(true).withMetadataIndexColumnStats(true).build();
        TestData.writeData(TestData.DATA_SET_INSERT, conf);
        String[] queryColumns1 = new String[]{"uuid", "age"};
        List indexRows1 = ColumnStatsIndices.readColumnStatsIndex((String)path, (HoodieMetadataConfig)metadataConfig, (String[])queryColumns1);
        Pair transposedIndexTable1 = ColumnStatsIndices.transposeColumnStatsIndex((List)indexRows1, (String[])queryColumns1, (RowType)TestConfigurations.ROW_TYPE);
        MatcherAssert.assertThat((String)"The schema columns should sort by natural order", (Object)Arrays.toString((Object[])transposedIndexTable1.getRight()), (Matcher)CoreMatchers.is((Object)"[age, uuid]"));
        List<RowData> transposed1 = TestColumnStatsIndices.filterOutFileNames((List)transposedIndexTable1.getLeft());
        MatcherAssert.assertThat((Object)transposed1.size(), (Matcher)CoreMatchers.is((Object)4));
        String expected = "[+I(2,18,20,0,id5,id6,0), +I(2,23,33,0,id1,id2,0), +I(2,31,53,0,id3,id4,0), +I(2,44,56,0,id7,id8,0)]";
        MatcherAssert.assertThat((Object)transposed1.toString(), (Matcher)CoreMatchers.is((Object)"[+I(2,18,20,0,id5,id6,0), +I(2,23,33,0,id1,id2,0), +I(2,31,53,0,id3,id4,0), +I(2,44,56,0,id7,id8,0)]"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ColumnStatsIndices.readColumnStatsIndex((String)path, (HoodieMetadataConfig)metadataConfig, (String[])new String[0]));
    }

    private static List<RowData> filterOutFileNames(List<RowData> indexRows) {
        return indexRows.stream().map(row -> {
            GenericRowData gr = (GenericRowData)row;
            GenericRowData converted = new GenericRowData(gr.getArity() - 1);
            for (int i = 1; i < gr.getArity(); ++i) {
                converted.setField(i - 1, gr.getField(i));
            }
            return converted;
        }).sorted(Comparator.comparingInt(r -> r.getInt(1))).collect(Collectors.toList());
    }
}

