/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.source;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.source.IncrementalInputSplits;
import org.apache.hudi.utils.TestConfigurations;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestIncrementalInputSplits
extends HoodieCommonTestHarness {
    @BeforeEach
    private void init() throws IOException {
        this.initPath();
        this.initMetaClient();
    }

    @Test
    void testFilterInstantsWithRange() {
        HoodieActiveTimeline timeline = new HoodieActiveTimeline(this.metaClient, true);
        Configuration conf = TestConfigurations.getDefaultConf(this.basePath);
        IncrementalInputSplits iis = IncrementalInputSplits.builder().conf(conf).path(new Path(this.basePath)).rowType(TestConfigurations.ROW_TYPE).build();
        HoodieInstant commit1 = new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", "1");
        HoodieInstant commit2 = new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", "2");
        HoodieInstant commit3 = new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", "3");
        timeline.createNewInstant(commit1);
        timeline.createNewInstant(commit2);
        timeline.createNewInstant(commit3);
        timeline = timeline.reload();
        List instantRange2 = iis.filterInstantsWithRange((HoodieTimeline)timeline, "1");
        Assertions.assertEquals((int)2, (int)instantRange2.size());
        Assertions.assertIterableEquals(Arrays.asList(commit2, commit3), (Iterable)instantRange2);
        List instantRange1 = iis.filterInstantsWithRange((HoodieTimeline)timeline, null);
        Assertions.assertEquals((int)1, (int)instantRange1.size());
        Assertions.assertIterableEquals(Collections.singletonList(commit3), (Iterable)instantRange1);
        conf.set(FlinkOptions.READ_START_COMMIT, (Object)"1");
        conf.set(FlinkOptions.READ_END_COMMIT, (Object)"3");
        List instantRange3 = iis.filterInstantsWithRange((HoodieTimeline)timeline, null);
        Assertions.assertEquals((int)3, (int)instantRange3.size());
        Assertions.assertIterableEquals(Arrays.asList(commit1, commit2, commit3), (Iterable)instantRange3);
    }

    @Test
    void testFilterInstantsByCondition() throws IOException {
        HoodieActiveTimeline timeline = new HoodieActiveTimeline(this.metaClient, true);
        Configuration conf = TestConfigurations.getDefaultConf(this.basePath);
        IncrementalInputSplits iis = IncrementalInputSplits.builder().conf(conf).path(new Path(this.basePath)).rowType(TestConfigurations.ROW_TYPE).build();
        HoodieInstant commit1 = new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", "1");
        HoodieInstant commit2 = new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", "2");
        HoodieInstant commit3 = new HoodieInstant(HoodieInstant.State.REQUESTED, "replacecommit", "3");
        timeline.createNewInstant(commit1);
        timeline.createNewInstant(commit2);
        timeline.createNewInstant(commit3);
        commit3 = timeline.transitionReplaceRequestedToInflight(commit3, Option.empty());
        HoodieCommitMetadata commitMetadata = CommitUtils.buildMetadata(new ArrayList(), new HashMap(), (Option)Option.empty(), (WriteOperationType)WriteOperationType.CLUSTER, (String)"", (String)"replacecommit");
        timeline.transitionReplaceInflightToComplete(HoodieTimeline.getReplaceCommitInflightInstant((String)commit3.getTimestamp()), Option.of((Object)commitMetadata.toJsonString().getBytes(StandardCharsets.UTF_8)));
        timeline = timeline.reload();
        conf.set(FlinkOptions.READ_END_COMMIT, (Object)"3");
        HoodieTimeline resTimeline = iis.filterInstantsByCondition((HoodieTimeline)timeline);
        Assertions.assertEquals((int)3, (int)resTimeline.getInstants().collect(Collectors.toList()).size());
    }
}

